/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.lang.reflect.Field;
import java.util.List;
import org.databene.contiperf.Config;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.junit.ContiPerfRule;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockContiPerfClassRunner
extends BlockJUnit4ClassRunner {
    protected ContiPerfRule rule;

    public BlockContiPerfClassRunner(Class<?> testClass, Object suite) throws InitializationError {
        super(testClass);
        this.rule = new ContiPerfRule(this.findLoggers(suite), suite);
    }

    protected List<MethodRule> rules(Object test) {
        List rules = super.rules(test);
        boolean configured = false;
        for (MethodRule targetRule : rules) {
            if (!(targetRule instanceof ContiPerfRule)) continue;
            ContiPerfRule cpRule = (ContiPerfRule)targetRule;
            if (!cpRule.configuredExecutionLogger) {
                cpRule.setExecutionLogger(this.rule.getExecutionLogger());
            }
            configured = true;
        }
        if (!configured) {
            rules.add(this.rule);
        }
        return rules;
    }

    private ExecutionLogger findLoggers(Object suite) {
        for (Field field : suite.getClass().getFields()) {
            if (!ExecutionLogger.class.isAssignableFrom(field.getType())) continue;
            try {
                return (ExecutionLogger)field.get(suite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Config.instance().createDefaultExecutionLogger();
    }
}

