/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.lang.annotation.Annotation;
import org.databene.contiperf.Config;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.Required;
import org.databene.contiperf.junit.PerfTestStatement;
import org.databene.contiperf.util.ContiPerfUtil;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContiPerfRule
implements MethodRule {
    private ExecutionConfig defaultExecutionConfig;
    private PerformanceRequirement defaultRequirements;
    protected ExecutionLogger executionLogger;
    protected final boolean configuredExecutionLogger;

    public ContiPerfRule() {
        this(null);
    }

    public ContiPerfRule(ExecutionLogger executionLogger) {
        this(executionLogger, null);
    }

    public ContiPerfRule(ExecutionLogger executionLogger, Object suite) {
        if (executionLogger == null) {
            this.executionLogger = Config.instance().createDefaultExecutionLogger();
            this.configuredExecutionLogger = false;
        } else {
            this.executionLogger = executionLogger;
            this.configuredExecutionLogger = true;
        }
        if (suite != null) {
            Class<?> suiteClass = suite.getClass();
            this.defaultExecutionConfig = ContiPerfRule.configurePerfTest(suiteClass.getAnnotation(PerfTest.class), suiteClass.getName());
            this.defaultRequirements = ContiPerfUtil.mapRequired(suiteClass.getAnnotation(Required.class));
        }
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Config config = Config.instance();
        if (!config.active()) {
            return base;
        }
        String testId = ContiPerfRule.methodName(method, target);
        return new PerfTestStatement(base, testId, this.executionConfig(method, testId), this.requirements(method, testId), this.executionLogger);
    }

    public ExecutionLogger getExecutionLogger() {
        return this.executionLogger;
    }

    void setExecutionLogger(ExecutionLogger executionLogger) {
        this.executionLogger = executionLogger;
    }

    private ExecutionConfig executionConfig(FrameworkMethod method, String methodName) {
        PerfTest annotation = ContiPerfRule.annotationOfMethodOrClass(method, PerfTest.class);
        if (annotation != null) {
            return ContiPerfRule.configurePerfTest(annotation, methodName);
        }
        if (this.defaultExecutionConfig != null) {
            return this.defaultExecutionConfig;
        }
        return new ExecutionConfig(1);
    }

    private PerformanceRequirement requirements(FrameworkMethod method, String testId) {
        Required annotation = ContiPerfRule.annotationOfMethodOrClass(method, Required.class);
        if (annotation != null) {
            return ContiPerfUtil.mapRequired(annotation);
        }
        if (this.defaultRequirements != null) {
            return this.defaultRequirements;
        }
        return null;
    }

    private static <T extends Annotation> T annotationOfMethodOrClass(FrameworkMethod method, Class<T> annotationClass) {
        Annotation methodAnnotation = method.getAnnotation(annotationClass);
        if (methodAnnotation != null) {
            return (T)methodAnnotation;
        }
        T classAnnotation = method.getMethod().getDeclaringClass().getAnnotation(annotationClass);
        return classAnnotation;
    }

    public static ExecutionConfig configurePerfTest(PerfTest annotation, String testId) {
        int count;
        ExecutionConfig config = ContiPerfUtil.mapPerfTestAnnotation(annotation);
        if (annotation == null) {
            config = new ExecutionConfig(1);
        }
        if ((count = Config.instance().getInvocationCount(testId)) >= 0) {
            config.setInvocations(count);
        }
        return config;
    }

    private static String methodName(FrameworkMethod method, Object target) {
        return target.getClass().getName() + '.' + method.getName();
    }
}

