/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.util.concurrent.atomic.AtomicLong;
import org.databene.contiperf.ConcurrentRunner;
import org.databene.contiperf.CountRunner;
import org.databene.contiperf.EmptyArgumentsProvider;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.InvocationRunner;
import org.databene.contiperf.PerfTestConfigurationError;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.PerformanceTracker;
import org.databene.contiperf.TimedRunner;
import org.databene.contiperf.junit.JUnitInvoker;
import org.junit.runners.model.Statement;

final class PerfTestStatement
extends Statement {
    private String id;
    private final Statement base;
    private ExecutionLogger logger;
    private ExecutionConfig config;
    private PerformanceRequirement requirement;

    PerfTestStatement(Statement base, String id, ExecutionConfig config, PerformanceRequirement requirement, ExecutionLogger logger) {
        this.base = base;
        this.id = id;
        this.config = config;
        this.requirement = requirement;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        System.out.println(this.id);
        JUnitInvoker invoker = new JUnitInvoker(this.id, this.base);
        PerformanceTracker tracker = new PerformanceTracker(invoker, this.requirement, this.config.isCancelOnViolation(), this.logger);
        InvocationRunner runner = this.createRunner(tracker);
        try {
            runner.run();
        }
        finally {
            tracker.stop();
            runner.close();
            tracker.clear();
        }
    }

    private InvocationRunner createRunner(PerformanceTracker tracker) {
        InvocationRunner runner;
        EmptyArgumentsProvider provider = new EmptyArgumentsProvider();
        int threads = this.config.getThreads();
        int duration = this.config.getDuration();
        int invocations = this.config.getInvocations();
        if (duration > 0) {
            if (threads == 1) {
                runner = new TimedRunner(tracker, provider, duration);
            } else {
                InvocationRunner[] runners = new InvocationRunner[threads];
                for (int i = 0; i < threads; ++i) {
                    runners[i] = new TimedRunner(tracker, provider, duration);
                }
                runner = new ConcurrentRunner(this.id, runners);
            }
        } else if (invocations >= 0) {
            AtomicLong counter = new AtomicLong(invocations);
            if (threads == 1) {
                runner = new CountRunner(tracker, provider, counter, false);
            } else {
                InvocationRunner[] runners = new InvocationRunner[threads];
                for (int i = 0; i < threads; ++i) {
                    runners[i] = new CountRunner(tracker, provider, counter, false);
                }
                runner = new ConcurrentRunner(this.id, runners);
            }
        } else {
            throw new PerfTestConfigurationError("No useful invocation count or duration defined");
        }
        return runner;
    }
}

