/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.util.ContiPerfUtil;

public class FileExecutionLogger
implements ExecutionLogger {
    private static final String FILENAME = "target/contiperf/contiperf.log";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static boolean firstCall = true;
    static AtomicLong invocationCount = new AtomicLong();

    public FileExecutionLogger() {
        if (firstCall) {
            this.createSummaryFile();
            firstCall = false;
        }
    }

    public void logInvocation(String id, int latency, long startTime) {
        invocationCount.incrementAndGet();
        System.out.println(id + ',' + latency + ',' + startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSummary(String id, long elapsedTime, long invocationCount, long startTime) {
        FileOutputStream out = null;
        String message = id + "," + elapsedTime + ',' + invocationCount + ',' + startTime + LINE_SEPARATOR;
        try {
            out = new FileOutputStream(FILENAME, true);
            ((OutputStream)out).write(message.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    public long invocationCount() {
        return invocationCount.get();
    }

    private void createSummaryFile() {
        File file = new File(".", FILENAME);
        try {
            this.ensureDirectoryExists(file.getParentFile());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to create directory: " + file.getAbsolutePath());
        }
    }

    private void ensureDirectoryExists(File dir) throws FileNotFoundException {
        File parent = dir.getParentFile();
        if (!dir.exists()) {
            if (parent == null) {
                throw new FileNotFoundException();
            }
            this.ensureDirectoryExists(parent);
            dir.mkdir();
        }
    }
}

