/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.Tensor;
import deepboof.graph.FunctionSequence;
import deepboof.io.torch7.ParseBinaryTorch7;
import deepboof.io.torch7.SequenceAndParameters;
import deepboof.tensors.Tensor_F32;
import java.io.File;
import java.io.IOException;

public class TorchUtilities {
    public static boolean validateNetwork(File directory, boolean exitOnFail) throws IOException {
        ParseBinaryTorch7 parser = new ParseBinaryTorch7();
        SequenceAndParameters sequence = (SequenceAndParameters)parser.parseIntoBoof(new File(directory, "model.net"));
        FunctionSequence network = sequence.createForward(3, 32, 32);
        Tensor_F32 input = (Tensor_F32)parser.parseIntoBoof(new File(directory, "test_input.t7"));
        Tensor_F32 expected = (Tensor_F32)parser.parseIntoBoof(new File(directory, "test_output.t7"));
        Tensor_F32 found = (Tensor_F32)expected.createLike();
        network.process((Tensor)input, (Tensor)found);
        for (int i = 0; i < expected.length(); ++i) {
            double error = Math.abs(expected.d[i] - found.d[i]);
            if (!(error > 0.001)) continue;
            if (exitOnFail) {
                System.err.println("network test failed at " + i + "  error = " + error);
                System.exit(1);
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        File directory = new File("data/torch_models/likevgg_cifar10");
        System.out.println("Loading and evaluating...");
        TorchUtilities.validateNetwork(directory, true);
        System.out.println("Passed!");
    }
}

