/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.backward.standard;

import deepboof.backward.DActivationTanH;
import deepboof.impl.backward.standard.ElementWiseDFunction;
import deepboof.tensors.Tensor_F64;
import java.util.List;

public class DActivationTanH_F64
extends ElementWiseDFunction<Tensor_F64>
implements DActivationTanH<Tensor_F64> {
    Tensor_F64 memory = new Tensor_F64();

    @Override
    protected void _backwards(Tensor_F64 input, Tensor_F64 dout, Tensor_F64 gradientInput, List<Tensor_F64> gradientParameters) {
        this.memory.reshape(input.getShape());
        int length = input.length();
        int indexDIn = gradientInput.startIndex;
        int indexDout = dout.startIndex;
        for (int i = 0; i < length; ++i) {
            double tanh = this.memory.d[i];
            gradientInput.d[indexDIn++] = (1.0 - tanh * tanh) * dout.d[indexDout++];
        }
    }

    public void _forward(Tensor_F64 input, Tensor_F64 output) {
        this.memory.reshape(input.getShape());
        int length = input.length();
        int indexIn = input.startIndex;
        int indexOut = output.startIndex;
        for (int i = 0; i < length; ++i) {
            double v;
            output.d[indexOut + i] = v = Math.tanh(input.d[indexIn + i]);
            this.memory.d[i] = v;
        }
    }

    public Class<Tensor_F64> getTensorType() {
        return Tensor_F64.class;
    }
}

