/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthDayMonthlyExpander
extends ByExpander {
    private final int[] mMonthDays;

    public ByMonthDayMonthlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mMonthDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYMONTHDAY));
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int monthDays = calendarMetrics.getDaysPerPackedMonth(year, month);
        int[] nArray = this.mMonthDays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + monthDays + 1;
            }
            if (0 >= actualDay) continue;
            this.addInstance(Instance.setDayOfMonth((long)instance, (int)actualDay));
        }
    }
}

