/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.Arrays;

final class LongArray {
    private static final int DEFAULT_SIZE = 48;
    private long[] mLongs;
    private int mCount = 0;
    private int mPos = 0;
    private boolean mSorted = true;

    public LongArray() {
        this(48);
    }

    public LongArray(int size) {
        this.mLongs = new long[size];
    }

    public void add(long data) {
        int count = this.mCount;
        long[] longs = this.mLongs;
        int len = longs.length;
        if (count == len) {
            longs = this.resizeBuffer(len + (len >> 1));
        }
        this.mSorted &= count == 0 || data > longs[count - 1];
        longs[count++] = data;
        this.mCount = count;
    }

    private long[] resizeBuffer(int newSize) {
        long[] newBuffer = new long[newSize];
        long[] oldBuffer = this.mLongs;
        System.arraycopy(oldBuffer, 0, newBuffer, 0, Math.min(oldBuffer.length, newSize));
        this.mLongs = newBuffer;
        return newBuffer;
    }

    public void sort() {
        if (!this.mSorted) {
            Arrays.sort(this.mLongs, 0, this.mCount);
            this.mSorted = true;
        }
    }

    public void clear() {
        this.mCount = 0;
        this.mPos = 0;
        this.mSorted = true;
    }

    public int size() {
        return this.mCount;
    }

    public boolean hasNext() {
        return this.mPos < this.mCount;
    }

    public long next() {
        if (this.mPos >= this.mCount) {
            throw new ArrayIndexOutOfBoundsException("no more elements");
        }
        return this.mLongs[this.mPos++];
    }

    public long peek() {
        if (this.mPos >= this.mCount) {
            throw new ArrayIndexOutOfBoundsException("no more elements");
        }
        return this.mLongs[this.mPos];
    }

    public void deduplicate() {
        if (this.mSorted) {
            return;
        }
        int count = this.mCount;
        this.sort();
        long[] longs = this.mLongs;
        int next = 1;
        long last = longs[0];
        for (int i = 1; i < count; ++i) {
            long current = longs[i];
            if (current <= last) continue;
            longs[next++] = last = current;
        }
        this.mCount = next;
    }
}

