/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.HashMap;
import java.util.Map;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.GregorianCalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.IslamicCalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.JulianCalendarMetrics;

public final class UnicodeCalendarScales {
    private static final Map<String, CalendarMetrics.CalendarMetricsFactory> CALENDAR_SCALES = new HashMap<String, CalendarMetrics.CalendarMetricsFactory>(10);

    public static CalendarMetrics.CalendarMetricsFactory getCalendarMetricsForName(String calendarScaleName) {
        return CALENDAR_SCALES.get(calendarScaleName);
    }

    static {
        CALENDAR_SCALES.put("GREGORIAN", GregorianCalendarMetrics.FACTORY);
        CALENDAR_SCALES.put("GREGORY", GregorianCalendarMetrics.FACTORY);
        CALENDAR_SCALES.put("JULIAN", JulianCalendarMetrics.FACTORY);
        CALENDAR_SCALES.put("JULIUS", JulianCalendarMetrics.FACTORY);
        CALENDAR_SCALES.put("ISLAMIC-TLBA", (CalendarMetrics.CalendarMetricsFactory)new IslamicCalendarMetrics.IslamicCalendarMetricsFactory("ISLAMIC-TLBA", IslamicCalendarMetrics.LeapYearPattern.II, false));
        CALENDAR_SCALES.put("ISLAMIC-CIVIL", (CalendarMetrics.CalendarMetricsFactory)new IslamicCalendarMetrics.IslamicCalendarMetricsFactory("ISLAMIC-CIVIL", IslamicCalendarMetrics.LeapYearPattern.II, true));
        CALENDAR_SCALES.put("ISLAMICC", CALENDAR_SCALES.get("ISLAMIC-CIVIL"));
    }
}

