/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.AbstractCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.CScreenDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.ScreenResizeRequestHandler;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.common.mode.CExternalizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CScreenDockStationHandle;
import bibliothek.gui.dock.common.perspective.CExternalizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.facile.station.screen.WindowProviderVisibility;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExternalizeArea
extends AbstractCStation<CScreenDockStation> {
    public static final Path TYPE_ID = new Path(new String[]{"dock", "CExternalizeArea"});
    private ScreenResizeRequestHandler handler;
    private CScreenDockStationHandle handle;
    private WindowProviderVisibility visibility;

    public CExternalizeArea(CControl control, String id) {
        this.init(control, id);
    }

    private void init(CControl control, String id) {
        CommonDockStation<ScreenDockStation, CScreenDockStation> station = control.getFactory().createScreenDockStation(control.getRootWindow(), new CommonStationDelegate<CScreenDockStation>(){

            @Override
            public boolean isTitleDisplayed(DockTitleVersion title) {
                return false;
            }

            @Override
            public CStation<CScreenDockStation> getStation() {
                return CExternalizeArea.this;
            }

            @Override
            public DockActionSource[] getSources() {
                return new DockActionSource[0];
            }

            @Override
            public CDockable getDockable() {
                return null;
            }
        });
        this.init(station.asDockStation(), id, CExternalizedLocation.STATION);
        this.handler = new ScreenResizeRequestHandler((ScreenDockStation)this.getStation());
        this.visibility = new WindowProviderVisibility((ScreenDockStation)this.getStation());
        ((CScreenDockStation)this.getStation()).setShowing(false);
    }

    @Override
    protected void install(CControlAccess access) {
        access.getOwner().addResizeRequestListener(this.handler);
        this.visibility.setProvider(access.getOwner().getRootWindow());
        if (this.handle == null) {
            this.handle = new CScreenDockStationHandle(this, access.getLocationManager());
        }
        CExternalizedMode externalizedMode = access.getLocationManager().getExternalizedMode();
        CMaximizedMode maximizedMode = access.getLocationManager().getMaximizedMode();
        externalizedMode.add(this.handle.getExternalizedModeArea());
        if (externalizedMode.getDefaultArea() == null) {
            externalizedMode.setDefaultArea(this.handle.getExternalizedModeArea());
        }
        maximizedMode.add(this.handle.getMaximizedModeArea());
    }

    @Override
    protected void uninstall(CControlAccess access) {
        this.visibility.setProvider(null);
        ((CScreenDockStation)this.getStation()).setShowing(false);
        access.getOwner().removeResizeRequestListener(this.handler);
        access.getLocationManager().getExternalizedMode().remove(this.handle.getExternalizedModeArea().getUniqueId());
        access.getLocationManager().getMaximizedMode().remove(this.handle.getMaximizedModeArea().getUniqueId());
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CExternalizePerspective(this.getUniqueId(), this.getTypeId());
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }
}

