/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.behavior;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.behavior.ExternalizingCGridArea;
import bibliothek.gui.dock.common.behavior.ExternalizingCGridAreaFactory;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.LayoutLocked;

public class ExternalizingCGridAreaConfiguration {
    private CControl control;
    private SplitInserter splitInserter;
    private ExternalizingCGridAreaFactory factory;
    private boolean installed = false;

    public static ExternalizingCGridAreaConfiguration installOn(CControl control) {
        ExternalizingCGridAreaConfiguration config = new ExternalizingCGridAreaConfiguration(control);
        config.install();
        return config;
    }

    public ExternalizingCGridAreaConfiguration(CControl control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
        this.factory = new ExternalizingCGridAreaFactory(control);
    }

    protected SplitInserter getSplitInserter() {
        if (this.splitInserter == null) {
            this.splitInserter = this.createSplitInserter();
        }
        return this.splitInserter;
    }

    protected SplitInserter createSplitInserter() {
        return new SplitInserter();
    }

    public CControl getControl() {
        return this.control;
    }

    protected ExternalizingCGridArea createGridArea() {
        return new ExternalizingCGridArea(this.control);
    }

    public void install() {
        if (this.installed) {
            throw new IllegalStateException("already installed");
        }
        this.installed = true;
        this.getScreenDockStation().addDockStationListener((DockStationListener)this.getSplitInserter());
        this.control.addSingleDockableFactory(ExternalizingCGridAreaFactory.PATTERN, (SingleCDockableFactory)this.factory);
    }

    public void uninstall() {
        if (!this.installed) {
            throw new IllegalStateException("not installed");
        }
        this.getScreenDockStation().removeDockStationListener((DockStationListener)this.getSplitInserter());
        this.control.removeSingleDockableFactory(this.factory);
    }

    protected DockStation getScreenDockStation() {
        CStation<?> screen = this.control.getStation("external");
        return screen.getStation();
    }

    @LayoutLocked(locked=false)
    protected class SplitInserter
    extends DockStationAdapter {
        protected SplitInserter() {
        }

        public void dockableAdded(DockStation station, final Dockable dockable) {
            if (!(dockable instanceof SplitDockStation)) {
                DockHierarchyLock lock = ExternalizingCGridAreaConfiguration.this.control.getController().getHierarchyLock();
                lock.onRelease(new Runnable(){

                    public void run() {
                        SplitInserter.this.checkAndReplace(dockable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndReplace(Dockable dockable) {
            DockStation station = dockable.getDockParent();
            if (!(station instanceof ScreenDockStation)) {
                return;
            }
            DockController controller = ExternalizingCGridAreaConfiguration.this.control.getController();
            try {
                controller.freezeLayout();
                ExternalizingCGridArea split = ExternalizingCGridAreaConfiguration.this.createGridArea();
                ExternalizingCGridAreaConfiguration.this.control.addDockable(split);
                station.replace(dockable, (Dockable)split.getStation());
                split.getStation().drop(dockable);
            }
            finally {
                controller.meltLayout();
            }
        }
    }
}

