/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocationMode<A extends ModeArea>
implements Iterable<A>,
LocationMode {
    private Map<String, A> areas = new HashMap<String, A>();
    private List<A> areaOrder = new LinkedList<A>();
    private A defaultArea;
    private LocationModeManager<?> manager;
    private List<LocationModeListener> listeners = new ArrayList<LocationModeListener>();
    private DockController controller;
    private AreaListener modeAreaListener = new AreaListener();
    private ModeManagerListener<Location, LocationMode> managerListener = new ManagerListener();
    private Map<Dockable, DockableHandle> handles = new HashMap<Dockable, DockableHandle>();
    private LocationModeActionProvider actionProvider = new DefaultLocationModeActionProvider();
    private boolean autoFocus = true;

    public void setActionProvider(LocationModeActionProvider actionProvider) {
        if (actionProvider == null) {
            throw new IllegalArgumentException("actionProvider must not be null");
        }
        if (!this.handles.isEmpty()) {
            throw new IllegalStateException("can only set actionProvider if no Dockables are currently showing actions of the old provider");
        }
        this.actionProvider = actionProvider;
    }

    @Override
    public void setManager(LocationModeManager<?> manager) {
        if (this.manager != null) {
            for (ModeArea area : this.areas.values()) {
                area.removeModeAreaListener(this.modeAreaListener);
            }
        }
        this.manager = manager;
        if (this.manager != null) {
            for (ModeArea area : this.areas.values()) {
                area.addModeAreaListener(this.modeAreaListener);
            }
            this.manager.addModeManagerListener(this.managerListener);
        }
    }

    @Override
    public LocationModeManager<?> getManager() {
        return this.manager;
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        for (ModeArea area : this.areas.values()) {
            area.setController(controller);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addLocationModeListener(LocationModeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeLocationModeListener(LocationModeListener listener) {
        this.listeners.remove(listener);
    }

    protected LocationModeListener[] listeners() {
        return this.listeners.toArray(new LocationModeListener[this.listeners.size()]);
    }

    @Override
    public boolean shouldAutoFocus() {
        return this.autoFocus;
    }

    public void setShouldAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public void add(A area) {
        if (area == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        String key = area.getUniqueId();
        if (this.areas.containsKey(key)) {
            throw new IllegalArgumentException("key '" + key + "' already in use");
        }
        area.setController(this.getController());
        area.setMode(this);
        this.areas.put(key, area);
        this.areaOrder.add(area);
        if (this.getManager() != null) {
            area.addModeAreaListener(this.modeAreaListener);
        }
    }

    public A remove(String key) {
        ModeArea area = (ModeArea)this.areas.remove(key);
        if (this.defaultArea == area) {
            this.defaultArea = null;
        }
        if (area != null) {
            area.setController(null);
            area.setMode(null);
            area.removeModeAreaListener(this.modeAreaListener);
            this.areaOrder.remove(area);
        }
        return (A)area;
    }

    @Override
    public Iterator<A> iterator() {
        return this.areas.values().iterator();
    }

    public void setDefaultArea(A defaultArea) {
        if (defaultArea != null && !this.areas.containsKey(defaultArea.getUniqueId())) {
            throw new IllegalArgumentException("default area must be registered, call 'add' first");
        }
        this.defaultArea = defaultArea;
    }

    public A getDefaultArea() {
        if (this.defaultArea == null) {
            for (ModeArea area : this.areaOrder) {
                if (!area.autoDefaultArea()) continue;
                return (A)area;
            }
        }
        return this.defaultArea;
    }

    public A get(String key) {
        return (A)((ModeArea)this.areas.get(key));
    }

    @Override
    public DockStation getRepresentation(String uniqueId) {
        A area = this.get(uniqueId);
        if (area == null) {
            return null;
        }
        return area.getStation();
    }

    public A get(Dockable dockable) {
        return this.get(dockable, false);
    }

    public A get(Dockable dockable, boolean locationRoot) {
        while (dockable != null) {
            for (ModeArea area : this.areas.values()) {
                if (locationRoot && !area.isLocationRoot() || !area.isChild(dockable)) continue;
                return (A)area;
            }
            DockStation station = dockable.getDockParent();
            if (station == null) {
                return null;
            }
            dockable = station.asDockable();
        }
        return null;
    }

    public A get(DockStation station) {
        while (station != null) {
            for (ModeArea area : this) {
                if (area.getStation() != station) continue;
                return (A)area;
            }
            Dockable dockable = station.asDockable();
            station = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    @Override
    public Location aside(AsideRequest request, Location location) {
        A area = this.get(location.getRoot());
        if (area == null) {
            return null;
        }
        AsideAnswer answer = request.execute(area.getStation());
        if (answer.isCanceled()) {
            return null;
        }
        return new Location(this.getUniqueIdentifier(), location.getRoot(), answer.getLocation());
    }

    @Override
    public DockActionSource getActionsFor(Dockable dockable, Mode<Location> mode) {
        if (mode == this) {
            return null;
        }
        if (!this.isModeAvailable(dockable) || this.isModeHidden(dockable)) {
            return null;
        }
        DockableHandle handle = this.handles.get(dockable);
        if (handle == null) {
            return null;
        }
        return handle.getActions(mode);
    }

    protected boolean isModeAvailable(Dockable dockable) {
        LocationModeManager<?> manager = this.getManager();
        if (manager == null) {
            return false;
        }
        return manager.isModeAvailable(dockable, this.getExtendedMode());
    }

    protected boolean isModeHidden(Dockable dockable) {
        LocationModeManager<?> manager = this.getManager();
        if (manager == null) {
            return false;
        }
        return manager.isModeHidden(dockable, this.getExtendedMode());
    }

    @Override
    public boolean isRepresenting(DockStation station) {
        for (ModeArea area : this.areas.values()) {
            if (area.getStation() != station) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(Dockable dockable, Location history, AffectedSet set) {
        LocationModeEvent event = new LocationModeEvent(this, history, dockable, set);
        for (LocationModeListener listener : this.listeners()) {
            listener.applyStarting(event);
        }
        if (!event.isDone()) {
            this.runApply(dockable, history, set);
            event.done();
        }
        for (LocationModeListener listener : this.listeners()) {
            listener.applyDone(event);
        }
    }

    protected abstract void runApply(Dockable var1, Location var2, AffectedSet var3);

    protected DockableHandle createHandle(Dockable dockable) {
        return new DockableHandle(dockable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DockableHandle {
        private Dockable dockable;
        private DockActionSource source;

        public DockableHandle(Dockable dockable) {
            this.dockable = dockable;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void destroy() {
            AbstractLocationMode.this.actionProvider.destroy(this.dockable, this.source);
            this.dockable = null;
            this.source = null;
        }

        public DockActionSource getActions(Mode<Location> mode) {
            this.source = AbstractLocationMode.this.actionProvider.getActions(this.dockable, mode, this.source);
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagerListener
    implements ModeManagerListener<Location, LocationMode> {
        private ManagerListener() {
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            if (!AbstractLocationMode.this.handles.containsKey(dockable)) {
                DockableHandle handle = AbstractLocationMode.this.createHandle(dockable);
                AbstractLocationMode.this.handles.put(dockable, handle);
            }
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            DockableHandle handle = (DockableHandle)AbstractLocationMode.this.handles.remove(dockable);
            if (handle != null) {
                handle.destroy();
            }
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AreaListener
    implements ModeAreaListener {
        private AreaListener() {
        }

        @Override
        public void internalLocationChange(ModeArea source, Set<Dockable> dockables) {
            LocationModeManager<?> manager = AbstractLocationMode.this.getManager();
            if (manager != null) {
                if (manager.isOnTransaction()) {
                    manager.addAffected(dockables);
                } else {
                    for (Dockable dockable : dockables) {
                        manager.refresh(dockable, true);
                    }
                }
            }
        }
    }
}

