/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.File;
import java.io.IOException;
import org.fest.assertions.FileContentComparator;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Arrays;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAssert
extends GenericAssert<FileAssert, File> {
    private final FileContentComparator comparator;

    protected FileAssert(File actual) {
        this(actual, new FileContentComparator());
    }

    FileAssert(File actual, FileContentComparator comparator) {
        super(FileAssert.class, actual);
        this.comparator = comparator;
    }

    public FileAssert doesNotExist() {
        this.isNotNull();
        if (!((File)this.actual).exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should not exist", this.actual));
    }

    public FileAssert exists() {
        this.isNotNull();
        this.assertExists((File)this.actual);
        return this;
    }

    public FileAssert hasSize(long expected) {
        this.isNotNull();
        long size = ((File)this.actual).length();
        if (size == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("size of file:<%s> expected:<%s> but was:<%s>", this.actual, expected, size));
    }

    public FileAssert isDirectory() {
        this.isNotNull();
        if (((File)this.actual).isDirectory()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a directory", this.actual));
    }

    public FileAssert isFile() {
        this.isNotNull();
        if (((File)this.actual).isFile()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a file", this.actual));
    }

    public FileAssert hasSameContentAs(File expected) {
        if (expected == null) {
            throw new NullPointerException(this.formattedErrorMessage("File to compare to should not be null"));
        }
        this.isNotNull();
        this.assertExists((File)this.actual).assertExists(expected);
        try {
            Object[] diffs = this.comparator.compareContents((File)this.actual, expected);
            if (!Arrays.isEmpty((Object[])diffs)) {
                this.fail(expected, (FileContentComparator.LineDiff[])diffs);
            }
        }
        catch (IOException e) {
            this.cannotCompareToExpectedFile(expected, e);
        }
        return this;
    }

    private void fail(File expected, FileContentComparator.LineDiff[] diffs) {
        this.failIfCustomMessageIsSet();
        StringBuilder b = new StringBuilder();
        b.append("file:").append(Formatting.inBrackets(this.actual)).append(" and file:").append(Formatting.inBrackets(expected)).append(" do not have same contents:");
        for (FileContentComparator.LineDiff diff : diffs) {
            b.append(Systems.LINE_SEPARATOR).append("line:").append(Formatting.inBrackets(diff.lineNumber)).append(", expected:").append(Formatting.inBrackets(diff.expected)).append(" but was:").append(Formatting.inBrackets(diff.actual));
        }
        this.fail(b.toString());
    }

    private void cannotCompareToExpectedFile(File expected, Exception e) {
        this.failIfCustomMessageIsSet(e);
        String message = Formatting.format("unable to compare contents of files:<%s> and <%s>", this.actual, expected);
        this.fail(message, e);
    }

    private FileAssert assertExists(File file) {
        if (file.exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should exist", file));
    }

    public FileAssert isRelative() {
        this.isNotNull();
        if (!((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a relative path", this.actual));
    }

    public FileAssert isAbsolute() {
        this.isNotNull();
        if (((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be an absolute path", this.actual));
    }
}

