/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFileUtils {
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "aether-" + UUID.randomUUID().toString().substring(0, 8));

    private TestFileUtils() {
    }

    public static void deleteTempFiles() throws IOException {
        TestFileUtils.delete(TMP);
    }

    public static File createTempFile(String contents) throws IOException {
        return TestFileUtils.createTempFile(contents.getBytes("UTF-8"), 1);
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TestFileUtils.mkdirs(TMP);
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        TestFileUtils.write(pattern, repeat, tmpFile);
        return tmpFile;
    }

    public static void write(String content, File file) throws IOException {
        TestFileUtils.write(content.getBytes("UTF-8"), 1, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] pattern, int repeat, File file) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < repeat; ++i) {
                ((OutputStream)out).write(pattern);
            }
        }
        catch (Throwable throwable) {
            TestFileUtils.close(out);
            throw throwable;
        }
        TestFileUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File source, File target) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            int bytes;
            fis = new FileInputStream(source);
            TestFileUtils.mkdirs(target.getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[32768];
            while ((bytes = fis.read(buffer)) >= 0) {
                ((OutputStream)fos).write(buffer, 0, bytes);
                total += (long)bytes;
            }
        }
        catch (Throwable throwable) {
            TestFileUtils.close(fis);
            TestFileUtils.close(fos);
            throw throwable;
        }
        TestFileUtils.close(fis);
        TestFileUtils.close(fos);
        return total;
    }

    private static void close(Closeable c) throws IOException {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File file) throws IOException {
        if (file == null) {
            return;
        }
        ArrayList<File> undeletables = new ArrayList<File>();
        TestFileUtils.delete(file, undeletables);
        if (!undeletables.isEmpty()) {
            throw new IOException("Failed to delete " + undeletables);
        }
    }

    private static void delete(File file, Collection<File> undeletables) {
        String[] children = file.list();
        if (children != null) {
            for (String child : children) {
                TestFileUtils.delete(new File(file, child), undeletables);
            }
        }
        if (!TestFileUtils.del(file)) {
            undeletables.add(file.getAbsoluteFile());
        }
    }

    private static boolean del(File file) {
        for (int i = 0; i < 10; ++i) {
            if (!file.delete() && file.exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(File file) throws IOException {
        byte[] byArray;
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(file, "r");
            byte[] actual = new byte[(int)in.length()];
            in.readFully(actual);
            byArray = actual;
        }
        catch (Throwable throwable) {
            TestFileUtils.close(in);
            throw throwable;
        }
        TestFileUtils.close(in);
        return byArray;
    }

    public static void assertContent(byte[] expected, File file) throws IOException {
        Assert.assertArrayEquals((byte[])expected, (byte[])TestFileUtils.getContent(file));
    }

    public static void assertContent(String expected, File file) throws IOException {
        byte[] content = TestFileUtils.getContent(file);
        String msg = new String(content, "UTF-8");
        if (msg.length() > 10) {
            msg = msg.substring(0, 10) + "...";
        }
        Assert.assertArrayEquals((String)("content was '" + msg + "'\n"), (byte[])expected.getBytes("UTF-8"), (byte[])content);
    }

    public static boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (TestFileUtils.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    public static File createTempDir() throws IOException {
        return TestFileUtils.createTempDir("");
    }

    public static File createTempDir(String suffix) throws IOException {
        TestFileUtils.mkdirs(TMP);
        File tmpFile = File.createTempFile("tmpdir-", suffix, TMP);
        TestFileUtils.delete(tmpFile);
        TestFileUtils.mkdirs(tmpFile);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(Properties props, File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
        }
        catch (Throwable throwable) {
            TestFileUtils.close(fis);
            throw throwable;
        }
        TestFileUtils.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Properties props, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            props.store(fos, "aether-test");
        }
        catch (Throwable throwable) {
            TestFileUtils.close(fos);
            throw throwable;
        }
        TestFileUtils.close(fos);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    TestFileUtils.delete(TMP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

