/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.connector;

import java.io.File;
import java.util.StringTokenizer;

public final class TestConnectorPathUtils {
    private TestConnectorPathUtils() {
    }

    public static String dirname(String path) {
        int i = path.lastIndexOf("/");
        return i >= 0 ? path.substring(0, i) : "";
    }

    public static String filename(String path) {
        int i = path.lastIndexOf("/");
        return i >= 0 ? path.substring(i + 1) : path;
    }

    public static String[] dirnames(String path) {
        String dirname = TestConnectorPathUtils.dirname(path);
        return TestConnectorPathUtils.split(dirname, "/", -1);
    }

    private static String[] split(String str, String separator, int max) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i] = str.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = str.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    public static String protocol(String url) {
        int pos = url.indexOf(":");
        if (pos == -1) {
            return "";
        }
        return url.substring(0, pos).trim();
    }

    public static String basedir(String url) {
        String protocol = TestConnectorPathUtils.protocol(url);
        String retValue = null;
        retValue = protocol.length() > 0 ? url.substring(protocol.length() + 1) : url;
        if ((retValue = TestConnectorPathUtils.decode(retValue)).startsWith("//")) {
            if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            } else {
                int index = retValue.indexOf("/");
                if (index >= 0) {
                    retValue = retValue.substring(index + 1);
                }
                if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else if (index >= 0) {
                    retValue = "/" + retValue;
                }
            }
        }
        if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
            retValue = retValue.charAt(0) + ":" + retValue.substring(2);
        }
        return retValue.trim();
    }

    static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos = -1;
            while ((pos = decoded.indexOf(37, pos + 1)) >= 0) {
                if (pos + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos + 1, pos + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos) + ch + decoded.substring(pos + 3);
            }
        }
        return decoded;
    }

    public static String toRelative(File basedir, String absolutePath) {
        String relative;
        String basedirPath;
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/'))) {
            relative = absolutePath.substring(basedirPath.length());
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.length() <= 0) {
                relative = ".";
            }
        } else {
            relative = absolutePath;
        }
        return relative;
    }
}

