/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

class TableInfo {
    private String tableName;
    private HashMap columnInfos;
    private HashMap filterInfos;
    private String originalRootPath;
    private String rootPath;

    public TableInfo(String tableName, String rootPath) {
        this.tableName = tableName;
        this.originalRootPath = rootPath;
        String temp = SaxParserUtil.processParentAxis(this.originalRootPath.replaceAll("\\Q[@\\E.*\\Q=\\E.*\\Q]\\E", ""));
        this.rootPath = "//".equals(temp) ? "//*" : temp;
        this.columnInfos = new HashMap();
        this.filterInfos = new HashMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnPath();
    }

    public String getOriginalPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnOriginalPath();
    }

    public int getBackRefNumber(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getBackRefNumber();
    }

    public int getForwardRefNumber(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getForwardRefNumber();
    }

    public String getType(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnType();
    }

    public HashMap getFilter() {
        return this.filterInfos;
    }

    public HashMap getColumnFilters(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getFilters();
    }

    public List getFilterColumns() {
        Object[] names = this.columnInfos.keySet().toArray();
        String[] temp = new String[names.length];
        int i = 0;
        while (i < names.length) {
            temp[((ColumnInfo)this.columnInfos.get((Object)names[i])).getColumnIndex() - 1] = names[i].toString();
            ++i;
        }
        ArrayList filterColumnList = new ArrayList();
        int i2 = 0;
        while (i2 < temp.length) {
            if (SaxParserUtil.isTempColumn(temp[i2])) {
                filterColumnList.add(this.columnInfos.get(temp[i2]));
            }
            ++i2;
        }
        return filterColumnList;
    }

    public void addColumn(ColumnInfo ci) {
        this.columnInfos.put(ci.getColumnName(), ci);
    }

    public void addFilter(String columnName, String value) {
        this.filterInfos.put(columnName, value);
    }

    public String[] getColumnNames() {
        String[] temp = this.getRealColumnNames();
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < temp.length) {
            if (SaxParserUtil.isTempColumn(temp[i])) break;
            l.add(temp[i]);
            ++i;
        }
        String[] result = new String[l.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = l.get(i2).toString();
            ++i2;
        }
        return result;
    }

    public String[] getRealColumnNames() {
        Object[] names = this.columnInfos.keySet().toArray();
        String[] temp = new String[names.length];
        int i = 0;
        while (i < names.length) {
            temp[((ColumnInfo)this.columnInfos.get((Object)names[i])).getColumnIndex() - 1] = names[i].toString();
            ++i;
        }
        return temp;
    }

    public String[] getComplexNestXMLColumnNames() {
        ArrayList<String> temp = new ArrayList<String>();
        String[] columnNames = this.getColumnNames();
        String[] simpleNestXMLColumnNames = this.getSimpleNestXMLColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            if (!((ColumnInfo)this.columnInfos.get(columnNames[i])).getColumnPath().startsWith(this.rootPath)) {
                boolean isComplexNestXMLColumn = true;
                int j = 0;
                while (j < simpleNestXMLColumnNames.length) {
                    if (simpleNestXMLColumnNames[j].equals(columnNames[i])) {
                        isComplexNestXMLColumn = false;
                        break;
                    }
                    ++j;
                }
                if (isComplexNestXMLColumn) {
                    temp.add(columnNames[i]);
                }
            }
            ++i;
        }
        return this.getStringArrayFromList(temp);
    }

    private String[] getStringArrayFromList(ArrayList temp) {
        String[] result = new String[temp.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = temp.get(i).toString();
            ++i;
        }
        return result;
    }

    public String[] getSimpleNestXMLColumnNames() {
        ArrayList<String> temp = new ArrayList<String>();
        String[] columnNames = this.getRealColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            String nestedXMLColumnPathPrefix = ((ColumnInfo)this.columnInfos.get(columnNames[i])).getColumnPath();
            if (nestedXMLColumnPathPrefix.matches(".*\\Q@\\E.*") && this.isSimpleNestedColumn(this.rootPath, nestedXMLColumnPathPrefix = nestedXMLColumnPathPrefix.replaceAll("\\Q[@\\E.*", ""))) {
                temp.add(columnNames[i]);
            }
            ++i;
        }
        return this.getStringArrayFromList(temp);
    }

    private boolean isSimpleNestedColumn(String rootPath, String treatedColumPath) {
        String[] tempString1 = treatedColumPath.split("/");
        String[] tempString2 = rootPath.split("/");
        if (tempString2.length <= tempString1.length) {
            return false;
        }
        int j = 0;
        while (j < tempString1.length) {
            if (!(tempString1[j] == null || tempString2[j] == null || tempString1[j].equals(tempString2[j]) || "*".equals(tempString1[j]) || "*".equals(tempString2[j]))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getOriginalRootPath() {
        return this.originalRootPath;
    }

    public String getAncestor() {
        String[] columnNames = this.getColumnNames();
        if (columnNames.length == 1) {
            return this.getPath(columnNames[0]);
        }
        String[] paths = new String[columnNames.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = this.getPath(columnNames[i]).replaceFirst("\\Q\\[@\\E.*\\Q\\]\\E", "");
            ++i;
        }
        String theLongestPath = "";
        int i2 = 0;
        while (i2 < paths.length) {
            if (paths[i2].split("\\Q/\\E").length > theLongestPath.split("\\Q/\\E").length) {
                theLongestPath = paths[i2];
            }
            ++i2;
        }
        boolean isAbsolutePath = false;
        if (theLongestPath.startsWith("//")) {
            isAbsolutePath = false;
            theLongestPath = theLongestPath.replaceFirst("\\Q//\\E", "");
        } else {
            isAbsolutePath = true;
            theLongestPath = theLongestPath.replaceFirst("\\Q/\\E", "");
        }
        String[] temp = theLongestPath.split("\\Q/\\E");
        String prefix = isAbsolutePath ? "/" : "//";
        int j = 0;
        while (j < temp.length) {
            String attempedPrefix = j == 0 ? String.valueOf(prefix) + temp[j] : String.valueOf(prefix) + "/" + temp[j];
            int i3 = 0;
            while (i3 < paths.length) {
                if (!paths[i3].startsWith(attempedPrefix)) {
                    return prefix;
                }
                ++i3;
            }
            prefix = attempedPrefix;
            ++j;
        }
        return prefix;
    }
}

