/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.TextRendererAdapter;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.device.swing.SwingTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

final class SwingTextRenderer
extends TextRendererAdapter {
    SwingTextRenderer(IDisplayServer sxs) {
        super(sxs);
    }

    public final void renderShadowAtLocation(IPrimitiveRenderer idr, int iLabelPosition, Location lo, Label la) throws ChartException {
        if (!ChartUtil.isShadowDefined((Label)la)) {
            return;
        }
        ColorDefinition cdShadow = la.getShadowColor();
        if (cdShadow == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.shadow.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)idr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        switch (iLabelPosition) {
            case 3: {
                this.showTopValue(idr, lo, la, true);
                break;
            }
            case 4: {
                this.showBottomValue(idr, lo, la, true);
                break;
            }
            case 1: {
                this.showLeftValue(idr, lo, la, true);
                break;
            }
            case 2: {
                this.showRightValue(idr, lo, la, true);
            }
        }
    }

    public final void renderTextAtLocation(IPrimitiveRenderer ipr, int iLabelPosition, Location lo, Label la) throws ChartException {
        ColorDefinition cdText = la.getCaption().getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        switch (iLabelPosition) {
            case 3: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showTopValue(ipr, lo, la, true);
                }
                this.showTopValue(ipr, lo, la, false);
                break;
            }
            case 4: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showBottomValue(ipr, lo, la, true);
                }
                this.showBottomValue(ipr, lo, la, false);
                break;
            }
            case 1: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showLeftValue(ipr, lo, la, true);
                }
                this.showLeftValue(ipr, lo, la, false);
                break;
            }
            case 2: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showRightValue(ipr, lo, la, true);
                }
                this.showRightValue(ipr, lo, la, false);
                break;
            }
            case 6: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showCenterValue(ipr, lo, la, true);
                }
                this.showCenterValue(ipr, lo, la, false);
            }
        }
    }

    public final void renderTextInBlock(IDeviceRenderer idr, Bounds boBlock, TextAlignment taBlock, Label la) throws ChartException {
        Text t = la.getCaption();
        String sText = t.getValue();
        FontDefinition fd = t.getFont();
        ColorDefinition cdText = t.getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        IDisplayServer xs = idr.getDisplayServer();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        g2d.setFont((Font)xs.createFont(fd));
        la.getCaption().setValue(sText);
        BoundingBox bb = null;
        try {
            bb = Methods.computeBox((IDisplayServer)xs, (int)3, (Label)la, (double)0.0, (double)0.0);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)uiex);
        }
        if (taBlock == null) {
            taBlock = AttributeFactory.eINSTANCE.createTextAlignment();
            taBlock.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            taBlock.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        }
        HorizontalAlignment haBlock = taBlock.getHorizontalAlignment();
        VerticalAlignment vaBlock = taBlock.getVerticalAlignment();
        switch (haBlock.getValue()) {
            case 1: {
                bb.setLeft(boBlock.getLeft() + (boBlock.getWidth() - bb.getWidth()) / 2.0);
                break;
            }
            case 0: {
                bb.setLeft(boBlock.getLeft());
                break;
            }
            case 2: {
                bb.setLeft(boBlock.getLeft() + boBlock.getWidth() - bb.getWidth());
            }
        }
        switch (vaBlock.getValue()) {
            case 0: {
                bb.setTop(boBlock.getTop());
                break;
            }
            case 1: {
                bb.setTop(boBlock.getTop() + (boBlock.getHeight() - bb.getHeight()) / 2.0);
                break;
            }
            case 2: {
                bb.setTop(boBlock.getTop() + boBlock.getHeight() - bb.getHeight());
            }
        }
        bb.setLeft(bb.getLeft() + bb.getHotPoint());
        if (ChartUtil.isShadowDefined((Label)la)) {
            this.showTopValue((IPrimitiveRenderer)idr, LocationImpl.create((double)bb.getLeft(), (double)(bb.getTop() + bb.getHeight())), la, true);
        }
        this.showTopValue((IPrimitiveRenderer)idr, LocationImpl.create((double)bb.getLeft(), (double)(bb.getTop() + bb.getHeight())), la, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void showLeftValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        dX = lo.getX();
        dY = lo.getY();
        fd = la.getCaption().getFont();
        dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dAngleInRadians = -dAngleInDegrees * 3.141592653589793 / 180.0;
        dSineTheta = Math.sin(dAngleInRadians);
        dCosTheta = Math.cos(dAngleInRadians);
        itm = new SwingTextMetrics(this._sxs, la);
        try {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            dFW = itm.getFullWidth();
                            dH = itm.getHeight();
                            dD = itm.getDescent();
                            dFH = itm.getFullHeight();
                            dXOffset = 0.0;
                            dW = 0.0;
                            iLC = itm.getLineCount();
                            ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
                            shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
                            bEmptyText = "".equals(la.getCaption().getValue());
                            ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
                            bRightAligned = ha.getValue() == 2;
                            bCenterAligned = ha.getValue() == 1;
                            dRotateX = dX - dFW;
                            dRotateY = dY + dH / 2.0;
                            dX -= dFW;
                            dY += dH / 2.0;
                            if (dAngleInDegrees != 0.0) break block46;
                            dYHalfOffset = (dFH + dH) / 2.0;
                            if (bShadow) {
                                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                                g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                            } else {
                                r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                                if (clrBackground != null) {
                                    g2d.setColor(clrBackground);
                                    g2d.fill(r2d);
                                }
                                if (!bEmptyText) {
                                    g2d.setColor(clrText);
                                    i = 0;
                                    while (i < iLC) {
                                        tl = itm.getLayout(i);
                                        if (bRightAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                        } else if (bCenterAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                        }
                                        tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                                        ++i;
                                    }
                                }
                                this.renderOutline(ipr, la.getOutline(), r2d);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!(dAngleInDegrees > 0.0) || !(dAngleInDegrees < 90.0)) break block47;
                        dDeltaX = dFW - dFW * dCosTheta;
                        dDeltaY = dFW * dSineTheta + dH / 2.0 - dH * dCosTheta / 2.0;
                        dX += dDeltaX;
                        dY -= dDeltaY;
                        g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                        if (bShadow) {
                            g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                            g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                        } else {
                            r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                            if (clrBackground != null) {
                                g2d.setColor(clrBackground);
                                g2d.fill(r2d);
                            }
                            if (!bEmptyText) {
                                g2d.setColor(clrText);
                                i = 0;
                                while (i < itm.getLineCount()) {
                                    tl = itm.getLayout(iLC - i - 1);
                                    if (bRightAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                    } else if (bCenterAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                    }
                                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                                    ++i;
                                }
                            }
                            this.renderOutline(ipr, la.getOutline(), r2d);
                        }
                        g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                        ** GOTO lbl-1000
                    }
                    if (!(dAngleInDegrees < 0.0) || !(dAngleInDegrees > -90.0)) break block48;
                    dDeltaX = dFW - dFW * dCosTheta - dH * dSineTheta;
                    dDeltaY = dFW * dSineTheta - dH / 2.0 + dH * dCosTheta / 2.0;
                    dX += dDeltaX;
                    dY -= dDeltaY;
                    g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                    if (bShadow) {
                        g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                        g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                    } else {
                        r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                        if (clrBackground != null) {
                            g2d.setColor(clrBackground);
                            g2d.fill(r2d);
                        }
                        if (!bEmptyText) {
                            g2d.setColor(clrText);
                            i = 0;
                            while (i < iLC) {
                                tl = itm.getLayout(i);
                                if (bRightAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                } else if (bCenterAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                }
                                tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                ++i;
                            }
                        }
                        this.renderOutline(ipr, la.getOutline(), r2d);
                    }
                    g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                    ** GOTO lbl-1000
                }
                if (dAngleInDegrees != 90.0) break block49;
                dDeltaX = dFW;
                dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
                ** GOTO lbl-1000
            }
            if (dAngleInDegrees == -90.0) {
                dDeltaX = dFW - dH;
                dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        catch (Throwable var54_55) {
            var53_56 = null;
            itm.dispose();
            throw var54_55;
        }
lbl-1000:
        // 6 sources

        {
            var53_57 = null;
        }
        itm.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void showRightValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        dX = lo.getX();
        dY = lo.getY();
        fd = la.getCaption().getFont();
        dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dY += 1.0;
        itm = new SwingTextMetrics(this._sxs, la);
        try {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            dFW = itm.getFullWidth();
                            dH = itm.getHeight();
                            dD = itm.getDescent();
                            dFH = itm.getFullHeight();
                            dXOffset = 0.0;
                            dW = 0.0;
                            iLC = itm.getLineCount();
                            ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
                            shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
                            bEmptyText = "".equals(la.getCaption().getValue());
                            ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
                            bRightAligned = ha.getValue() == 2;
                            bCenterAligned = ha.getValue() == 1;
                            dAngleInRadians = -dAngleInDegrees * 3.141592653589793 / 180.0;
                            iRotateX = (int)dX;
                            iRotateY = (int)(dY + dH / 2.0);
                            dY += dH / 2.0;
                            dCosTheta = Math.abs(Math.cos(dAngleInRadians));
                            if (dAngleInDegrees != 0.0) break block46;
                            dYHalfOffset = (dFH + dH) / 2.0;
                            if (bShadow) {
                                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                                g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                            } else {
                                r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                                if (clrBackground != null) {
                                    g2d.setColor(clrBackground);
                                    g2d.fill(r2d);
                                }
                                if (!bEmptyText) {
                                    g2d.setColor(clrText);
                                    i = 0;
                                    while (i < iLC) {
                                        tl = itm.getLayout(i);
                                        if (bRightAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                        } else if (bCenterAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                        }
                                        tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                                        ++i;
                                    }
                                }
                                this.renderOutline(ipr, la.getOutline(), r2d);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!(dAngleInDegrees > 0.0) || !(dAngleInDegrees < 90.0)) break block47;
                        dDeltaX = dH * Math.sin(dAngleInRadians);
                        dDeltaY = dH / 2.0 - dH * dCosTheta / 2.0;
                        dX -= dDeltaX;
                        dY += dDeltaY;
                        g2d.rotate(dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
                        if (bShadow) {
                            g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                            g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                        } else {
                            r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                            if (clrBackground != null) {
                                g2d.setColor(clrBackground);
                                g2d.fill(r2d);
                            }
                            if (!bEmptyText) {
                                g2d.setColor(clrText);
                                i = 0;
                                while (i < iLC) {
                                    tl = itm.getLayout(i);
                                    if (bRightAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                    } else if (bCenterAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                    }
                                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                    ++i;
                                }
                            }
                            this.renderOutline(ipr, la.getOutline(), r2d);
                        }
                        g2d.rotate(-dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
                        ** GOTO lbl-1000
                    }
                    if (!(dAngleInDegrees < 0.0) || !(dAngleInDegrees > -90.0)) break block48;
                    dDeltaY = -dH / 2.0 + dH * dCosTheta / 2.0;
                    dY += dDeltaY;
                    g2d.rotate(dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
                    if (bShadow) {
                        g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                        g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                    } else {
                        r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                        if (clrBackground != null) {
                            g2d.setColor(clrBackground);
                            g2d.fill(r2d);
                        }
                        if (!bEmptyText) {
                            g2d.setColor(clrText);
                            i = 0;
                            while (i < iLC) {
                                tl = itm.getLayout(i);
                                if (bRightAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                } else if (bCenterAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                }
                                tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) - ins.getBottom()));
                                ++i;
                            }
                        }
                        this.renderOutline(ipr, la.getOutline(), r2d);
                    }
                    g2d.rotate(-dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
                    ** GOTO lbl-1000
                }
                if (dAngleInDegrees != 90.0) break block49;
                dDeltaX = dH;
                dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
                ** GOTO lbl-1000
            }
            if (dAngleInDegrees == -90.0) {
                dDeltaX = 0.0;
                dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        catch (Throwable var50_53) {
            var49_54 = null;
            itm.dispose();
            throw var50_53;
        }
lbl-1000:
        // 6 sources

        {
            var49_55 = null;
        }
        itm.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void showBottomValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        dX = lo.getX();
        dY = lo.getY();
        fd = la.getCaption().getFont();
        dAngleInDegrees = fd.getRotation();
        clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dAngleInRadians = -dAngleInDegrees * 3.141592653589793 / 180.0;
        itm = new SwingTextMetrics(this._sxs, la);
        try {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            dFW = itm.getFullWidth();
                            dH = itm.getHeight();
                            dD = itm.getDescent();
                            dFH = itm.getFullHeight();
                            dXOffset = 0.0;
                            dW = 0.0;
                            iLC = itm.getLineCount();
                            ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
                            shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
                            bEmptyText = "".equals(la.getCaption().getValue());
                            ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
                            bRightAligned = ha.getValue() == 2;
                            bCenterAligned = ha.getValue() == 1;
                            dX -= dFW / 2.0;
                            dY += dH;
                            dSineTheta = Math.abs(Math.sin(dAngleInRadians));
                            dCosTheta = Math.abs(Math.cos(dAngleInRadians));
                            if (dAngleInDegrees != 0.0) break block45;
                            if (bShadow) {
                                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                                g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                            } else {
                                r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                                if (clrBackground != null) {
                                    g2d.setColor(clrBackground);
                                    g2d.fill(r2d);
                                }
                                if (!bEmptyText) {
                                    g2d.setColor(clrText);
                                    i = 0;
                                    while (i < iLC) {
                                        tl = itm.getLayout(i);
                                        if (bRightAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                        } else if (bCenterAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                        }
                                        tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                        ++i;
                                    }
                                }
                                this.renderOutline(ipr, la.getOutline(), r2d);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!(dAngleInDegrees > 0.0) || !(dAngleInDegrees < 90.0)) break block46;
                        dDeltaX = dFW * dCosTheta - dH * dSineTheta / 2.0 - dFW / 2.0;
                        dDeltaY = dH * dCosTheta + dFW * dSineTheta - dH;
                        g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY += dDeltaY);
                        if (bShadow) {
                            g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                            g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                        } else {
                            r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                            if (clrBackground != null) {
                                g2d.setColor(clrBackground);
                                g2d.fill(r2d);
                            }
                            if (!bEmptyText) {
                                g2d.setColor(clrText);
                                i = 0;
                                while (i < iLC) {
                                    tl = itm.getLayout(i);
                                    if (bRightAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                    } else if (bCenterAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                    }
                                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                    ++i;
                                }
                            }
                            this.renderOutline(ipr, la.getOutline(), r2d);
                        }
                        g2d.rotate(-dAngleInRadians, dX, dY);
                        ** GOTO lbl-1000
                    }
                    if (!(dAngleInDegrees < 0.0) || !(dAngleInDegrees > -90.0)) break block47;
                    g2d.rotate(dAngleInRadians, dX += dFW / 2.0 + dH * dSineTheta / 2.0, dY - dH);
                    if (bShadow) {
                        g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                        g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                    } else {
                        r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                        if (clrBackground != null) {
                            g2d.setColor(clrBackground);
                            g2d.fill(r2d);
                        }
                        if (!bEmptyText) {
                            g2d.setColor(clrText);
                            i = 0;
                            while (i < iLC) {
                                tl = itm.getLayout(i);
                                if (bRightAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                } else if (bCenterAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                }
                                tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                ++i;
                            }
                        }
                        this.renderOutline(ipr, la.getOutline(), r2d);
                    }
                    g2d.rotate(-dAngleInRadians, dX, dY - dH);
                    ** GOTO lbl-1000
                }
                if (dAngleInDegrees != 90.0) break block48;
                dYHalfOffset = (dFH + dH) / 2.0;
                dDeltaX = (dFW + dH) / 2.0;
                dDeltaY = dFW - dH;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(iLC - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
                ** GOTO lbl-1000
            }
            if (dAngleInDegrees == -90.0) {
                dX += dFW / 2.0;
                dYHalfOffset = (dFH + dH) / 2.0;
                dDeltaX = dYHalfOffset - dFH / 2.0;
                g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY -= dH);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dYHalfOffset + dH * (double)(i + 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        catch (Throwable var52_51) {
            var51_52 = null;
            itm.dispose();
            throw var52_51;
        }
lbl-1000:
        // 6 sources

        {
            var51_53 = null;
        }
        itm.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void showTopValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        dX = lo.getX();
        dY = lo.getY();
        fd = la.getCaption().getFont();
        dAngleInDegrees = fd.getRotation();
        clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dAngleInRadians = -dAngleInDegrees * 3.141592653589793 / 180.0;
        itm = new SwingTextMetrics(this._sxs, la);
        try {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            dFW = itm.getFullWidth();
                            dH = itm.getHeight();
                            dD = itm.getDescent();
                            dFH = itm.getFullHeight();
                            dXOffset = 0.0;
                            dW = 0.0;
                            iLC = itm.getLineCount();
                            ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
                            shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
                            bEmptyText = "".equals(la.getCaption().getValue());
                            ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
                            bRightAligned = ha.getValue() == 2;
                            bCenterAligned = ha.getValue() == 1;
                            dCosTheta = Math.abs(Math.cos(dAngleInRadians));
                            dSineTheta = Math.abs(Math.sin(dAngleInRadians));
                            dX -= dFW / 2.0;
                            if (dAngleInDegrees != 0.0) break block45;
                            if (bShadow) {
                                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                                g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                            } else {
                                r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                                if (clrBackground != null) {
                                    g2d.setColor(clrBackground);
                                    g2d.fill(r2d);
                                }
                                if (!bEmptyText) {
                                    g2d.setColor(clrText);
                                    i = 0;
                                    while (i < itm.getLineCount()) {
                                        tl = itm.getLayout(iLC - i - 1);
                                        if (bRightAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                        } else if (bCenterAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                        }
                                        tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                                        ++i;
                                    }
                                }
                                this.renderOutline(ipr, la.getOutline(), r2d);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!(dAngleInDegrees > 0.0) || !(dAngleInDegrees < 90.0)) break block46;
                        dDeltaX = dFW / 2.0 + dH * dSineTheta / 2.0;
                        g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                        if (bShadow) {
                            g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                            g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                        } else {
                            r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                            if (clrBackground != null) {
                                g2d.setColor(clrBackground);
                                g2d.fill(r2d);
                            }
                            if (!bEmptyText) {
                                g2d.setColor(clrText);
                                i = 0;
                                while (i < itm.getLineCount()) {
                                    tl = new TextLayout(itm.getLine(iLC - i - 1), g2d.getFont().getAttributes(), g2d.getFontRenderContext());
                                    if (bRightAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                    } else if (bCenterAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                    }
                                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                                    ++i;
                                }
                            }
                            this.renderOutline(ipr, la.getOutline(), r2d);
                        }
                        g2d.rotate(-dAngleInRadians, dX, dY);
                        ** GOTO lbl-1000
                    }
                    if (!(dAngleInDegrees < 0.0) || !(dAngleInDegrees > -90.0)) break block47;
                    g2d.rotate(dAngleInRadians, dX += -dFW * dCosTheta - dH * dSineTheta / 2.0 + dFW / 2.0, dY -= dFW * dSineTheta);
                    if (bShadow) {
                        g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                        g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                    } else {
                        r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                        if (clrBackground != null) {
                            g2d.setColor(clrBackground);
                            g2d.fill(r2d);
                        }
                        if (!bEmptyText) {
                            g2d.setColor(clrText);
                            i = 0;
                            while (i < itm.getLineCount()) {
                                tl = itm.getLayout(iLC - i - 1);
                                if (bRightAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                } else if (bCenterAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                }
                                tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                                ++i;
                            }
                        }
                        this.renderOutline(ipr, la.getOutline(), r2d);
                    }
                    g2d.rotate(-dAngleInRadians, dX, dY);
                    ** GOTO lbl-1000
                }
                if (dAngleInDegrees != 90.0) break block48;
                dYHalfOffset = (dFH + dH) / 2.0;
                dDeltaX = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < itm.getLineCount()) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
                ** GOTO lbl-1000
            }
            if (dAngleInDegrees == -90.0) {
                dYHalfOffset = (dFH + dH) / 2.0;
                dDeltaX = (dFW - dH) / 2.0;
                dDeltaY = dFW;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < itm.getLineCount()) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        catch (Throwable var52_50) {
            var51_51 = null;
            itm.dispose();
            throw var52_50;
        }
lbl-1000:
        // 6 sources

        {
            var51_52 = null;
        }
        itm.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void showCenterValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        dX = lo.getX();
        dY = lo.getY();
        fd = la.getCaption().getFont();
        dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dAngleInRadians = -dAngleInDegrees * 3.141592653589793 / 180.0;
        dSineTheta = Math.sin(dAngleInRadians);
        dCosTheta = Math.cos(dAngleInRadians);
        itm = new SwingTextMetrics(this._sxs, la);
        try {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            dFW = itm.getFullWidth();
                            dH = itm.getHeight();
                            dD = itm.getDescent();
                            dFH = itm.getFullHeight();
                            dXOffset = 0.0;
                            dW = 0.0;
                            iLC = itm.getLineCount();
                            ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
                            shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
                            bEmptyText = "".equals(la.getCaption().getValue());
                            ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
                            bRightAligned = ha.getValue() == 2;
                            bCenterAligned = ha.getValue() == 1;
                            dRotateX = dX;
                            dRotateY = dY;
                            dX -= dFW / 2.0;
                            dY += dH / 2.0;
                            if (dAngleInDegrees != 0.0) break block46;
                            dYHalfOffset = (dFH + dH) / 2.0;
                            if (bShadow) {
                                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                                g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                            } else {
                                r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                                if (clrBackground != null) {
                                    g2d.setColor(clrBackground);
                                    g2d.fill(r2d);
                                }
                                if (!bEmptyText) {
                                    g2d.setColor(clrText);
                                    i = 0;
                                    while (i < iLC) {
                                        tl = itm.getLayout(i);
                                        if (bRightAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                        } else if (bCenterAligned) {
                                            dW = tl.getBounds().getWidth();
                                            dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                        }
                                        tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                                        ++i;
                                    }
                                }
                                this.renderOutline(ipr, la.getOutline(), r2d);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!(dAngleInDegrees > 0.0) || !(dAngleInDegrees < 90.0)) break block47;
                        dDeltaX = dFW - dFW * dCosTheta;
                        dDeltaY = dFW * dSineTheta + dH / 2.0;
                        dX += dDeltaX;
                        dY -= dDeltaY;
                        g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                        if (bShadow) {
                            g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                            g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                        } else {
                            r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                            if (clrBackground != null) {
                                g2d.setColor(clrBackground);
                                g2d.fill(r2d);
                            }
                            if (!bEmptyText) {
                                g2d.setColor(clrText);
                                i = 0;
                                while (i < itm.getLineCount()) {
                                    tl = itm.getLayout(iLC - i - 1);
                                    if (bRightAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                    } else if (bCenterAligned) {
                                        dW = tl.getBounds().getWidth();
                                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                    }
                                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                                    ++i;
                                }
                            }
                            this.renderOutline(ipr, la.getOutline(), r2d);
                        }
                        g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                        ** GOTO lbl-1000
                    }
                    if (!(dAngleInDegrees < 0.0) || !(dAngleInDegrees > -90.0)) break block48;
                    dDeltaX = dFW - dFW * dCosTheta - dH * dSineTheta;
                    dDeltaY = dFW * dSineTheta + dH / 2.0 - dH * dCosTheta;
                    dX += dDeltaX;
                    dY -= dDeltaY;
                    g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                    if (bShadow) {
                        g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                        g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                    } else {
                        r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                        if (clrBackground != null) {
                            g2d.setColor(clrBackground);
                            g2d.fill(r2d);
                        }
                        if (!bEmptyText) {
                            g2d.setColor(clrText);
                            i = 0;
                            while (i < iLC) {
                                tl = itm.getLayout(i);
                                if (bRightAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                                } else if (bCenterAligned) {
                                    dW = tl.getBounds().getWidth();
                                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                                }
                                tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                                ++i;
                            }
                        }
                        this.renderOutline(ipr, la.getOutline(), r2d);
                    }
                    g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                    ** GOTO lbl-1000
                }
                if (dAngleInDegrees != 90.0) break block49;
                dDeltaX = dFW;
                dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
                ** GOTO lbl-1000
            }
            if (dAngleInDegrees == -90.0) {
                dDeltaX = dFW - dH;
                dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        i = 0;
                        while (i < iLC) {
                            tl = itm.getLayout(i);
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        catch (Throwable var54_55) {
            var53_56 = null;
            itm.dispose();
            throw var54_55;
        }
lbl-1000:
        // 6 sources

        {
            var53_57 = null;
        }
        itm.dispose();
    }

    private final void renderOutline(IPrimitiveRenderer ipr, LineAttributes lia, Rectangle2D.Double r2d) {
        if (lia != null && lia.isVisible() && lia.getColor() != null) {
            Graphics2D g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
            Stroke sPrevious = null;
            ColorDefinition cd = lia.getColor();
            Stroke sCurrent = ((SwingRendererImpl)ipr).getCachedStroke(lia);
            if (sCurrent != null) {
                sPrevious = g2d.getStroke();
                g2d.setStroke(sCurrent);
            }
            g2d.setColor((Color)this._sxs.getColor(cd));
            g2d.draw(r2d);
            if (sPrevious != null) {
                g2d.setStroke(sPrevious);
            }
        }
    }
}

