/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabHeaderExecutor
extends BaseCrosstabExecutor {
    private boolean hasMeasureHeader;
    private int currentGroupIndex;

    public CrosstabHeaderExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(1);
        this.initializeContent((IContent)content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentGroupIndex = 0;
        this.hasMeasureHeader = GroupUtil.hasMeasureHeader(this.crosstabItem, 1);
    }

    public IReportItemExecutor getNextChild() {
        BaseCrosstabExecutor nextExecutor = null;
        if (this.currentGroupIndex < this.columnGroups.size()) {
            EdgeGroup eg = (EdgeGroup)this.columnGroups.get(this.currentGroupIndex++);
            DimensionViewHandle dv = this.crosstabItem.getDimension(1, eg.dimensionIndex);
            LevelViewHandle lv = dv.getLevel(eg.levelIndex);
            nextExecutor = new CrosstabHeaderRowExecutor(this, lv);
        } else if (this.hasMeasureHeader) {
            nextExecutor = new CrosstabMeasureHeaderRowExecutor(this);
            this.hasMeasureHeader = false;
        }
        return nextExecutor;
    }

    public boolean hasNextChild() {
        if (this.currentGroupIndex < this.columnGroups.size()) {
            return true;
        }
        return this.hasMeasureHeader;
    }
}

