/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ContentUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.IColumnWalker;
import org.eclipse.birt.report.model.api.DimensionHandle;

public class TableColumnGenerator
implements ICrosstabConstants {
    private static Logger logger;
    private IColumnWalker walker;
    private CrosstabReportItemHandle crosstabItem;
    private String rowDimension;
    private String rowLevel;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.TableColumnGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    TableColumnGenerator(CrosstabReportItemHandle item, IColumnWalker walker, IBaseResultSet resultSet) {
        DimensionViewHandle dv;
        this.crosstabItem = item;
        this.walker = walker;
        int rdCount = this.crosstabItem.getDimensionCount(0);
        if (rdCount > 0 && (dv = this.crosstabItem.getDimension(0, rdCount - 1)).getLevelCount() > 0) {
            LevelViewHandle lv = dv.getLevel(dv.getLevelCount() - 1);
            this.rowDimension = dv.getCubeDimensionName();
            this.rowLevel = lv.getCubeLevelName();
        }
    }

    void generateColumns(IReportContent report, ITableContent table) throws OLAPException {
        while (this.walker.hasNext()) {
            ColumnEvent ce = this.walker.next();
            this.addColumn(ce, report, table);
            logger.log(Level.INFO, ce.toString());
        }
    }

    private void addColumn(ColumnEvent event, IReportContent report, ITableContent table) {
        DimensionType width;
        Column col = new Column(report);
        DimensionHandle handle = null;
        try {
            block1 : switch (event.type) {
                case 1: {
                    handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getDimension(0, event.dimensionIndex).getLevel(event.levelIndex).getCell());
                    break;
                }
                case 5: {
                    int i = 0;
                    while (i < this.crosstabItem.getMeasureCount()) {
                        MeasureViewHandle mv = this.crosstabItem.getMeasure(i);
                        if (mv.getHeader() != null) {
                            handle = this.crosstabItem.getColumnWidth(mv.getHeader());
                            break block1;
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    if (this.crosstabItem.getMeasureCount() > 0) {
                        int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                        handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getMeasure(mx).getCell());
                        break;
                    }
                    DimensionViewHandle dv = this.crosstabItem.getDimension(1, this.crosstabItem.getDimensionCount(1) - 1);
                    handle = this.crosstabItem.getColumnWidth(dv.getLevel(dv.getLevelCount() - 1).getCell());
                    break;
                }
                case 3: {
                    if (this.crosstabItem.getMeasureCount() > 0) {
                        int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                        DimensionViewHandle dv = this.crosstabItem.getDimension(1, event.dimensionIndex);
                        LevelViewHandle lv = dv.getLevel(event.levelIndex);
                        handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getMeasure(mx).getAggregationCell(this.rowDimension, this.rowLevel, dv.getCubeDimensionName(), lv.getCubeLevelName()));
                        break;
                    }
                    DimensionViewHandle dv = this.crosstabItem.getDimension(1, event.dimensionIndex);
                    handle = this.crosstabItem.getColumnWidth(dv.getLevel(event.levelIndex).getAggregationHeader());
                    break;
                }
                case 4: {
                    if (this.crosstabItem.getMeasureCount() > 0) {
                        int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                        handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getMeasure(mx).getAggregationCell(this.rowDimension, this.rowLevel, null, null));
                        break;
                    }
                    handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getGrandTotal(1));
                    break;
                }
                case 6: {
                    int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                    handle = this.crosstabItem.getColumnWidth(this.crosstabItem.getMeasure(mx).getCell());
                }
            }
        }
        catch (CrosstabException e) {
            logger.log(Level.SEVERE, Messages.getString("TableColumnGenerator.error.process.column.width"), (Throwable)((Object)e));
        }
        if (handle != null && (width = ContentUtil.createDimension(handle)) != null) {
            col.setWidth(width);
        }
        table.addColumn((IColumn)col);
    }
}

