/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.soap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class SOAPRequest {
    private static final String RE_PARAMETER = "\\Q&?\\E.*\\Q?&\\E";
    private String[] template;
    private SOAPParameter[] parameters;

    public SOAPRequest(String queryText) {
        if (WSUtil.isNull(queryText)) {
            return;
        }
        this.generateTemplate(queryText);
        this.generateParameters(queryText);
    }

    private void generateTemplate(String queryText) {
        this.template = queryText.split(RE_PARAMETER);
    }

    private void generateParameters(String queryText) {
        if (!WSUtil.isNull(this.template) && this.template.length > 1) {
            this.parameters = new SOAPParameter[this.template.length - 1];
            int paramId = -1;
            Pattern pattern = Pattern.compile(RE_PARAMETER);
            Matcher matcher = pattern.matcher(queryText);
            while (matcher.find()) {
                String paramName = queryText.substring(matcher.start() + 2, matcher.end() - 2);
                this.parameters[++paramId] = new SOAPParameter(paramId + 1, paramName);
            }
        }
    }

    public String[] getTemplate() {
        return this.template;
    }

    public SOAPParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameterValue(int parameterId, String value) {
        if (!WSUtil.isNull(this.parameters) && this.parameters.length >= parameterId) {
            this.parameters[parameterId - 1].setDefaultValue(value);
        }
    }

    public void setParameterValue(String name, String value) {
        if (!WSUtil.isNull(this.parameters) && !WSUtil.isNull(name)) {
            for (int i = 0; i < this.parameters.length; ++i) {
                if (!this.parameters[i].getName().equals(name)) continue;
                this.parameters[i].setDefaultValue(value);
            }
        }
    }

    public String toXML() {
        if (this.template == null) {
            return "";
        }
        if (this.parameters == null) {
            return this.template[this.template.length - 1];
        }
        String soapRequest = "";
        for (int i = 0; i < this.parameters.length; ++i) {
            soapRequest = soapRequest + this.template[i];
            soapRequest = soapRequest + this.parameters[i].getDefaultValue();
        }
        soapRequest = soapRequest + this.template[this.template.length - 1];
        return soapRequest;
    }
}

