/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.reportitem.FontHelper;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ChartReportStyleProcessor
implements IStyleProcessor {
    private static final String[][] fontSizes = new String[][]{{"xx-small", "7"}, {"x-small", "8"}, {"small", "9"}, {"medium", "10"}, {"large", "11"}, {"x-large", "12"}, {"xx-large", "13"}};
    private DesignElementHandle handle;
    private boolean useCache;
    private IStyle dstyle;
    private SimpleStyle cache = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public ChartReportStyleProcessor(DesignElementHandle handle) {
        this(handle, false, null);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, IStyle style) {
        this(handle, false, style);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache) {
        this(handle, useCache, null);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache, IStyle dstyle) {
        this.handle = handle;
        this.useCache = useCache;
        this.dstyle = dstyle;
    }

    public org.eclipse.birt.chart.style.IStyle getStyle(Chart model, StyledComponent name) {
        SimpleStyle ss = null;
        if (this.cache == null || !this.useCache) {
            ColorDefinition cd;
            int rgbValue;
            StyleHandle style = this.handle.getPrivateStyle();
            ss = new SimpleStyle();
            String fname = style.getFontFamilyHandle().getStringValue();
            fname = FontHelper.getFontFamily(fname);
            int fsize = ChartReportStyleProcessor.getFontSizeIntValue(this.handle);
            boolean fbold = ChartReportStyleProcessor.getFontWeight(style.getFontWeight()) >= 700;
            boolean fitalic = "italic".equals(style.getFontStyle());
            boolean funder = "underline".equals(style.getTextUnderline());
            boolean fstrike = "line-through".equals(style.getTextLineThrough());
            if (this.dstyle != null) {
                CSSValueList valueList = (CSSValueList)this.dstyle.getProperty(49);
                if (valueList.getLength() > 0) {
                    fname = FontHelper.getFontFamily(valueList.item(0).getCssText());
                }
                fsize = this.getSize(this.dstyle.getProperty(38));
                fbold = this.isBoldFont(this.dstyle.getProperty(27));
                fitalic = this.isItalicFont(this.dstyle.getFontStyle());
                funder = "underline".equals(this.dstyle.getTextUnderline());
                fstrike = "line-through".equals(this.dstyle.getTextLineThrough());
            }
            HorizontalAlignment ha = HorizontalAlignment.LEFT_LITERAL;
            if ("center".equals(style.getTextAlign())) {
                ha = HorizontalAlignment.CENTER_LITERAL;
            } else if ("right".equals(style.getTextAlign())) {
                ha = HorizontalAlignment.RIGHT_LITERAL;
            }
            VerticalAlignment va = VerticalAlignment.TOP_LITERAL;
            if ("middle".equals(style.getVerticalAlign())) {
                va = VerticalAlignment.CENTER_LITERAL;
            } else if ("bottom".equals(style.getVerticalAlign())) {
                va = VerticalAlignment.BOTTOM_LITERAL;
            }
            TextAlignment ta = TextAlignmentImpl.create();
            ta.setHorizontalAlignment(ha);
            ta.setVerticalAlignment(va);
            FontDefinition fd = FontDefinitionImpl.create((String)fname, (float)fsize, (boolean)fbold, (boolean)fitalic, (boolean)funder, (boolean)fstrike, (boolean)true, (double)0.0, (TextAlignment)ta);
            ss.setFont(fd);
            ColorHandle ch = style.getColor();
            if (this.dstyle != null) {
                ss.setColor(this.getColor(this.dstyle.getProperty(14)));
            } else if (ch != null && ch.getRGB() != -1) {
                rgbValue = ch.getRGB();
                cd = ColorDefinitionImpl.create((int)(rgbValue >> 16 & 0xFF), (int)(rgbValue >> 8 & 0xFF), (int)(rgbValue & 0xFF));
                ss.setColor(cd);
            } else {
                ss.setColor(ColorDefinitionImpl.BLACK());
            }
            ch = style.getBackgroundColor();
            if (this.dstyle != null) {
                ss.setBackgroundColor(this.getColor(this.dstyle.getProperty(20)));
            } else if (ch != null && ch.getRGB() != -1) {
                rgbValue = ch.getRGB();
                cd = ColorDefinitionImpl.create((int)(rgbValue >> 16 & 0xFF), (int)(rgbValue >> 8 & 0xFF), (int)(rgbValue & 0xFF));
                ss.setBackgroundColor(cd);
            }
            if (style.getBackgroundImage() != null && style.getBackgroundImage().length() > 0) {
                String urlString = style.getBackgroundImage();
                try {
                    new URL(urlString);
                    ss.setBackgroundImage(ImageImpl.create((String)urlString));
                }
                catch (Exception _) {
                    urlString = "file:///" + urlString;
                    try {
                        new URL(urlString);
                        ss.setBackgroundImage(ImageImpl.create((String)urlString));
                    }
                    catch (Exception exception) {
                        logger.log(_);
                    }
                }
            }
            double pt = ChartReportStyleProcessor.convertToPixel(style.getPaddingTop());
            double pb = ChartReportStyleProcessor.convertToPixel(style.getPaddingBottom());
            double pl = ChartReportStyleProcessor.convertToPixel(style.getPaddingLeft());
            double pr = ChartReportStyleProcessor.convertToPixel(style.getPaddingRight());
            ss.setPadding(InsetsImpl.create((double)pt, (double)pl, (double)pb, (double)pr));
            if (this.useCache) {
                this.cache = ss;
            }
        }
        if (this.useCache) {
            ss = this.cache.copy();
        }
        return ss;
    }

    private static int getFontWeight(String fontWeight) {
        int weight = 400;
        if (fontWeight.equals("100")) {
            weight = 100;
        } else if (fontWeight.equals("200")) {
            weight = 200;
        } else if (fontWeight.equals("300")) {
            weight = 300;
        } else if (fontWeight.equals("400")) {
            weight = 400;
        } else if (fontWeight.equals("500")) {
            weight = 500;
        } else if (fontWeight.equals("600")) {
            weight = 600;
        } else if (fontWeight.equals("700")) {
            weight = 700;
        } else if (fontWeight.equals("800")) {
            weight = 800;
        } else if (fontWeight.equals("900")) {
            weight = 900;
        } else if (fontWeight.equals("normal")) {
            weight = 400;
        } else if (fontWeight.equals("bold")) {
            weight = 700;
        }
        return weight;
    }

    private static int getFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (handle == null) {
            return 10;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 10;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = handle.getPrivateStyle().getFontSize().getValue()) instanceof DimensionValue) {
            int size = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
            return (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, size);
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = 0;
            while (i < fontSizes.length) {
                if (fontSizes[i][0].equals(fontSize)) {
                    return Integer.parseInt(fontSizes[i][1]);
                }
                ++i;
            }
        }
        return 10;
    }

    private static int getLargerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (handle == null) {
            return 11;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 11;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = handle.getPrivateStyle().getFontSize().getValue()) instanceof DimensionValue) {
            int size = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
            return (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, size) + 1;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = 0;
            while (i < fontSizes.length - 1) {
                if (fontSize.equals(fontSizes[i][0])) {
                    return Integer.parseInt(fontSizes[i + 1][1]);
                }
                ++i;
            }
            return Integer.parseInt(fontSizes[fontSizes.length - 1][1]);
        }
        return 11;
    }

    private static int getSmallerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (handle == null) {
            return 9;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 9;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = handle.getPrivateStyle().getFontSize().getValue()) instanceof DimensionValue) {
            int gParentFontSize = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
            int size = (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, gParentFontSize) - 1;
            if (size < 1) {
                return 1;
            }
            return size;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = fontSizes.length - 1;
            while (i > 0) {
                if (fontSize.equals(fontSizes[i][0])) {
                    return Integer.parseInt(fontSizes[i - 1][1]);
                }
                --i;
            }
            return Integer.parseInt(fontSizes[0][1]);
        }
        return 9;
    }

    private static double convertToPoint(Object object, int baseSize) {
        return ChartReportStyleProcessor.convertToInch(object, baseSize) * 72.0;
    }

    private static double convertToPixel(Object object) {
        return ChartReportStyleProcessor.convertToInch(object, 0) * 72.0;
    }

    private static double convertToInch(Object object, int baseSize) {
        double inchValue = 0.0;
        double measure = 0.0;
        String units = "";
        if (object instanceof DimensionValue) {
            DimensionValue dimension = (DimensionValue)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        } else if (object instanceof DimensionHandle) {
            DimensionHandle dimension = (DimensionHandle)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        }
        if ("".equalsIgnoreCase(units)) {
            units = "in";
        }
        if ("in".equals(units)) {
            return measure;
        }
        if (baseSize == 0) {
            baseSize = 10;
        }
        inchValue = "em".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize), (String)"pt", (String)"in").getMeasure() : ("ex".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 3.0), (String)"pt", (String)"in").getMeasure() : ("%".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 100.0), (String)"pt", (String)"in").getMeasure() : ("px".equals(units) ? measure / 72.0 : DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure())));
        return inchValue;
    }

    private ColorDefinition getColor(CSSValue value) {
        if (value != null && value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            try {
                return ColorDefinitionImpl.create((int)Math.round(color.getRed().getFloatValue((short)1)), (int)Math.round(color.getGreen().getFloatValue((short)1)), (int)Math.round(color.getBlue().getFloatValue((short)1)));
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING.intValue(), "invalid color: {0}" + value.toString());
            }
        }
        return null;
    }

    private int getSize(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            return (int)(((FloatValue)value).getFloatValue() / 1000.0f);
        }
        return 0;
    }

    private boolean isBoldFont(CSSValue value) {
        String weight;
        return value instanceof StringValue && value != null && ("bold".equals((weight = ((StringValue)value).getStringValue()).toLowerCase()) || "bolder".equals(weight.toLowerCase()) || "600".equals(weight) || "700".equals(weight) || "800".equals(weight) || "900".equals(weight));
    }

    private boolean isItalicFont(String italic) {
        return "oblique".equals(italic) || "italic".equals(italic);
    }
}

