/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.flatfile.DataTypes;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSet;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaDataHelper;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.FlatFileDataReader;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.QueryTextUtil;

public class FlatFileQuery
implements IQuery {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private boolean hasColumnNames;
    private boolean hasTypeLine;
    private Properties connProperties;
    private String currentTableName = null;
    private int maxRows = 0;
    private IConnection connection = null;
    private IResultSetMetaData resultSetMetaData = null;
    private ResultSetMetaDataHelper resultSetMetaDataHelper = null;

    public FlatFileQuery(Properties connProperties, IConnection host) throws OdaException {
        if (connProperties == null || connProperties.getProperty("HOME") == null || host == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.connProperties = connProperties;
        this.connection = host;
        this.extractsHasColumnNamesInfo();
        this.extractsHasColumnTypeLineInfo();
    }

    private void extractsHasColumnNamesInfo() {
        this.hasColumnNames = !this.connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void extractsHasColumnTypeLineInfo() {
        this.hasTypeLine = !this.connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    public void prepare(String queryText) throws OdaException {
        if (queryText == null) {
            throw new OdaException(Messages.getString("common_NULL_QUERY_TEXT"));
        }
        String query = QueryTextUtil.getQuery(queryText);
        String colInfo = QueryTextUtil.getColumnsInfo(queryText);
        this.validateOpenConnection();
        String formattedQuery = this.formatQueryText(query);
        this.validateQueryText(formattedQuery);
        this.prepareMetaData(formattedQuery, colInfo);
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setProperty(String name, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void close() throws OdaException {
        this.currentTableName = null;
        this.maxRows = 0;
        this.connection = null;
        this.resultSetMetaData = null;
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        return new ResultSet(new FlatFileDataReader(this.connProperties, this.currentTableName, this.maxRows, this.resultSetMetaData, this.resultSetMetaDataHelper), this.resultSetMetaData);
    }

    public void setInt(String parameterName, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(int parameterId, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(String parameterName, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(int parameterId, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int findInParameter(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void clearInParameters() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    private void validateOpenConnection() throws OdaException {
        if (!this.connection.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_IS_NOT_OPEN"));
        }
    }

    private void validateQueryText(String formattedQuery) throws OdaException {
        this.validateNonEmptyQueryText(formattedQuery);
        String[] queryFragments = this.parsePreparedQueryText(formattedQuery);
        this.validateSingleTableQuery(queryFragments);
        this.validateQueryColumnNames(queryFragments);
    }

    private void validateNonEmptyQueryText(String formattedQuery) throws OdaException {
        if (formattedQuery == null || formattedQuery.length() == 0) {
            throw new OdaException(Messages.getString("query_COMMAND_IS_EMPTY"));
        }
    }

    private void validateSingleTableQuery(String[] parsedQuerySegments) throws OdaException {
        if (this.getPreparedTableNames(parsedQuerySegments).split(",").length != 1) {
            throw new OdaException(Messages.getString("query_DO_NOT_SUPPORT_CROSS_TABLE_QUERY"));
        }
    }

    private void validateQueryColumnNames(String[] parsedQuerySegments) throws OdaException {
        String preparedColumnNames = this.getPreparedColumnNames(parsedQuerySegments);
        String tableName = this.getPreparedTableNames(parsedQuerySegments);
        if (!this.isWildCard(preparedColumnNames)) {
            String[] originalColumnNames = null;
            originalColumnNames = this.hasColumnNames ? this.discoverActualColumnMetaData(this.getPreparedTableNames(parsedQuerySegments), NAME_LITERAL) : this.createTempColumnNames(new FlatFileDataReader(this.connProperties, tableName, 0, null, null).getColumnCount());
            this.validateColumnName(FlatFileDataReader.getStringArrayFromVector(this.stripFormatInfoFromQueryColumnNames(this.getQueryColumnNamesVector(preparedColumnNames))), originalColumnNames);
        }
    }

    private String getPreparedColumnNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[0];
    }

    private String getPreparedColumnLabels(String[] parsedQueryFragments) {
        return parsedQueryFragments[1];
    }

    private String getPreparedTableNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[2];
    }

    private String[] parsePreparedQueryText(String formattedQuery) throws OdaException {
        String queryWithoutSELECTKeyword = this.stripSELECTKeyword(formattedQuery);
        String[] querySelectAndFromFragments = this.stripFROMKeyword(queryWithoutSELECTKeyword);
        return this.stripASKeyword(querySelectAndFromFragments);
    }

    private String[] stripASKeyword(String[] querySelectAndFromFragments) {
        String[] result = new String[3];
        result[2] = querySelectAndFromFragments[1];
        String selectedColumns = querySelectAndFromFragments[0];
        if (!this.isWildCard(selectedColumns)) {
            String[] columns = FlatFileDataReader.getStringArrayFromVector(this.getQueryColumnNamesVector(selectedColumns));
            for (int i = 0; i < columns.length; ++i) {
                String[] columnNameAlias = columns[i].split(" AS ");
                if (columnNameAlias == null) continue;
                String string = result[0] = i == 0 ? columnNameAlias[0] : result[0] + "," + columnNameAlias[0].trim();
                result[1] = columnNameAlias.length == 2 ? (i == 0 ? columnNameAlias[1] : result[1] + "," + columnNameAlias[1].trim()) : (i == 0 ? null : result[1] + "," + null);
            }
        } else {
            result[0] = "*";
            result[1] = null;
        }
        return result;
    }

    private Vector getQueryColumnNamesVector(String queryColumnNames) {
        Vector<String> result = new Vector<String>();
        char[] chars = queryColumnNames.toCharArray();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        boolean inQuote = false;
        boolean isEscaped = false;
        int beginIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                    continue;
                }
                isEscaped = !isEscaped;
                continue;
            }
            if (chars[i] == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (chars[i] != ',' || inQuote) continue;
            indiceList.add(new Integer(i));
        }
        if (indiceList.size() > 0) {
            for (int j = 0; j < indiceList.size(); ++j) {
                endIndex = (Integer)indiceList.get(j);
                result.add(queryColumnNames.substring(beginIndex, endIndex).trim());
                beginIndex = endIndex + 1;
                if (j != indiceList.size() - 1) continue;
                result.add(queryColumnNames.substring(beginIndex, queryColumnNames.length()).trim());
            }
        } else {
            result.add(queryColumnNames);
        }
        return result;
    }

    private Vector stripFormatInfoFromQueryColumnNames(Vector queryColumnNames) {
        Vector columnNames = new Vector();
        boolean isEscaped = false;
        for (int i = 0; i < queryColumnNames.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            char[] chars = ((String)queryColumnNames.get(i)).toCharArray();
            if (chars[0] != '\"') {
                columnNames.add(queryColumnNames.get(i));
                continue;
            }
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] == '\"') {
                    if (!isEscaped) continue;
                    sb.append(chars[j]);
                    isEscaped = !isEscaped;
                    continue;
                }
                if (chars[j] == '\\') {
                    if (isEscaped) {
                        sb.append(chars[j]);
                    }
                    isEscaped = !isEscaped;
                    continue;
                }
                sb.append(chars[j]);
            }
            columnNames.add(sb.toString());
        }
        return columnNames;
    }

    private String[] stripFROMKeyword(String queryWithoutSELECTKeyword) throws OdaException {
        String[] result = queryWithoutSELECTKeyword.split(" FROM ");
        if (result == null || result.length != 2) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return result;
    }

    private String stripSELECTKeyword(String formattedQuery) throws OdaException {
        String[] array = formattedQuery.split(" ", 2);
        if (array == null || array.length != 2 || !array[0].trim().equalsIgnoreCase("SELECT")) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return array[1];
    }

    private String[] createTempColumnNames(int columnCount) {
        String[] tempColumnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
        }
        return tempColumnNames;
    }

    private String[] createTempColumnTypes(int columnCount) {
        String[] tempColumnTypes = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            tempColumnTypes[i] = "STRING";
        }
        return tempColumnTypes;
    }

    private String[] discoverActualColumnMetaData(String tableName, String metaDataType) throws OdaException {
        FlatFileDataReader ffdsr = new FlatFileDataReader(this.connProperties, tableName, 0, null, null);
        try {
            String columnNameLine;
            if (!metaDataType.trim().equalsIgnoreCase(NAME_LITERAL) && !metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                throw new OdaException(Messages.getString("query_ARGUMENT_ERROR"));
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                while (FlatFileDataReader.isEmptyRow(ffdsr.readLine())) {
                }
            }
            while (FlatFileDataReader.isEmptyRow(columnNameLine = ffdsr.readLine())) {
            }
            String[] result = ffdsr.getColumnNameArray(columnNameLine, metaDataType.trim().equalsIgnoreCase(NAME_LITERAL));
            ffdsr.clearBufferedReader();
            if (metaDataType.trim().equalsIgnoreCase(NAME_LITERAL)) {
                this.validateUniqueName(result);
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                this.validateColumnTypeConsistency(result);
            }
            return this.trimStringArray(result);
        }
        catch (IOException e) {
            throw new OdaException(Messages.getString("query_IO_EXCEPTION") + ffdsr.findDataFileAbsolutePath());
        }
    }

    private String[] trimStringArray(String[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].trim();
        }
        return result;
    }

    private void validateColumnName(String[] cCN, String[] aCN) throws OdaException {
        for (int i = 0; i < cCN.length; ++i) {
            if (this.findOccuranceOfValueInStringArray(cCN[i], aCN) == 1) continue;
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
    }

    private boolean isWildCard(String cCN) {
        return cCN.equalsIgnoreCase("*");
    }

    private void validateUniqueName(String[] aCN) throws OdaException {
        for (int i = 0; i < aCN.length; ++i) {
            if (this.findOccuranceOfValueInStringArray(aCN[i], aCN) <= 1) continue;
            throw new OdaException(Messages.getString("query_SOURCE_DATA_ERROR"));
        }
    }

    private void validateColumnTypeConsistency(String[] aCT) throws OdaException {
        if (!this.hasTypeLine) {
            return;
        }
        for (int i = 0; i < aCT.length; ++i) {
            if (DataTypes.isValidType(aCT[i])) continue;
            throw new OdaException(Messages.getString("dataTypes_TYPE_NAME_INVALID") + aCT[i]);
        }
    }

    private int findOccuranceOfValueInStringArray(String value, String[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!value.trim().equalsIgnoreCase(array[i].trim())) continue;
            ++count;
        }
        return count;
    }

    private void prepareMetaData(String query, String savedSelectedColInfo) throws OdaException {
        String[] allColumnTypes;
        String[] queryFragments = this.parsePreparedQueryText(query);
        String tableName = this.getPreparedTableNames(queryFragments);
        FlatFileDataReader ffdsr = new FlatFileDataReader(this.connProperties, tableName, 0, null, null);
        String[] allColumnNames = this.hasColumnNames ? this.discoverActualColumnMetaData(tableName, NAME_LITERAL) : this.createTempColumnNames(ffdsr.getColumnCount());
        String[] stringArray = allColumnTypes = this.hasTypeLine ? this.discoverActualColumnMetaData(tableName, TYPE_LITERAL) : this.createTempColumnTypes(ffdsr.getColumnCount());
        if (allColumnNames.length != allColumnTypes.length) {
            throw new OdaException(Messages.getString("invalid_flatfile_format"));
        }
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        String[] queryColumnLables = null;
        if (this.isWildCard(this.getPreparedColumnNames(queryFragments))) {
            queryColumnNames = allColumnNames;
            queryColumnTypes = allColumnTypes;
            queryColumnLables = allColumnNames;
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        } else if (savedSelectedColInfo == null || savedSelectedColInfo.length() == 0) {
            queryColumnNames = FlatFileDataReader.getStringArrayFromVector(this.stripFormatInfoFromQueryColumnNames(this.getQueryColumnNamesVector(this.getPreparedColumnNames(queryFragments))));
            queryColumnTypes = this.hasTypeLine ? this.getQueryColumnTypes(allColumnNames, allColumnTypes, queryColumnNames) : this.createTempColumnTypes(queryColumnNames.length);
            String[] stringArray2 = queryColumnLables = this.hasColumnNames ? this.getColumnLabels(queryFragments) : queryColumnNames;
            if (queryColumnLables == null) {
                queryColumnLables = queryColumnNames;
            }
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        } else {
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(savedSelectedColInfo);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        }
        this.currentTableName = tableName;
    }

    private String[] getQueryColumnTypes(String[] allColumnNames, String[] allColumnTypes, String[] queryColumnNames) {
        if (!this.hasTypeLine) {
            return null;
        }
        String[] queryColumnTypes = new String[queryColumnNames.length];
        for (int i = 0; i < queryColumnNames.length; ++i) {
            for (int j = 0; j < allColumnNames.length; ++j) {
                if (!queryColumnNames[i].trim().equalsIgnoreCase(allColumnNames[j])) continue;
                queryColumnTypes[i] = allColumnTypes[j];
            }
        }
        return queryColumnTypes;
    }

    private String[] getColumnLabels(String[] queryFragments) {
        String queryColumnLabels = this.getPreparedColumnLabels(queryFragments);
        return queryColumnLabels != null ? queryColumnLabels.split(",") : null;
    }

    private String formatQueryText(String queryText) {
        String result = "";
        String[] temp = queryText.trim().split(" ");
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].equalsIgnoreCase("AS")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("FROM")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("SELECT")) {
                temp[i] = temp[i].toUpperCase();
            }
            result = result + temp[i] + " ";
        }
        return result.trim();
    }

    public static class FlatFileBufferedReader {
        private Reader reader;
        private char[] charBuffer;
        private int startingPosition;
        private int eofInPosition;
        private static int CHARBUFFSIZE = 8192;

        public FlatFileBufferedReader(Reader in) {
            this.reader = new BufferedReader(in);
            this.startingPosition = -1;
            this.eofInPosition = -2;
        }

        public String readLine() throws IOException {
            if (this.isLastCharBuff() && this.needRefillCharBuff()) {
                return null;
            }
            if (this.needRefillCharBuff()) {
                this.charBuffer = this.newACharBuff();
                int close = this.reader.read(this.charBuffer);
                if (close == -1) {
                    return null;
                }
                if (close != CHARBUFFSIZE) {
                    this.eofInPosition = close;
                }
                this.startingPosition = 0;
            }
            String candidate = "";
            int stopIn = CHARBUFFSIZE;
            if (this.isLastCharBuff()) {
                stopIn = this.eofInPosition;
            }
            for (int i = this.startingPosition; i < stopIn; ++i) {
                if (this.charBuffer[i] != '\n') continue;
                return this.readALine(candidate, stopIn, i);
            }
            if (this.isLastCharBuff()) {
                return this.readLastLine(candidate);
            }
            return this.readExtraContentOfALine(candidate);
        }

        private String readExtraContentOfALine(String candidate) throws IOException {
            candidate = candidate + String.copyValueOf(this.charBuffer, this.startingPosition, CHARBUFFSIZE - this.startingPosition);
            this.resetCharBufferStartPosition();
            String nextLine = this.readLine();
            return candidate + (nextLine == null ? "" : nextLine);
        }

        private String readALine(String candidate, int stopIn, int i) {
            candidate = candidate + String.copyValueOf(this.charBuffer, this.startingPosition, i - this.startingPosition);
            this.startingPosition = i == stopIn - 1 ? -1 : i + 1;
            return candidate;
        }

        private String readLastLine(String candidate) {
            candidate = candidate + String.copyValueOf(this.charBuffer, this.startingPosition, this.eofInPosition - this.startingPosition);
            this.resetCharBufferStartPosition();
            return candidate;
        }

        private void resetCharBufferStartPosition() {
            this.startingPosition = -1;
        }

        private boolean needRefillCharBuff() {
            return this.startingPosition == -1;
        }

        private boolean isLastCharBuff() {
            return this.eofInPosition != -2;
        }

        public void close() throws IOException {
            this.reader.close();
        }

        private char[] newACharBuff() {
            return new char[CHARBUFFSIZE];
        }
    }
}

