/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatFactory;
import org.eclipse.datatools.connectivity.oda.flatfile.util.PatternKey;
import org.eclipse.osgi.util.NLS;

public class DateFormatISO8601 {
    public static Date parse(String source) throws ParseException, ParseException {
        if (source == null) {
            return null;
        }
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            try {
                resultDate = simpleDateFormatter.parse(source);
                return resultDate;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new ParseException(NLS.bind((String)Messages.getString("dateFormatISO_cannotConvert"), (Object)source), 0);
        }
        return resultDate;
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = s.replaceFirst("T", " ");
        }
        if ((zoneIndex = s.indexOf("GMT")) > 0) {
            return s.substring(0, zoneIndex).trim();
        }
        zoneIndex = s.indexOf(90);
        if (zoneIndex == s.length() - 1) {
            return s.substring(0, zoneIndex).trim();
        }
        zoneIndex = s.indexOf(43);
        if (zoneIndex > 0) {
            return s.substring(0, zoneIndex).trim();
        }
        return s;
    }
}

