/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Line
extends AxesRenderer {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected double computeStackPosition(AxisSubUnit au, double dValue, Axis ax) {
        if (ax.isPercent()) {
            dValue = au.valuePercentage(dValue);
        }
        return au.stackValue(dValue);
    }

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        int iThisSeriesIndex;
        boolean bShowAsTape;
        LineSeries ls;
        double dSeriesThickness;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        boolean bRendering3D = this.isDimension3D();
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        Bounds boClientArea = isrh.getClientAreaBounds(true);
        double d = dSeriesThickness = bRendering3D ? 0.0 : srh.getSeriesThickness();
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        if (!(ls = (LineSeries)this.getSeries()).isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ls}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ls.isVisible()) {
            return;
        }
        ChartDimension cd = cwa.getDimension();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        double fX = 0.0;
        double fY = 0.0;
        double fZ = 0.0;
        double fWidth = 0.0;
        double fWidthZ = 0.0;
        double fHeight = 0.0;
        Location lo = null;
        Location3D lo3d = null;
        boolean bl = bShowAsTape = cd.getValue() == 1 || cd.getValue() == 2;
        if (bShowAsTape) {
            bShowAsTape = this.validateShowAsTape();
        }
        Axis ax = this.getAxis();
        StackedSeriesLookup ssl = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
        }
        LineAttributes lia = ls.getLineAttributes();
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        double[] faZ = new double[dpha.length];
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ls}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
        } else if (this.iSeriesIndex > 0) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get((this.iSeriesIndex - 1) % iPaletteSize)));
        }
        this.updateTranslucency(fPaletteEntry, (Series)ls);
        double dTapeWidth = -1.0;
        double dUnitSpacingZ = 0.0;
        int i = 0;
        while (i < dpha.length) {
            double dEnd;
            double dValue;
            AxisSubUnit au;
            if (bRendering3D) {
                lo3d = dpha[i].getLocation3D();
                if (dTapeWidth == -1.0) {
                    double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
                    dTapeWidth = dpha[i].getSize2D().getHeight() * (100.0 - dUnitSpacing) / 100.0;
                    dUnitSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                }
            } else {
                lo = dpha[i].getLocation();
            }
            if (cwa.isTransposed()) {
                if (srh.isCategoryScale()) {
                    fHeight = dpha[i].getSize();
                }
                faY[i] = fY = lo.getY() + fHeight / 2.0;
                if (ls.isStacked() || ax.isPercent()) {
                    au = ssl.getUnit((Series)ls, i);
                    dValue = Line.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                    dEnd = this.computeStackPosition(au, dValue, ax);
                    try {
                        faX[i] = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                        dpha[i].setStackOrthogonalValue(new Double(dEnd));
                        if (faX[i] < srh.getPlotBaseLocation()) {
                            faX[i] = srh.getPlotBaseLocation();
                        }
                        au.setLastPosition(dValue, faX[i], 0.0);
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                    }
                } else {
                    faX[i] = lo.getX();
                }
            } else {
                if (bRendering3D) {
                    fWidth = dpha[i].getSize2D().getWidth();
                    fWidthZ = dpha[i].getSize2D().getHeight();
                    fX = lo3d.getX() + fWidth / 2.0;
                    fZ = lo3d.getZ() + fWidthZ - dUnitSpacingZ;
                    faX[i] = fX;
                    faZ[i] = fZ;
                } else {
                    if (srh.isCategoryScale()) {
                        fWidth = dpha[i].getSize();
                    }
                    faX[i] = fX = lo.getX() + fWidth / 2.0;
                }
                if (ls.isStacked() || ax.isPercent()) {
                    if (bRendering3D) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    au = ssl.getUnit((Series)ls, i);
                    dValue = Line.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                    dEnd = this.computeStackPosition(au, dValue, ax);
                    try {
                        faY[i] = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                        dpha[i].setStackOrthogonalValue(new Double(dEnd));
                        au.setLastPosition(dValue, faY[i], 0.0);
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                    }
                } else {
                    faY[i] = bRendering3D ? lo3d.getY() : lo.getY();
                }
                if (bRendering3D) {
                    double plotBaseLocation = srh3d.getPlotBaseLocation();
                    if (faY[i] < plotBaseLocation) {
                        faY[i] = plotBaseLocation;
                    }
                    if (faY[i] > plotBaseLocation + srh3d.getPlotHeight()) {
                        faY[i] = plotBaseLocation + srh3d.getPlotHeight();
                    }
                }
            }
            ++i;
        }
        if (!bRendering3D) {
            this.handleOutsideDataPoints(ipr, srh, faX, faY, bShowAsTape);
        }
        if (ls.isSetCurve() && ls.isCurve()) {
            this.renderAsCurve(ipr, ls.getLineAttributes(), (ISeriesRenderingHints)(bRendering3D ? srh3d : srh), (Location[])(bRendering3D ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isSetPaletteLineColor() && ls.isPaletteLineColor());
            this.renderShadowAsCurve(ipr, lia, (ISeriesRenderingHints)(bRendering3D ? srh3d : srh), (Location[])(bRendering3D ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth);
            if (m != null && m.isSetType()) {
                i = 0;
                while (i < dpha.length) {
                    if (!dpha[i].isOutside()) {
                        fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                        this.updateTranslucency(fPaletteEntry, (Series)ls);
                        ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                        ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                        this.renderMarker(ls, ipr, m, (Location)(bRendering3D ? Location3DImpl.create((double)faX[i], (double)faY[i], (double)faZ[i]) : LocationImpl.create((double)faX[i], (double)faY[i])), ls.getLineAttributes(), fPaletteEntry, dpha[i], null, true, true);
                        ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                        ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                    }
                    ++i;
                }
            }
        } else {
            if (!lia.isSetVisible()) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.visibility.line.unset", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            this.renderShadow(ipr, p, lia, (Location[])(bRendering3D ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dpha);
            this.renderDataPoints(ipr, p, (ISeriesRenderingHints)(bRendering3D ? srh3d : srh), dpha, lia, (Location[])(bRendering3D ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isSetPaletteLineColor() && ls.isPaletteLineColor());
            if (m != null && m.isSetType()) {
                i = 0;
                while (i < dpha.length) {
                    fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                    this.updateTranslucency(fPaletteEntry, (Series)ls);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                    this.renderMarker(ls, ipr, m, (Location)(bRendering3D ? Location3DImpl.create((double)faX[i], (double)faY[i], (double)faZ[i]) : LocationImpl.create((double)faX[i], (double)faY[i])), ls.getLineAttributes(), fPaletteEntry, dpha[i], null, true, true);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                    ++i;
                }
            }
        }
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        Location3D loDataPoint3d = null;
        try {
            if (bRendering3D) {
                laDataPoint = srh3d.getLabelAttributes((Series)ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh3d.getLabelPosition((Series)ls);
                    loDataPoint3d = Location3DImpl.create((double)0.0, (double)0.0, (double)0.0);
                }
            } else {
                laDataPoint = srh.getLabelAttributes((Series)ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh.getLabelPosition((Series)ls);
                    loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
                }
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            double dSize = m == null ? 0 : m.getSize();
            int i2 = 0;
            while (i2 < dpha.length) {
                if (!Line.isNaN((Object)dpha[i2].getOrthogonalValue()) && !dpha[i2].isOutside()) {
                    laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)ls) : srh.getLabelAttributes((Series)ls);
                    laDataPoint.getCaption().setValue(dpha[i2].getDisplayValue());
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                    if (laDataPoint.isVisible()) {
                        if (bRendering3D) {
                            switch (pDataPoint.getValue()) {
                                case 0: {
                                    loDataPoint3d.set(faX[i2], faY[i2] + dSize + (double)p.getVerticalSpacing(), faZ[i2] + 1.0);
                                    break;
                                }
                                case 1: {
                                    loDataPoint3d.set(faX[i2], faY[i2] - dSize - (double)p.getVerticalSpacing(), faZ[i2] + 1.0);
                                    break;
                                }
                                case 2: {
                                    loDataPoint3d.set(faX[i2] - dSize - (double)p.getHorizontalSpacing(), faY[i2], faZ[i2] + 1.0);
                                    break;
                                }
                                case 3: {
                                    loDataPoint3d.set(faX[i2] + dSize + (double)p.getHorizontalSpacing(), faY[i2], faZ[i2] + 1.0);
                                    break;
                                }
                                default: {
                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                }
                            }
                            EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                            StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dpha[i2]);
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.birt.chart.event.Text3DRenderEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Text3DRenderEvent tre3d = (Text3DRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                            tre3d.setAction(2);
                            tre3d.setLabel(laDataPoint);
                            tre3d.setTextPosition(Methods.getLabelPosition((Position)pDataPoint));
                            tre3d.setLocation3D(loDataPoint3d);
                            this.getDeferredCache().addLabel((TextRenderEvent)tre3d);
                        } else {
                            switch (pDataPoint.getValue()) {
                                case 0: {
                                    loDataPoint.set(faX[i2], faY[i2] - dSize - (double)p.getVerticalSpacing());
                                    break;
                                }
                                case 1: {
                                    loDataPoint.set(faX[i2], faY[i2] + dSize + (double)p.getVerticalSpacing());
                                    break;
                                }
                                case 2: {
                                    loDataPoint.set(faX[i2] - dSize - (double)p.getHorizontalSpacing(), faY[i2]);
                                    break;
                                }
                                case 3: {
                                    loDataPoint.set(faX[i2] + dSize + (double)p.getHorizontalSpacing(), faY[i2]);
                                    break;
                                }
                                default: {
                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                }
                            }
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dpha[i2]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                        }
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
                }
                ++i2;
            }
        }
        if (!bRendering3D && this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i3 = 0;
            while (i3 < larray.length) {
                larray[i3] = LocationImpl.create((double)faX[i3], (double)faY[i3]);
                ++i3;
            }
            larray = this.filterNull(larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        if (!bRendering3D) {
            this.restoreClipping(ipr);
        }
    }

    protected boolean validateShowAsTape() {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        LineSeries ls = (LineSeries)this.getSeries();
        if (!ls.isStacked()) {
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        } else {
            Axis[] axaOrthogonal = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            if (axaOrthogonal.length > 1) {
                return false;
            }
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        }
        return true;
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        double height;
        double width;
        int markerSize;
        int iThisSeriesIndex;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        LineSeries ls = (LineSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        StructureSource structureSource = StructureSource.createLegend((Legend)lg);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (!liaMarker.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.marker.linestyle.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (liaMarker.isVisible()) {
            EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
            StructureSource structureSource2 = StructureSource.createLegend((Legend)lg);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
            if (fPaletteEntry instanceof ColorDefinition && ls.isSetPaletteLineColor() && ls.isPaletteLineColor()) {
                liaMarker = LineAttributesImpl.copyInstance((LineAttributes)liaMarker);
                liaMarker.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)fPaletteEntry)));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            ipr.drawLine(lre);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        if ((markerSize = (int)((((width = bo.getWidth() / this.getDeviceScale()) > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0)) <= 0) {
            markerSize = 1;
        }
        if (m != null && m.isVisible()) {
            this.renderMarker(lg, ipr, m, LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + bo.getHeight() / 2.0)), ls.getLineAttributes(), fPaletteEntry, null, new Integer(markerSize), false, false);
        }
    }

    protected void renderAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        CurveRenderer cr = new CurveRenderer((ChartWithAxes)this.getModel(), (BaseRenderer)this, lia, loa, bShowAsTape, tapeWidth, true, !this.isDimension3D(), paletteEntry, usePaletteLineColor, ((LineSeries)this.getSeries()).isConnectMissingValue());
        cr.draw(ipr);
    }

    protected void renderShadowAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != ColorDefinitionImpl.TRANSPARENT().getTransparency() && lia.isSetVisible() && lia.isVisible()) {
            Location positionDelta = ((ChartWithAxes)this.getModel()).isTransposed() ? LocationImpl.create((double)(-2.0 * this.getDeviceScale()), (double)0.0) : LocationImpl.create((double)0.0, (double)(2.0 * this.getDeviceScale()));
            double[] shX = new double[loa.length];
            double[] shY = new double[loa.length];
            int i = 0;
            while (i < loa.length) {
                shX[i] = loa[i].getX() + positionDelta.getX();
                shY[i] = loa[i].getY() + positionDelta.getY();
                ++i;
            }
            LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
            liaShadow.setColor(cLineShadow);
            this.renderAsCurve(ipr, liaShadow, srh, LocationImpl.create((double[])shX, (double[])shY), bShowAsTape, tapeWidth, (Fill)liaShadow.getColor(), false);
        }
    }

    protected void renderDataPoints(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints srh, DataPointHints[] dpha, LineAttributes lia, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        Polygon3DRenderEvent polygon3DRenderEvent;
        Line3DRenderEvent lre3d;
        Line3DRenderEvent line3DRenderEvent;
        PolygonRenderEvent pre;
        PolygonRenderEvent polygonRenderEvent;
        if (!lia.isSetVisible() || !lia.isVisible()) {
            return;
        }
        Location[] loaPlane = null;
        Location[] loaLine = null;
        Location3D[] loa3d = null;
        Location3D[] loaPlane3d = null;
        Location3D[] loaLine3d = null;
        Series ls = this.getSeries();
        boolean bRendering3D = this.isDimension3D();
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        StructureSource structureSource = StructureSource.createSeries((Series)ls);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
        if (bShowAsTape) {
            EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
            StructureSource structureSource2 = StructureSource.createSeries((Series)ls);
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            polygonRenderEvent = (PolygonRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
        } else {
            polygonRenderEvent = pre = null;
        }
        if (bRendering3D) {
            EventObjectCache eventObjectCache3 = (EventObjectCache)ipr;
            StructureSource structureSource3 = StructureSource.createSeries((Series)ls);
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            line3DRenderEvent = (Line3DRenderEvent)eventObjectCache3.getEventObject((Object)structureSource3, (Class)clazz3);
        } else {
            line3DRenderEvent = lre3d = null;
        }
        if (bShowAsTape && bRendering3D) {
            EventObjectCache eventObjectCache4 = (EventObjectCache)ipr;
            StructureSource structureSource4 = StructureSource.createSeries((Series)ls);
            Class<?> clazz4 = class$5;
            if (clazz4 == null) {
                try {
                    clazz4 = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            polygon3DRenderEvent = (Polygon3DRenderEvent)eventObjectCache4.getEventObject((Object)structureSource4, (Class)clazz4);
        } else {
            polygon3DRenderEvent = null;
        }
        Polygon3DRenderEvent pre3d = polygon3DRenderEvent;
        DeferredCache dc = this.getDeferredCache();
        if (paletteEntry instanceof ColorDefinition && usePaletteLineColor) {
            lia = LineAttributesImpl.copyInstance((LineAttributes)lia);
            lia.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)paletteEntry)));
        }
        if (!bRendering3D) {
            dTapeWidth = ((SeriesRenderingHints)srh).getSeriesThickness();
        }
        List<double[]> points = new ArrayList();
        if (bRendering3D) {
            loa3d = (Location3D[])loa;
            pre3d.setDoubleSided(true);
        }
        if (dpha.length > 0) {
            int i = 0;
            while (i < dpha.length) {
                if (!Line.isNaN((Object)dpha[i].getOrthogonalValue())) {
                    if (bRendering3D) {
                        points.add(new double[]{loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ()});
                    } else {
                        points.add(new double[]{loa[i].getX(), loa[i].getY()});
                    }
                    if (!((LineSeries)ls).isConnectMissingValue() && (i == 0 || i > 0 && Line.isNaN((Object)dpha[i - 1].getOrthogonalValue()))) {
                        if (i == dpha.length - 1 || Line.isNaN((Object)dpha[i + 1].getOrthogonalValue())) {
                            OvalRenderEvent event;
                            double iSize = (double)lia.getThickness() * 2.0;
                            if (bRendering3D) {
                                EventObjectCache eventObjectCache5 = (EventObjectCache)ipr;
                                StructureSource structureSource5 = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]);
                                Class<?> clazz5 = class$4;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Line3DRenderEvent lre3dValue = (Line3DRenderEvent)eventObjectCache5.getEventObject((Object)structureSource5, (Class)clazz5);
                                Location3D[] loa3dValue = new Location3D[]{Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)(loa3d[i].getZ() - dTapeWidth))};
                                lre3dValue.setStart3D(loa3dValue[0]);
                                lre3dValue.setEnd3D(loa3dValue[1]);
                                lre3dValue.setLineAttributes(lia);
                                dc.addLine((LineRenderEvent)lre3dValue);
                                event = lre3dValue;
                            } else {
                                EventObjectCache eventObjectCache6 = (EventObjectCache)ipr;
                                StructureSource structureSource6 = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]);
                                Class<?> clazz6 = class$6;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                OvalRenderEvent ore = (OvalRenderEvent)eventObjectCache6.getEventObject((Object)structureSource6, (Class)clazz6);
                                ore.setBounds(BoundsImpl.create((double)(loa[i].getX() - iSize / 2.0), (double)(loa[i].getY() - iSize / 2.0), (double)iSize, (double)iSize));
                                ore.setOutline(lia);
                                ipr.drawOval(ore);
                                event = ore;
                            }
                            this.addInteractivity(ipr, dpha[i], (PrimitiveRenderEvent)event);
                        }
                    } else {
                        int pindex = this.getPreviousNonNullIndex(i, dpha);
                        if (pindex != -1) {
                            if (bRendering3D) {
                                if (loaLine3d == null) {
                                    loaLine3d = new Location3D[]{Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)loa3d[pindex].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ())};
                                    lre3d.setStart3D(loaLine3d[0]);
                                    lre3d.setEnd3D(loaLine3d[1]);
                                    lre3d.setLineAttributes(lia);
                                } else {
                                    loaLine3d[0].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ());
                                    loaLine3d[1].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ());
                                    lre3d.setStart3D(loaLine3d[0]);
                                    lre3d.setEnd3D(loaLine3d[1]);
                                }
                                this.addInteractivity(ipr, dpha[i], (PrimitiveRenderEvent)lre3d);
                            } else {
                                if (loaLine == null) {
                                    loaLine = new Location[]{LocationImpl.create((double)loa[pindex].getX(), (double)loa[pindex].getY()), LocationImpl.create((double)loa[i].getX(), (double)loa[i].getY())};
                                    lre.setStart(loaLine[0]);
                                    lre.setEnd(loaLine[1]);
                                    lre.setLineAttributes(lia);
                                } else {
                                    loaLine[0].set(loa[pindex].getX(), loa[pindex].getY());
                                    loaLine[1].set(loa[i].getX(), loa[i].getY());
                                }
                                this.addInteractivity(ipr, dpha[i], (PrimitiveRenderEvent)lre);
                            }
                            if (bShowAsTape) {
                                if (bRendering3D) {
                                    if (loaPlane3d == null) {
                                        loaPlane3d = new Location3D[]{Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)loa3d[pindex].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)(loa3d[i].getZ() - dTapeWidth)), Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)(loa3d[pindex].getZ() - dTapeWidth))};
                                        pre3d.setOutline(null);
                                        pre3d.setPoints3D(loaPlane3d);
                                        pre3d.setBackground((Fill)lia.getColor().brighter());
                                    } else {
                                        loaPlane3d[0].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ());
                                        loaPlane3d[1].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ());
                                        loaPlane3d[2].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ() - dTapeWidth);
                                        loaPlane3d[3].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ() - dTapeWidth);
                                        pre3d.setPoints3D(loaPlane3d);
                                    }
                                    this.addInteractivity(ipr, dpha[i], (PrimitiveRenderEvent)pre3d);
                                    dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                                } else {
                                    if (loaPlane == null) {
                                        loaPlane = new Location[]{LocationImpl.create((double)loa[pindex].getX(), (double)loa[pindex].getY()), LocationImpl.create((double)loa[i].getX(), (double)loa[i].getY()), LocationImpl.create((double)(loa[i].getX() + dTapeWidth), (double)(loa[i].getY() - dTapeWidth)), LocationImpl.create((double)(loa[pindex].getX() + dTapeWidth), (double)(loa[pindex].getY() - dTapeWidth))};
                                        pre.setOutline(null);
                                        pre.setPoints(loaPlane);
                                        pre.setBackground((Fill)lia.getColor().brighter());
                                    } else {
                                        loaPlane[0].set(loa[pindex].getX(), loa[pindex].getY());
                                        loaPlane[1].set(loa[i].getX(), loa[i].getY());
                                        loaPlane[2].set(loa[i].getX() + dTapeWidth, loa[i].getY() - dTapeWidth);
                                        loaPlane[3].set(loa[pindex].getX() + dTapeWidth, loa[pindex].getY() - dTapeWidth);
                                    }
                                    dc.addPlane((PrimitiveRenderEvent)pre, 2);
                                    this.addInteractivity(ipr, dpha[i], (PrimitiveRenderEvent)pre);
                                }
                            }
                            if (bRendering3D) {
                                dc.addLine((LineRenderEvent)lre3d);
                            } else {
                                dc.addLine(lre);
                            }
                        }
                    }
                }
                ++i;
            }
            points = this.filterNull(points);
            if (this.isLastRuntimeSeriesInAxis()) {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", null);
            } else {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", points);
            }
        }
    }

    protected void renderShadow(IPrimitiveRenderer ipr, Plot p, LineAttributes lia, Location[] loa, boolean bShowAsTape, DataPointHints[] dpha) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != ColorDefinitionImpl.TRANSPARENT().getTransparency() && lia.isSetVisible() && lia.isVisible()) {
            Location[] loaShadow = null;
            Location positionDelta = ((ChartWithAxes)this.getModel()).isTransposed() ? LocationImpl.create((double)-3.0, (double)0.0) : LocationImpl.create((double)0.0, (double)3.0);
            EventObjectCache eventObjectCache = (EventObjectCache)ipr;
            StructureSource structureSource = StructureSource.createSeries((Series)this.getSeries());
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
            DeferredCache dc = this.getDeferredCache();
            int i = 0;
            while (i < loa.length) {
                if (!this.isNaN(loa[i])) {
                    if (!((LineSeries)this.getSeries()).isConnectMissingValue() && (i == 0 || i > 0 && this.isNaN(loa[i - 1]))) {
                        if (i == loa.length - 1 || this.isNaN(loa[i + 1])) {
                            double iSize = lia.getThickness();
                            EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
                            StructureSource structureSource2 = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]);
                            Class<?> clazz2 = class$6;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            OvalRenderEvent ore = (OvalRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
                            ore.setBounds(BoundsImpl.create((double)loa[i].getX(), (double)(loa[i].getY() + 3.0), (double)iSize, (double)iSize));
                            LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
                            liaShadow.setColor(cLineShadow);
                            ore.setOutline(liaShadow);
                            ore.setBackground((Fill)liaShadow.getColor());
                            ipr.drawOval(ore);
                            ipr.fillOval(ore);
                        }
                    } else {
                        int pindex = this.getPreviousNonNullIndex(i, loa);
                        if (pindex != -1) {
                            if (loaShadow == null) {
                                loaShadow = new Location[]{LocationImpl.create((double)(loa[pindex].getX() + positionDelta.getX()), (double)(loa[pindex].getY() + positionDelta.getY())), LocationImpl.create((double)(loa[i].getX() + positionDelta.getX()), (double)(loa[i].getY() + positionDelta.getY()))};
                            } else {
                                loaShadow[0].set(loa[pindex].getX() + positionDelta.getX(), loa[pindex].getY() + positionDelta.getY());
                                loaShadow[1].set(loa[i].getX() + positionDelta.getX(), loa[i].getY() + positionDelta.getY());
                            }
                            lre.setStart(loaShadow[0]);
                            lre.setEnd(loaShadow[1]);
                            LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
                            liaShadow.setColor(cLineShadow);
                            lre.setLineAttributes(liaShadow);
                            dc.addLine(lre);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected int getPreviousNonNullIndex(int currentIndex, DataPointHints[] dpha) {
        int i = currentIndex - 1;
        while (i >= 0) {
            if (dpha[i].getOrthogonalValue() != null) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected int getPreviousNonNullIndex(int currentIndex, Location[] loa) {
        int i = currentIndex - 1;
        while (i >= 0) {
            if (!Double.isNaN(loa[i].getX()) && !Double.isNaN(loa[i].getY())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected boolean isNaN(Location lo) {
        return lo == null || Double.isNaN(lo.getX()) || Double.isNaN(lo.getY());
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }
}

