/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class ElementReferenceValidator
extends AbstractPropertyValidator {
    public static final String NAME = "ElementReferenceValidator";
    private static final ElementReferenceValidator instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.validators.ElementReferenceValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new ElementReferenceValidator();
    }

    public static ElementReferenceValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element, String propName) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        if (prop.getTypeCode() == 15) {
            if (!this.checkElementReference(module, element, prop)) {
                Object value = element.getLocalProperty(module, propName);
                list.add(new SemanticError(element, new String[]{propName, ((ElementRefValue)value).getName()}, "Error.SemanticError.INVALID_ELEMENT_REF"));
            }
        } else if (prop.getTypeCode() == 20 && prop.getSubTypeCode() == 15) {
            List valueList = element.resolveElementReferenceList(module, prop);
            if (valueList != null) {
                int i = 0;
                while (i < valueList.size()) {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (!item.isResolved()) {
                        list.add(new SemanticError(element, new String[]{propName, item.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF"));
                    }
                    ++i;
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return list;
    }

    private boolean checkElementReference(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && 15 != prop.getTypeCode()) {
            throw new AssertionError();
        }
        ElementRefValue ref = element.resolveElementReference(module, prop);
        if (ref == null) {
            return true;
        }
        return ref.isResolved();
    }
}

