/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IDataBinding;
import org.eclipse.birt.report.model.api.simpleapi.IHideRule;
import org.eclipse.birt.report.model.api.simpleapi.IHighlightRule;
import org.eclipse.birt.report.model.api.simpleapi.IReportItem;
import org.eclipse.birt.report.model.simpleapi.DataBindingImpl;
import org.eclipse.birt.report.model.simpleapi.HideRuleMethodUtil;
import org.eclipse.birt.report.model.simpleapi.HighlightRuleMethodUtil;
import org.eclipse.birt.report.model.simpleapi.ReportElement;

public class ReportItem
extends ReportElement
implements IReportItem {
    public ReportItem(ReportItemHandle handle) {
        super(handle);
    }

    public DataSetHandle getDataSet() {
        return ((ReportItemHandle)this.handle).getDataSet();
    }

    public void setDataSet(DataSetHandle dataSet) throws SemanticException {
        ((ReportItemHandle)this.handle).setDataSet(dataSet);
    }

    public String getX() {
        DimensionHandle x = ((ReportItemHandle)this.handle).getX();
        return x == null ? null : x.getStringValue();
    }

    public String getY() {
        DimensionHandle y = ((ReportItemHandle)this.handle).getY();
        return y == null ? null : y.getStringValue();
    }

    public void setX(String dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setX(dimension);
    }

    public void setX(double dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setX(dimension);
    }

    public void setY(String dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setY(dimension);
    }

    public void setY(double dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setY(dimension);
    }

    public void setHeight(String dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setHeight(dimension);
    }

    public void setHeight(double dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setHeight(dimension);
    }

    public void setWidth(String dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setWidth(dimension);
    }

    public void setWidth(double dimension) throws SemanticException {
        ((ReportItemHandle)this.handle).setWidth(dimension);
    }

    public String getWidth() {
        return ((ReportItemHandle)this.handle).getWidth().getDisplayValue();
    }

    public String getHeight() {
        return ((ReportItemHandle)this.handle).getHeight().getDisplayValue();
    }

    public String getBookmark() {
        return ((ReportItemHandle)this.handle).getBookmark();
    }

    public void setBookmark(String value) throws SemanticException {
        ((ReportItemHandle)this.handle).setBookmark(value);
    }

    public void setTocExpression(String expression) throws SemanticException {
        ((ReportItemHandle)this.handle).setTocExpression(expression);
    }

    public String getTocExpression() {
        return ((ReportItemHandle)this.handle).getTocExpression();
    }

    public String getDataBinding(String bindingName) {
        if (bindingName == null || bindingName.length() == 0) {
            return null;
        }
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!columnHandle.getName().equals(bindingName)) continue;
            return columnHandle.getExpression();
        }
        return null;
    }

    public IDataBinding[] getDataBindings() {
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        ArrayList<DataBindingImpl> rList = new ArrayList<DataBindingImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            DataBindingImpl d = new DataBindingImpl(columnHandle);
            rList.add(d);
            ++count;
        }
        return rList.toArray(new IDataBinding[count]);
    }

    public void removeDataBinding(String bindingName) throws SemanticException {
        if (bindingName == null || bindingName.length() == 0) {
            return;
        }
        PropertyHandle propHandle = ((ReportItemHandle)this.handle).getPropertyHandle("boundDataColumns");
        ArrayList<ComputedColumnHandle> structureList = new ArrayList<ComputedColumnHandle>();
        Iterator iterator = propHandle.iterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!bindingName.equals(columnHandle.getName())) continue;
            structureList.add(columnHandle);
        }
        propHandle.removeItems(structureList);
    }

    public void removeDataBindings() throws SemanticException {
        PropertyHandle propHandle = this.handle.getPropertyHandle("boundDataColumns");
        propHandle.clearValue();
    }

    public void addDataBinding(IDataBinding binding) throws SemanticException {
        if (binding == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle("boundDataColumns");
        propHandle.addItem(binding.getStructure());
    }

    public IHideRule[] getHideRules() {
        return HideRuleMethodUtil.getHideRules(this.handle);
    }

    public void removeHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        HideRuleMethodUtil.removeHideRule(this.handle, rule);
    }

    public void addHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        HideRuleMethodUtil.addHideRule(this.handle, rule);
    }

    public void removeHideRules() throws SemanticException {
        HideRuleMethodUtil.removeHideRules(this.handle);
    }

    public void addHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        HighlightRuleMethodUtil.addHighlightRule(this.handle, rule);
    }

    public IHighlightRule[] getHighlightRules() {
        return HighlightRuleMethodUtil.getHighlightRules(this.handle);
    }

    public void removeHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        HighlightRuleMethodUtil.removeHighlightRule(this.handle, rule);
    }

    public void removeHighlightRules() throws SemanticException {
        HighlightRuleMethodUtil.removeHighlightRules(this.handle);
    }
}

