/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataColumnNameValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class BoundDataColumnUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.BoundDataColumnUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static String getColumnName(List columns, String expression) {
        if (columns == null || columns.size() == 0 || expression == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (expression.equals(column.getExpression())) {
                return column.getName();
            }
            ++i;
        }
        return null;
    }

    public static ComputedColumn getColumn(List columns, String expression, String function, List aggregateOnList) {
        if (columns == null || columns.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if ((expression == null && column.getExpression() == null || expression != null && expression.equals(column.getExpression())) && (function != null && function.equals(column.getAggregateFunction()) || function == null && column.getAggregateFunction() == null)) {
                boolean isEmptyB;
                List tempAggregateOnList = column.getAggregateOnList();
                boolean isEmptyA = aggregateOnList == null || aggregateOnList.isEmpty();
                boolean bl = isEmptyB = tempAggregateOnList == null || tempAggregateOnList.isEmpty();
                if (isEmptyA && isEmptyB) {
                    return column;
                }
                if (!(!isEmptyA && isEmptyB || isEmptyA && !isEmptyB)) {
                    if (!($assertionsDisabled || tempAggregateOnList != null && aggregateOnList != null)) {
                        throw new AssertionError();
                    }
                    if (tempAggregateOnList.size() == aggregateOnList.size()) {
                        boolean isMatch = true;
                        int j = 0;
                        while (j < tempAggregateOnList.size()) {
                            String aggregationA = (String)tempAggregateOnList.get(j);
                            String aggregationB = (String)aggregateOnList.get(j);
                            if (!aggregateOnList.contains(aggregationA) || !tempAggregateOnList.contains(aggregationB)) {
                                isMatch = false;
                                break;
                            }
                            ++j;
                        }
                        if (isMatch) {
                            return column;
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static String createBoundDataColumn(DesignElement target, String columnName, String expression, Module module) {
        ArrayList<ComputedColumn> columns;
        if (target == null) {
            return null;
        }
        String propName = null;
        if (target instanceof ReportItem) {
            propName = "boundDataColumns";
            ElementPropertyDefn prop = (ElementPropertyDefn)target.getDefn().getProperty(propName);
            if (prop == null) {
                return null;
            }
        }
        if (target instanceof ScalarParameter) {
            propName = "boundDataColumns";
        }
        if ((columns = (ArrayList<ComputedColumn>)target.getLocalProperty(module, propName)) == null) {
            columns = new ArrayList<ComputedColumn>();
            target.setProperty(propName, columns);
        }
        String newName = columnName;
        String foundName = BoundDataColumnUtil.getColumnName(columns, expression);
        if (foundName == null && DataColumnNameValidator.getColumn(columns, newName) == null) {
            ComputedColumn column = StructureFactory.createComputedColumn();
            columns.add(column);
            column.setName(newName);
            column.setExpression(expression);
        } else if (foundName != null) {
            newName = foundName;
        }
        return newName;
    }

    public static DesignElement findTargetOfBoundColumns(DesignElement element, Module module) {
        return BoundDataColumnUtil.findTargetOfBoundColumns(element, module, 0);
    }

    public static DesignElement findTargetOfBoundColumns(DesignElement element, Module module, int outerLevel) {
        int tmpOuterLevel = -1;
        DesignElement tmpElement = element;
        DesignElement retElement = null;
        while (tmpElement != null && tmpOuterLevel < outerLevel) {
            ElementRefValue dataSetRef;
            if (!(tmpElement instanceof GroupElement || tmpElement instanceof ReportItem || tmpElement instanceof ScalarParameter)) {
                tmpElement = tmpElement.getContainer();
                continue;
            }
            if (tmpElement instanceof ReportItem) {
                String propName = "boundDataColumns";
                ElementPropertyDefn prop = (ElementPropertyDefn)tmpElement.getDefn().getProperty(propName);
                if (prop == null) {
                    tmpElement = tmpElement.getContainer();
                    continue;
                }
            }
            if (retElement == null) {
                retElement = tmpElement;
            }
            if (tmpElement instanceof ListingElement || tmpElement instanceof GroupElement || tmpElement instanceof ExtendedItem) {
                retElement = tmpElement;
                ++tmpOuterLevel;
                tmpElement = tmpElement.getContainer();
                continue;
            }
            if (tmpElement instanceof ReportItem && (dataSetRef = (ElementRefValue)tmpElement.getProperty(module, "dataSet")) != null) {
                retElement = tmpElement;
                ++tmpOuterLevel;
                tmpElement = tmpElement.getContainer();
                continue;
            }
            tmpElement = tmpElement.getContainer();
        }
        return retElement;
    }

    public static DesignElement findTargetElementOfParamBinding(DesignElement element, Module module) {
        DesignElement outer2;
        DesignElement outer1 = BoundDataColumnUtil.findTargetOfBoundColumns(element, module, 0);
        if (outer1 == (outer2 = BoundDataColumnUtil.findTargetOfBoundColumns(outer1, module, 1))) {
            return null;
        }
        return outer2;
    }

    public static String makeUniqueName(DesignElementHandle element, String name, ComputedColumn struct) {
        ComputedColumn column;
        String trimmedName;
        HashSet columnNames = new HashSet();
        if (element instanceof ListingHandle) {
            BoundDataColumnUtil.addColumnNamesToSet(element, columnNames);
        } else if (element instanceof ReportItemHandle) {
            if (((ReportItemHandle)element).getDataSet() != null || element.getProperty("boundDataColumns") != null) {
                BoundDataColumnUtil.addColumnNamesToSet(element, columnNames);
            } else {
                DesignElementHandle tmpHandle = element;
                while ((tmpHandle = tmpHandle.getContainer()) != null) {
                    if (!(tmpHandle instanceof ListingHandle)) continue;
                    BoundDataColumnUtil.addColumnNamesToSet(tmpHandle, columnNames);
                    break;
                }
            }
        }
        int index = 1;
        String retName = trimmedName = name.trim();
        ArrayList columns = new ArrayList();
        columns.addAll(columnNames);
        while ((column = DataColumnNameValidator.getColumn(columns, retName)) != null && column != struct) {
            retName = String.valueOf(trimmedName) + '_' + index;
            ++index;
        }
        return retName;
    }

    private static void addColumnNamesToSet(DesignElementHandle element, Set columnNames) {
        if (element == null) {
            return;
        }
        String propName = null;
        if (element instanceof ReportItemHandle) {
            propName = "boundDataColumns";
        } else if (element instanceof ScalarParameterHandle) {
            propName = "boundDataColumns";
        } else {
            return;
        }
        List boundColumns = element.getListProperty(propName);
        if (boundColumns == null || boundColumns.isEmpty()) {
            return;
        }
        columnNames.addAll(boundColumns);
    }

    public static Map handleJavaExpression(List jsExprs, ExtendedItem element, Module module, Map cachedGroups) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (jsExprs == null || jsExprs.isEmpty()) {
            return retMap;
        }
        int i = 0;
        while (i < jsExprs.size()) {
            String jsExpr = (String)jsExprs.get(i);
            List newExprs = null;
            try {
                newExprs = ExpressionUtil.extractColumnExpressions((String)jsExpr);
            }
            catch (BirtException birtException) {}
            if (newExprs != null && !newExprs.isEmpty()) {
                DesignElement tmpElement = BoundDataColumnUtil.findTargetOfBoundColumns(element, module);
                int j = 0;
                while (j < newExprs.size()) {
                    String tmpName;
                    IColumnBinding boundColumn = (IColumnBinding)newExprs.get(j);
                    String columnName = boundColumn.getResultSetColumnName();
                    if (tmpElement != null && (tmpName = BoundDataColumnUtil.createBoundDataColumn(tmpElement, columnName, boundColumn.getBoundExpression(), module)) != null) {
                        columnName = tmpName;
                    }
                    retMap.put(jsExpr, ExpressionUtil.createRowExpression((String)columnName));
                    ++j;
                }
            }
            ++i;
        }
        return retMap;
    }

    public static Map handleJavaExpression(List jsExprs, TextItem element, Module module, Map cachedGroups) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Iterator exprsIter = jsExprs.iterator();
        while (exprsIter.hasNext()) {
            String columnName;
            IColumnBinding boundColumn;
            int j;
            String jsExpr = (String)exprsIter.next();
            List newExprs = null;
            try {
                newExprs = ExpressionUtil.extractColumnExpressions((String)jsExpr);
            }
            catch (BirtException birtException) {}
            if (newExprs == null || newExprs.isEmpty()) continue;
            DesignElement tmpElement = BoundDataColumnUtil.findTargetOfBoundColumns(element, module);
            if (tmpElement instanceof GroupElement && cachedGroups == null) {
                tmpElement = tmpElement.getContainer();
            }
            if (tmpElement instanceof GroupElement) {
                if (!$assertionsDisabled && cachedGroups == null) {
                    throw new AssertionError();
                }
                BoundDataColumnUtil.appendBoundColumnsToGroup((GroupElement)tmpElement, newExprs, cachedGroups);
                j = 0;
                while (j < newExprs.size()) {
                    boundColumn = (IColumnBinding)newExprs.get(j);
                    columnName = boundColumn.getResultSetColumnName();
                    retMap.put(jsExpr, ExpressionUtil.createRowExpression((String)columnName));
                    ++j;
                }
                return retMap;
            }
            j = 0;
            while (j < newExprs.size()) {
                boundColumn = (IColumnBinding)newExprs.get(j);
                columnName = boundColumn.getResultSetColumnName();
                String tmpName = BoundDataColumnUtil.createBoundDataColumn(tmpElement, columnName, boundColumn.getBoundExpression(), module);
                if (tmpName != null) {
                    columnName = tmpName;
                }
                retMap.put(jsExpr, ExpressionUtil.createRowExpression((String)columnName));
                ++j;
            }
        }
        return retMap;
    }

    public static List getExpressions(String contentText, TextItem element, Module module) {
        TextTemplate template;
        if (contentText == null) {
            return null;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        String contentType = (String)element.getProperty(module, "contentType");
        if (("auto".equalsIgnoreCase(contentType) || "html".equalsIgnoreCase(contentType)) && (template = new TemplateParser().parse(contentText)) != null && template.getNodes() != null) {
            Iterator itor = template.getNodes().iterator();
            String expression = null;
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (obj instanceof TextTemplate.ValueNode) {
                    expression = ((TextTemplate.ValueNode)obj).getValue();
                } else if (obj instanceof TextTemplate.ImageNode) {
                    expression = ((TextTemplate.ImageNode)obj).getExpr();
                }
                if (StringUtil.isBlank(expression) || exprs.contains(expression)) continue;
                exprs.add(expression);
                expression = null;
            }
        }
        return exprs;
    }

    public static void appendBoundColumnsToGroup(GroupElement target, List newExprs, Map tempValues) {
        ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
        int i = 0;
        while (i < newExprs.size()) {
            ComputedColumn column = StructureFactory.createComputedColumn();
            IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
            String newExpression = boundColumn.getBoundExpression();
            if (newExpression != null) {
                column.setName(boundColumn.getResultSetColumnName());
                column.setExpression(boundColumn.getBoundExpression());
                if (!newColumns.contains(column)) {
                    newColumns.add(column);
                }
            }
            ++i;
        }
        BoundDataColumnUtil.appendBoundColumnsToCachedGroup(target, newColumns, tempValues);
    }

    private static void appendBoundColumnsToCachedGroup(GroupElement target, List newColumns, Map tempValues) {
        List boundColumns = (List)tempValues.get(target);
        if (boundColumns == null) {
            tempValues.put(target, newColumns);
            return;
        }
        int i = 0;
        while (i < newColumns.size()) {
            ComputedColumn column = (ComputedColumn)newColumns.get(i);
            boundColumns.add(column);
            ++i;
        }
    }

    public static String appendBoundColumnsToCachedGroup(GroupElement target, String boundName, String expression, Map tempValues) {
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName(boundName);
        column.setExpression(expression);
        List boundColumns = (List)tempValues.get(target);
        if (boundColumns == null) {
            ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
            newColumns.add(column);
            tempValues.put(target, newColumns);
            return boundName;
        }
        boundColumns.add(column);
        return boundName;
    }

    public static class ContentVisitor
    implements TextTemplate.Visitor {
        private static final String VALUE_OF_START_TAG = "<value-of>";
        private static final String VALUE_OF_END_TAG = "</value-of>";
        private static final String IMAGE_START_TAG = "<image>";
        private static final String IMAGE_END_TAG = "</image>";
        private StringBuffer buffer;
        private Map updatedValues;
        private TextTemplate template;

        public ContentVisitor(TextTemplate template, Map updatedValues) {
            this.updatedValues = updatedValues;
            this.template = template;
        }

        public Object visitText(TextTemplate.TextNode node, Object value) {
            if (value != null) {
                this.buffer.append(value);
            }
            return value;
        }

        public Object visitValue(TextTemplate.ValueNode node, Object value) {
            String updatedValue = (String)this.updatedValues.get(value);
            if (updatedValue != null) {
                this.buffer.append(VALUE_OF_START_TAG + updatedValue + VALUE_OF_END_TAG);
                return updatedValue;
            }
            return value;
        }

        public Object visitImage(TextTemplate.ImageNode node, Object value) {
            String updatedValue = (String)this.updatedValues.get(value);
            if (updatedValue != null) {
                this.buffer.append(IMAGE_START_TAG + updatedValue + IMAGE_END_TAG);
                return updatedValue;
            }
            return value;
        }

        public String execute() {
            if (this.template == null) {
                return "";
            }
            this.buffer = new StringBuffer();
            ArrayList nodes = this.template.getNodes();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                TextTemplate.Node node = (TextTemplate.Node)iter.next();
                String text = null;
                if (node instanceof TextTemplate.ValueNode) {
                    text = ((TextTemplate.ValueNode)node).getValue();
                } else if (node instanceof TextTemplate.ImageNode) {
                    text = ((TextTemplate.ImageNode)node).getExpr();
                } else if (node instanceof TextTemplate.TextNode) {
                    text = ((TextTemplate.TextNode)node).getContent();
                }
                node.accept((TextTemplate.Visitor)this, (Object)text);
            }
            return this.buffer.toString();
        }
    }
}

