/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class ResultObjectUtil {
    private int columnCount;
    private Class[] typeArray;
    private IResultClass rsMetaData;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public static ResultObjectUtil newInstance(IResultClass rsMetaData) {
        ResultObjectUtil instance = new ResultObjectUtil();
        int length = rsMetaData.getFieldCount();
        instance.typeArray = new Class[length];
        int i = 0;
        while (i < length) {
            try {
                instance.typeArray[i] = rsMetaData.getFieldValueClass(i + 1);
            }
            catch (DataException dataException) {}
            ++i;
        }
        instance.columnCount = rsMetaData.getFieldCount();
        instance.rsMetaData = rsMetaData;
        return instance;
    }

    private ResultObjectUtil() {
    }

    public ResultObject newResultObject(Object[] rowData) {
        return new ResultObject(this.rsMetaData, rowData);
    }

    public IResultObject[] readData(InputStream bis, int length) throws IOException {
        IResultObject[] rowDatas = new ResultObject[length];
        int i = 0;
        while (i < length) {
            int rowLen = IOUtil.readInt((InputStream)bis);
            byte[] rowDataBytes = new byte[rowLen];
            bis.read(rowDataBytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(rowDataBytes);
            DataInputStream dis = new DataInputStream(bais);
            Object[] obs = new Object[this.columnCount];
            int j = 0;
            while (j < this.columnCount) {
                Class fieldType = this.typeArray[j];
                if (dis.readByte() == 0) {
                    obs[j] = null;
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (fieldType.equals(clazz)) {
                        obs[j] = new Integer(dis.readInt());
                    } else {
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.lang.Double");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (fieldType.equals(clazz2)) {
                            obs[j] = new Double(dis.readDouble());
                        } else {
                            Class<?> clazz3 = class$2;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("java.math.BigDecimal");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (fieldType.equals(clazz3)) {
                                obs[j] = new BigDecimal(dis.readUTF());
                            } else {
                                Class<?> clazz4 = class$3;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = Class.forName("java.sql.Time");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (fieldType.equals(clazz4)) {
                                    obs[j] = new Time(dis.readLong());
                                } else {
                                    Class<?> clazz5 = class$4;
                                    if (clazz5 == null) {
                                        try {
                                            clazz5 = Class.forName("java.sql.Timestamp");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (fieldType.equals(clazz5)) {
                                        obs[j] = new Timestamp(dis.readLong());
                                    } else {
                                        Class<?> clazz6 = class$5;
                                        if (clazz6 == null) {
                                            try {
                                                clazz6 = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (fieldType.equals(clazz6)) {
                                            obs[j] = new Date(dis.readLong());
                                        } else {
                                            Class<?> clazz7 = class$6;
                                            if (clazz7 == null) {
                                                try {
                                                    clazz7 = Class.forName("java.util.Date");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (fieldType.isAssignableFrom(clazz7)) {
                                                obs[j] = new java.util.Date(dis.readLong());
                                            } else {
                                                Class<?> clazz8 = class$7;
                                                if (clazz8 == null) {
                                                    try {
                                                        clazz8 = Class.forName("java.lang.Boolean");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (fieldType.equals(clazz8)) {
                                                    obs[j] = new Boolean(dis.readBoolean());
                                                } else {
                                                    Class<?> clazz9 = class$8;
                                                    if (clazz9 == null) {
                                                        try {
                                                            clazz9 = Class.forName("java.lang.String");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (fieldType.equals(clazz9)) {
                                                        obs[j] = IOUtil.readString((DataInputStream)dis);
                                                    } else {
                                                        Class<?> clazz10 = class$9;
                                                        if (clazz10 == null) {
                                                            try {
                                                                clazz10 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                        }
                                                        if (fieldType.equals(clazz10)) {
                                                            obs[j] = IOUtil.readString((DataInputStream)dis);
                                                        } else {
                                                            Class<?> clazz11 = class$10;
                                                            if (clazz11 == null) {
                                                                try {
                                                                    clazz11 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                            }
                                                            if (fieldType.equals(clazz11)) {
                                                                int len = IOUtil.readInt((InputStream)dis);
                                                                if (len == 0) {
                                                                    obs[j] = null;
                                                                } else {
                                                                    byte[] bytes = new byte[len];
                                                                    dis.read(bytes);
                                                                    obs[j] = bytes;
                                                                }
                                                            } else if (fieldType.equals(DataType.getClass((int)0))) {
                                                                ObjectInputStream ois = new ObjectInputStream(dis);
                                                                try {
                                                                    obs[j] = ois.readObject();
                                                                }
                                                                catch (Exception exception) {}
                                                                ois.close();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            rowDatas[i] = this.newResultObject(obs);
            rowDataBytes = null;
            dis = null;
            bais = null;
            ++i;
        }
        return rowDatas;
    }

    public void writeData(OutputStream bos, IResultObject[] resultObjects, int length) throws IOException {
        int i = 0;
        while (i < length) {
            this.writeData(bos, resultObjects[i]);
            ++i;
        }
    }

    public void writeData(OutputStream bos, IResultObject resultObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int j = 0;
        while (j < this.columnCount) {
            Object fieldValue = null;
            try {
                fieldValue = resultObject.getFieldValue(j + 1);
            }
            catch (DataException dataException) {}
            if (fieldValue == null) {
                dos.writeByte(0);
            } else {
                dos.writeByte(1);
                Class fieldType = this.typeArray[j];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (fieldType.equals(clazz)) {
                    dos.writeInt((Integer)fieldValue);
                } else {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (fieldType.equals(clazz2)) {
                        dos.writeDouble((Double)fieldValue);
                    } else {
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (fieldType.equals(clazz3)) {
                            dos.writeUTF(((BigDecimal)fieldValue).toString());
                        } else {
                            Class<?> clazz4 = class$6;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = Class.forName("java.util.Date");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz4.isAssignableFrom(fieldType)) {
                                dos.writeLong(((java.util.Date)fieldValue).getTime());
                            } else {
                                Class<?> clazz5 = class$7;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (fieldType.equals(clazz5)) {
                                    dos.writeBoolean((Boolean)fieldValue);
                                } else {
                                    Class<?> clazz6 = class$8;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = Class.forName("java.lang.String");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (fieldType.equals(clazz6)) {
                                        IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
                                    } else {
                                        Class<?> clazz7 = class$9;
                                        if (clazz7 == null) {
                                            try {
                                                clazz7 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (fieldType.equals(clazz7)) {
                                            IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
                                        } else {
                                            Class<?> clazz8 = class$10;
                                            if (clazz8 == null) {
                                                try {
                                                    clazz8 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (fieldType.equals(clazz8)) {
                                                byte[] bytes = (byte[])fieldValue;
                                                if (bytes == null || bytes.length == 0) {
                                                    IOUtil.writeInt((OutputStream)dos, (int)0);
                                                } else {
                                                    IOUtil.writeInt((OutputStream)dos, (int)bytes.length);
                                                    dos.write((byte[])fieldValue);
                                                }
                                            } else if (fieldType.equals(DataType.getClass((int)0))) {
                                                if (!(fieldValue instanceof Serializable)) {
                                                    fieldValue = fieldValue.toString();
                                                }
                                                ObjectOutputStream oo = new ObjectOutputStream(dos);
                                                oo.writeObject(fieldValue);
                                                oo.close();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++j;
        }
        dos.flush();
        byte[] rowsDataBytes = baos.toByteArray();
        IOUtil.writeInt((OutputStream)bos, (int)rowsDataBytes.length);
        bos.write(rowsDataBytes);
        rowsDataBytes = null;
        dos = null;
        baos = null;
    }
}

