/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;
import org.eclipse.birt.data.engine.impl.ScriptDataSourceRuntime;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.script.DataSourceJSEventHandler;
import org.eclipse.birt.data.engine.script.JSDataSourceImpl;
import org.eclipse.birt.data.engine.script.ScriptDataSourceJSEventHandler;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class DataSourceRuntime
implements IDataSourceInstanceHandle {
    private IBaseDataSourceDesign design;
    private IBaseDataSourceEventHandler eventHandler;
    private Scriptable sharedScope;
    private Scriptable jsDataSourceObject;
    private IDataSource odiDataSource;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataSourceRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataSourceRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public static DataSourceRuntime newInstance(IBaseDataSourceDesign dataSource, DataEngineImpl dataEngine) throws DataException {
        if (dataSource instanceof IOdaDataSourceDesign) {
            return new OdaDataSourceRuntime((IOdaDataSourceDesign)dataSource, dataEngine.getSession().getSharedScope());
        }
        if (dataSource instanceof IScriptDataSourceDesign) {
            return new ScriptDataSourceRuntime((IScriptDataSourceDesign)dataSource, dataEngine.getSession().getSharedScope());
        }
        throw new DataException("data.engine.UnsupportedDataSourceType", dataSource.getName());
    }

    protected DataSourceRuntime(IBaseDataSourceDesign dataSourceDesign, Scriptable sharedScope) {
        Class<?> clazz;
        Object[] params = new Object[]{dataSourceDesign, sharedScope};
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataSourceRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz2.getName(), "DataSourceRuntime", params);
        if (!$assertionsDisabled && dataSourceDesign == null) {
            throw new AssertionError();
        }
        this.design = dataSourceDesign;
        this.sharedScope = sharedScope;
        this.eventHandler = dataSourceDesign.getEventHandler();
        if (this.eventHandler == null) {
            this.eventHandler = dataSourceDesign instanceof IScriptDataSourceDesign ? new ScriptDataSourceJSEventHandler((IScriptDataSourceDesign)dataSourceDesign) : new DataSourceJSEventHandler(dataSourceDesign);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataSourceRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "DataSourceRuntime");
    }

    public IBaseDataSourceDesign getDesign() {
        return this.design;
    }

    public String getName() {
        return this.design.getName();
    }

    protected IBaseDataSourceEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public Scriptable getScriptScope() {
        return this.getJSDataSourceObject();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Scriptable getJSDataSourceObject() {
        if (this.jsDataSourceObject != null) return this.jsDataSourceObject;
        Scriptable topScope = this.sharedScope;
        Context.enter();
        try {
            this.jsDataSourceObject = (Scriptable)Context.javaToJS((Object)new JSDataSourceImpl(this), (Scriptable)topScope);
            this.jsDataSourceObject.setParentScope(topScope);
            this.jsDataSourceObject.setPrototype(topScope);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Context.exit();
        return this.jsDataSourceObject;
    }

    public boolean isOpen() {
        return this.odiDataSource != null;
    }

    public IDataSource getOdiDataSource() {
        return this.odiDataSource;
    }

    public void openOdiDataSource(IDataSource odiDataSource) throws DataException {
        odiDataSource.open();
        this.odiDataSource = odiDataSource;
    }

    public boolean canClose() {
        if (this.odiDataSource != null) {
            return this.odiDataSource.canClose();
        }
        return true;
    }

    public void closeOdiDataSource() throws DataException {
        if (this.odiDataSource != null) {
            this.odiDataSource.close();
            this.odiDataSource = null;
        }
    }

    public void beforeOpen() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleBeforeOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterOpen() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleAfterOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void beforeClose() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleBeforeClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterClose() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleAfterClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

