/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;

class QueryDefinitionCopyUtil {
    QueryDefinitionCopyUtil() {
    }

    static IBaseQueryDefinition copy(IBaseQueryDefinition baseQyeryDef) throws DataException {
        if (baseQyeryDef instanceof SubqueryDefinition) {
            SubqueryDefinition srcSubQueryDefn = (SubqueryDefinition)baseQyeryDef;
            SubqueryDefinition destSubQueryDefn = new SubqueryDefinition(srcSubQueryDefn.getName(), baseQyeryDef.getParentQuery());
            destSubQueryDefn.setApplyOnGroupFlag(srcSubQueryDefn.applyOnGroup());
            destSubQueryDefn.setMaxRows(srcSubQueryDefn.getMaxRows());
            destSubQueryDefn.setUsesDetails(srcSubQueryDefn.usesDetails());
            QueryDefinitionCopyUtil.copyGroupList(srcSubQueryDefn, destSubQueryDefn);
            QueryDefinitionCopyUtil.copyExpressions(srcSubQueryDefn, destSubQueryDefn);
            QueryDefinitionCopyUtil.copySubQueryList(srcSubQueryDefn, destSubQueryDefn);
            QueryDefinitionCopyUtil.copySortList(srcSubQueryDefn, destSubQueryDefn);
            QueryDefinitionCopyUtil.copyFilterList(srcSubQueryDefn, destSubQueryDefn);
            return destSubQueryDefn;
        }
        return baseQyeryDef;
    }

    private static void copyExpressions(SubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) throws DataException {
        Map bindings = srcSubQueryDefn.getBindings();
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            destSubQueryDefn.addBinding(QueryDefinitionCopyUtil.convertToBindings(bindings.get(o)));
        }
    }

    private static IBinding convertToBindings(Object binding) {
        if (binding instanceof IBinding) {
            return (IBinding)binding;
        }
        return null;
    }

    private static void copyGroupList(SubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List groupList = srcSubQueryDefn.getGroups();
        int i = 0;
        while (i < groupList.size()) {
            destSubQueryDefn.addGroup((GroupDefinition)groupList.get(i));
            ++i;
        }
    }

    private static void copySubQueryList(SubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        Object[] subQueryDefn = srcSubQueryDefn.getSubqueries().toArray();
        int i = 0;
        while (i < subQueryDefn.length) {
            destSubQueryDefn.addSubquery((SubqueryDefinition)subQueryDefn[i]);
            ++i;
        }
    }

    private static void copySortList(SubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List sortList = srcSubQueryDefn.getSorts();
        int i = 0;
        while (i < sortList.size()) {
            destSubQueryDefn.addSort((SortDefinition)sortList.get(i));
            ++i;
        }
    }

    private static void copyFilterList(SubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List filterList = srcSubQueryDefn.getFilters();
        int i = 0;
        while (i < filterList.size()) {
            destSubQueryDefn.addFilter((IFilterDefinition)filterList.get(i));
            ++i;
        }
    }
}

