/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;

public final class QueryExecutorUtil {
    private QueryExecutorUtil() {
    }

    static IQuery.GroupSpec groupDefnToSpec(Context cx, IGroupDefinition src, String expr, String columnName, int index) throws DataException {
        ColumnInfo groupKeyInfo = new ColumnInfo(index, columnName);
        int groupIndex = groupKeyInfo.getColumnIndex();
        String groupKey = groupKeyInfo.getColumnName();
        boolean isComplexExpression = true;
        IQuery.GroupSpec dest = new IQuery.GroupSpec(groupIndex, groupKey);
        dest.setName(src.getName());
        dest.setInterval(src.getInterval());
        dest.setIntervalRange(src.getIntervalRange());
        dest.setIntervalStart(src.getIntervalStart());
        dest.setSortDirection(src.getSortDirection() != 1 ? 0 : 1);
        dest.setFilters(src.getFilters());
        if (src.getSorts().size() != 0) {
            dest.setSorts(src.getSorts());
        }
        dest.setIsComplexExpression(isComplexExpression);
        return dest;
    }

    static IQuery.GroupSpec subQueryGroupDefnToSpec(Context cx, IGroupDefinition src, String columnName, int index) throws DataException {
        ColumnInfo groupKeyInfo;
        int groupIndex = -1;
        String groupKey = src.getKeyColumn();
        boolean isComplexExpression = false;
        if (groupKey == null || groupKey.length() == 0) {
            groupKeyInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, src.getKeyExpression());
            groupIndex = groupKeyInfo.getColumnIndex();
            groupKey = groupKeyInfo.getColumnName();
        }
        if (groupKey == null && groupIndex < 0) {
            groupKeyInfo = new ColumnInfo(index, columnName);
            groupIndex = groupKeyInfo.getColumnIndex();
            groupKey = groupKeyInfo.getColumnName();
            isComplexExpression = true;
        }
        IQuery.GroupSpec dest = new IQuery.GroupSpec(groupIndex, groupKey);
        dest.setName(src.getName());
        dest.setInterval(src.getInterval());
        dest.setIntervalRange(src.getIntervalRange());
        dest.setIntervalStart(src.getIntervalStart());
        dest.setSortDirection(src.getSortDirection());
        dest.setFilters(src.getFilters());
        dest.setSorts(src.getSorts());
        dest.setIsComplexExpression(isComplexExpression);
        return dest;
    }

    static int getTempComputedColumnType(int i) {
        int interval = i;
        interval = interval == 5 || interval == 6 || interval == 7 || interval == 8 || interval == 2 || interval == 3 || interval == 1 || interval == 4 || interval == 99 ? 3 : (interval == 100 ? 5 : 0);
        return interval;
    }

    public static ColumnInfo getColInfoFromJSExpr(Context cx, String expr) {
        int colIndex = -1;
        String colName = null;
        CompiledExpression ce = ExpressionCompilerUtil.compile(expr, cx);
        if (ce instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression cre = (ColumnReferenceExpression)ce;
            colIndex = cre.getColumnindex();
            colName = cre.getColumnName();
        }
        return new ColumnInfo(colIndex, colName);
    }
}

