/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.RDLoadUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;

public class ExprResultSet
implements IExprResultSet {
    protected RAInputStream rowExprsRAIs;
    protected RAInputStream rowLenRAIs;
    protected RAInputStream rowInfoRAIs;
    protected int rowCount;
    protected int version;
    private boolean isBasedOnSecondRD;
    protected RDGroupUtil rdGroupUtil;
    protected IExprDataReader exprResultReader;
    protected StreamManager streamManager;
    protected DataSetResultSet dataSetResultSet;
    static /* synthetic */ Class class$0;

    public ExprResultSet(StreamManager streamManager, int version, boolean isBasedOnSecondRD, DataSetResultSet dataSetResultSet) throws DataException {
        this.streamManager = streamManager;
        this.version = version;
        this.isBasedOnSecondRD = isBasedOnSecondRD;
        this.dataSetResultSet = dataSetResultSet;
        this.prepare();
        this.rdGroupUtil.setCacheProvider(new CacheProviderImpl(this));
    }

    protected void prepare() throws DataException {
        this.rdGroupUtil = RDLoadUtil.loadGroupUtil(this.streamManager, 0, 2);
        if (!this.isBasedOnSecondRD) {
            this.rowExprsRAIs = this.streamManager.getInStream(31, 0, 2);
            if (this.version > 0) {
                this.rowLenRAIs = this.streamManager.getInStream(33, 0, 2);
            }
            this.exprResultReader = new ExprDataReader1(this.rowExprsRAIs, this.rowLenRAIs, this.version, this.dataSetResultSet);
            this.rowCount = this.exprResultReader.getCount();
        } else {
            this.rowExprsRAIs = this.streamManager.getInStream(31, 0, 0);
            this.rowLenRAIs = this.streamManager.getInStream(33, 0, 0);
            this.rowInfoRAIs = this.streamManager.getInStream(51, 0, 2);
            this.exprResultReader = new ExprDataReader2(this.rowExprsRAIs, this.rowLenRAIs, this.rowInfoRAIs, this.version, this.dataSetResultSet);
            this.rowCount = this.exprResultReader.getCount();
        }
    }

    public boolean next() throws DataException {
        boolean hasNext = this.exprResultReader.next();
        this.rdGroupUtil.next(hasNext);
        return hasNext;
    }

    public Object getValue(String name) throws DataException {
        Map exprValueMap = this.exprResultReader.getRowValue();
        if (exprValueMap == null) {
            throw new DataException("data.engine.ResultSetNotStart");
        }
        if (!exprValueMap.containsKey(name)) {
            throw new DataException("data.engine.InValidExpr");
        }
        return exprValueMap.get(name);
    }

    public void moveTo(int rowIndex) throws DataException {
        int currIndex = this.getCurrentIndex();
        this.exprResultReader.moveTo(rowIndex);
        this.rdGroupUtil.move(rowIndex - currIndex);
    }

    public int getCurrentId() {
        return this.exprResultReader.getRowId();
    }

    public int getCurrentIndex() {
        return this.exprResultReader.getRowIndex();
    }

    public int getStartingGroupLevel() throws DataException {
        return this.rdGroupUtil.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.rdGroupUtil.getEndingGroupLevel();
    }

    public void skipToEnd(int groupLevel) throws DataException {
        this.rdGroupUtil.last(groupLevel);
    }

    public void close() throws DataException {
        try {
            if (this.exprResultReader != null) {
                this.exprResultReader.close();
                this.exprResultReader = null;
            }
            if (this.rowExprsRAIs != null) {
                this.rowExprsRAIs.close();
                this.rowExprsRAIs = null;
            }
            if (this.rowLenRAIs != null) {
                this.rowLenRAIs.close();
                this.rowLenRAIs = null;
            }
            if (this.rowInfoRAIs != null) {
                this.rowInfoRAIs.close();
                this.rowInfoRAIs = null;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isEmpty() {
        return this.rowCount == 0;
    }

    private class CacheProviderImpl
    implements CacheProvider {
        private ExprResultSet exprResultSet;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.document.util.ExprResultSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public CacheProviderImpl(ExprResultSet exprResultSet2) {
            this.exprResultSet = exprResultSet2;
        }

        public int getCount() {
            return this.exprResultSet.rowCount;
        }

        public int getCurrentIndex() {
            return this.exprResultSet.getCurrentIndex();
        }

        public void moveTo(int destIndex) throws DataException {
            int currIndex = this.exprResultSet.getCurrentIndex();
            if (!$assertionsDisabled && destIndex < currIndex) {
                throw new AssertionError();
            }
            int forwardSteps = destIndex - currIndex;
            int i = 0;
            while (i < forwardSteps) {
                this.exprResultSet.next();
                ++i;
            }
        }
    }
}

