/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.group.DayGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.HourGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.ICalculator;
import org.eclipse.birt.data.engine.impl.group.MinuteGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.MonthGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.NumericGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.QuarterGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.SecondGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.StringGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.WeekGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.YearGroupCalculator;

public class GroupCalculatorFactory {
    public static ICalculator getGroupCalculator(int interval, int dataType, Object intervalStart, double intervalRange) throws DataException {
        if (!GroupCalculatorFactory.isValidInterval(interval, dataType)) {
            return null;
        }
        try {
            switch (interval) {
                case 1: {
                    return new YearGroupCalculator(intervalStart, intervalRange);
                }
                case 2: {
                    return new MonthGroupCalculator(intervalStart, intervalRange);
                }
                case 3: {
                    return new QuarterGroupCalculator(intervalStart, intervalRange);
                }
                case 4: {
                    return new WeekGroupCalculator(intervalStart, intervalRange);
                }
                case 5: {
                    return new DayGroupCalculator(intervalStart, intervalRange);
                }
                case 6: {
                    return new HourGroupCalculator(intervalStart, intervalRange);
                }
                case 7: {
                    return new MinuteGroupCalculator(intervalStart, intervalRange);
                }
                case 8: {
                    return new SecondGroupCalculator(intervalStart, intervalRange);
                }
                case 99: {
                    return new NumericGroupCalculator(intervalStart, intervalRange);
                }
                case 100: {
                    return new StringGroupCalculator(intervalStart, intervalRange);
                }
            }
            throw new DataException("data.engine.group.interval.invalid");
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private static boolean isValidInterval(int interval, int dataType) throws DataException {
        if (dataType == 0 || dataType == -1) {
            return true;
        }
        switch (interval) {
            case 0: {
                return true;
            }
            case 99: {
                if (GroupCalculatorFactory.isNumber(dataType)) {
                    return true;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"numeric", DataType.getName((int)dataType)});
            }
            case 100: {
                if (GroupCalculatorFactory.isString(dataType)) {
                    return true;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"string prefix", DataType.getName((int)dataType)});
            }
        }
        if (GroupCalculatorFactory.isDate(dataType)) {
            return true;
        }
        throw new DataException("data.engine.group.interval", new Object[]{"date", DataType.getName((int)dataType)});
    }

    private static boolean isNumber(int dataType) {
        return dataType == 4 || dataType == 3 || dataType == 2;
    }

    private static boolean isDate(int dataType) {
        return dataType == 6 || dataType == 9 || dataType == 10;
    }

    private static boolean isString(int dataType) {
        return dataType == 5;
    }
}

