/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.filter.IJSDimensionFilterHelper;

class AggrFilter {
    private DimLevel[] aggrLevels;
    private IJSDimensionFilterHelper aggrFilterHelper;
    private DimLevel targetLevel;
    private DimLevel[] axisQualifierLevels;
    private Object[] axisQualifierValues;

    AggrFilter(IJSDimensionFilterHelper filterEvalHelper) {
        this.aggrFilterHelper = filterEvalHelper;
        ICubeFilterDefinition cubeFilter = filterEvalHelper.getCubeFilterDefinition();
        this.targetLevel = new DimLevel(cubeFilter.getTargetLevel());
        this.aggrLevels = filterEvalHelper.getAggrLevels();
        ILevelDefinition[] axisLevels = cubeFilter.getAxisQualifierLevels();
        if (axisLevels != null) {
            this.axisQualifierLevels = new DimLevel[axisLevels.length];
            int i = 0;
            while (i < axisLevels.length) {
                this.axisQualifierLevels[i] = new DimLevel(axisLevels[i]);
                ++i;
            }
        }
        this.axisQualifierValues = cubeFilter.getAxisQualifierValues();
    }

    DimLevel[] getAxisQualifierLevels() {
        return this.axisQualifierLevels;
    }

    Object[] getAxisQualifierValues() {
        return this.axisQualifierValues;
    }

    DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    IJSDimensionFilterHelper getFilterHelper() {
        return this.aggrFilterHelper;
    }

    DimLevel getTargetLevel() {
        return this.targetLevel;
    }
}

