/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.data.api.AggrFilter;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.ICubeQueryExcutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.IntRange;
import org.eclipse.birt.data.engine.olap.data.api.MultiKey;
import org.eclipse.birt.data.engine.olap.data.api.RowForFilter;
import org.eclipse.birt.data.engine.olap.data.api.ValueObject;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.ObjectArrayUtil;
import org.eclipse.birt.data.engine.olap.data.util.OrderedDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.IJSDimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;

public class CubeQueryExecutorHelper
implements ICubeQueryExcutorHelper {
    private Cube cube;
    private List filters = null;
    private List aggrFilters = null;
    private Map dimJSFilterMap = null;
    private Map dimRowForFilterMap = null;
    private List rowSort = null;
    private List columnSort = null;
    private List topbottomFilters;
    private boolean isEmptyXTab = false;
    private boolean isBreakHierarchy = true;
    private IComputedMeasureHelper computedMeasureHelper = null;
    private Map dimLevelsMap = null;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public CubeQueryExecutorHelper(ICube cube) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "CubeQueryExecutorHelper", cube);
        this.cube = (Cube)cube;
        this.filters = new ArrayList();
        this.aggrFilters = new ArrayList();
        this.dimJSFilterMap = new HashMap();
        this.dimRowForFilterMap = new HashMap();
        this.rowSort = new ArrayList();
        this.columnSort = new ArrayList();
        this.topbottomFilters = new ArrayList();
        this.dimLevelsMap = new HashMap();
        IDimension[] dimension = this.cube.getDimesions();
        int i = 0;
        while (i < dimension.length) {
            ILevel[] levels = dimension[i].getHierarchy().getLevels();
            this.dimLevelsMap.put(dimension[i].getName(), levels);
            ++i;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "CubeQueryExecutorHelper");
    }

    public IDiskArray getLevelMembers(DimLevel level) {
        return null;
    }

    public static String getAttrReference(String dimName, String levelName, String attrName) {
        return String.valueOf(dimName) + '/' + levelName + '/' + attrName;
    }

    public static ICube loadCube(String cubeName, IDocumentManager documentManager, StopSign stopSign) throws IOException, DataException {
        Cube cube = new Cube(cubeName, documentManager);
        cube.load(stopSign);
        return cube;
    }

    public static void saveAggregationResultSet(IDocArchiveWriter writer, String name, IAggregationResultSet[] resultSets) throws IOException {
        AggregationResultSetSaveUtil.save(name, resultSets, writer);
    }

    public static void saveAggregationResultSet(String pathName, String name, IAggregationResultSet[] resultSets) throws IOException {
        FileArchiveWriter writer = new FileArchiveWriter(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        AggregationResultSetSaveUtil.save(name, resultSets, (IDocArchiveWriter)writer);
        writer.flush();
        writer.finish();
    }

    public static IAggregationResultSet[] loadAggregationResultSet(IDocArchiveReader reader, String name) throws IOException {
        return AggregationResultSetSaveUtil.load(name, reader, VersionManager.getLatestVersion());
    }

    public static IAggregationResultSet[] loadAggregationResultSet(String pathName, String name) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        IAggregationResultSet[] result = AggregationResultSetSaveUtil.load(name, (IDocArchiveReader)reader, VersionManager.getLatestVersion());
        reader.close();
        return result;
    }

    private static String getTmpFileName(String pathName, String name) {
        return String.valueOf(pathName) + File.separator + "cubequeryresult" + name;
    }

    public void setComputedMeasure(IComputedMeasureHelper computedMeasureHelper) {
        this.computedMeasureHelper = computedMeasureHelper;
    }

    public void addRowSort(AggrSortDefinition sort) {
        this.rowSort.add(sort);
    }

    public List getRowSort() {
        return this.rowSort;
    }

    public List getColumnSort() {
        return this.columnSort;
    }

    public void addColumnSort(AggrSortDefinition sort) {
        this.columnSort.add(sort);
    }

    public void addFilter(LevelFilter levelFilter) {
        this.filters.add(levelFilter);
    }

    private void addLevelFilters(List levelFilterList) {
        this.filters.addAll(levelFilterList);
    }

    public void clear() {
        this.filters.clear();
        this.aggrFilters.clear();
        this.topbottomFilters.clear();
        this.dimJSFilterMap.clear();
        this.dimRowForFilterMap.clear();
        this.dimLevelsMap.clear();
    }

    public void close() {
        this.filters = null;
        this.aggrFilters = null;
        this.topbottomFilters = null;
        this.dimJSFilterMap = null;
        this.dimRowForFilterMap = null;
        this.dimLevelsMap = null;
    }

    public IAggregationResultSet[] execute(AggregationDefinition[] aggregations, StopSign stopSign) throws IOException, BirtException {
        IAggregationResultSet[] resultSet = this.onePassExecute(aggregations, stopSign);
        this.applyAggrFilters(aggregations, resultSet, stopSign);
        this.applyAggrSort(resultSet);
        return resultSet;
    }

    private void applyTopBottomFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, List levelFilterList) throws DataException, IOException {
        int i = 0;
        while (i < aggregations.length) {
            if (aggregations[i].getAggregationFunctions() != null) {
                HashMap<DimLevel, Object[]> levelFilterMap = new HashMap<DimLevel, Object[]>();
                Iterator<Object> j = this.topbottomFilters.iterator();
                while (j.hasNext()) {
                    TopBottomFilter filter = (TopBottomFilter)j.next();
                    if (!filter.getFilterHelper().isAggregationFilter() || !this.isEqualLevels(aggregations[i].getLevels(), filter.getAggrLevels())) continue;
                    IDiskArray levelKeyList = this.populateLevelKeyList(aggregations[i], resultSet[i], filter);
                    IDiskArray selectedLevelKeys = null;
                    if (levelFilterMap.containsKey(filter.getTargetLevel())) {
                        Object[] valueObjs = (Object[])levelFilterMap.get(filter.getTargetLevel());
                        selectedLevelKeys = (IDiskArray)valueObjs[0];
                        selectedLevelKeys = this.getIntersection(selectedLevelKeys, levelKeyList);
                    } else {
                        selectedLevelKeys = levelKeyList;
                    }
                    levelFilterMap.put(filter.getTargetLevel(), new Object[]{selectedLevelKeys, filter.getFilterHelper()});
                }
                j = levelFilterMap.keySet().iterator();
                while (j.hasNext()) {
                    DimLevel target = (DimLevel)j.next();
                    Object[] valueObjs = (Object[])levelFilterMap.get(target);
                    IDiskArray selectedKeyArray = (IDiskArray)valueObjs[0];
                    IJSFilterHelper filterHelper = (IJSFilterHelper)valueObjs[1];
                    if (selectedKeyArray.size() == 0) continue;
                    ILevel[] levels = this.getLevelsOfDimension(target.getDimensionName());
                    int index = this.getTargetLevelIndex(levels, target.getLevelName());
                    HashMap<String, ArrayList<MultiKey>> keyMap = new HashMap<String, ArrayList<MultiKey>>();
                    int k = 0;
                    while (k < selectedKeyArray.size()) {
                        MultiKey multiKey = (MultiKey)selectedKeyArray.get(k);
                        String parentKey = this.getParentKey(multiKey.dimMembers, index);
                        ArrayList<MultiKey> keyList = (ArrayList<MultiKey>)keyMap.get(parentKey);
                        if (keyList == null) {
                            keyList = new ArrayList<MultiKey>();
                            keyMap.put(parentKey, keyList);
                        }
                        keyList.add(multiKey);
                        ++k;
                    }
                    Iterator keyItr = keyMap.values().iterator();
                    while (keyItr.hasNext()) {
                        List keyList = (List)keyItr.next();
                        ISelection selections = this.toMultiKeySelection(keyList);
                        LevelFilter levelFilter = new LevelFilter(target, new ISelection[]{selections});
                        levelFilter.setDimMembers(((MultiKey)keyList.get((int)0)).dimMembers);
                        levelFilter.setFilterHelper(filterHelper);
                        levelFilterList.add(levelFilter);
                    }
                }
            }
            ++i;
        }
    }

    private ISelection toMultiKeySelection(List keyList) {
        Object[][] keys = new Object[keyList.size()][];
        int i = 0;
        while (i < keyList.size()) {
            MultiKey multiKey = (MultiKey)keyList.get(i);
            keys[i] = multiKey.values;
            ++i;
        }
        return SelectionFactory.createMutiKeySelection(keys);
    }

    private String getParentKey(Member[] members, int index) {
        if (!($assertionsDisabled || index >= 0 && index < members.length)) {
            throw new AssertionError();
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            if (members[i] == null) {
                buf.append('?');
            } else {
                Object[] keyValues = members[i].getKeyValues();
                if (keyValues != null && keyValues.length > 0) {
                    int j = 0;
                    while (j < keyValues.length) {
                        buf.append(keyValues[j].toString());
                        buf.append(',');
                        ++j;
                    }
                    buf.deleteCharAt(buf.length() - 1);
                }
            }
            buf.append('-');
            ++i;
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private IDiskArray getIntersection(IDiskArray array1, IDiskArray array2) throws IOException {
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(4000);
        int i = 0;
        int j = 0;
        while (i < array1.size() && j < array2.size()) {
            Comparable key2;
            Comparable key1 = (Comparable)array1.get(i);
            int ret = key1.compareTo(key2 = (Comparable)array2.get(j));
            if (ret == 0) {
                result.add(key1);
                ++i;
                ++j;
                continue;
            }
            if (ret < 0) {
                ++i;
                continue;
            }
            ++j;
        }
        array1.close();
        array2.close();
        return result;
    }

    private void applyAggrSort(IAggregationResultSet[] resultSet) throws DataException {
        if (!this.columnSort.isEmpty()) {
            IAggregationResultSet column;
            resultSet[this.findMatchedResultSetIndex((IAggregationResultSet[])resultSet, (IAggregationResultSet)column)] = column = AggrSortHelper.sort(this.columnSort, resultSet);
        }
        if (!this.rowSort.isEmpty()) {
            IAggregationResultSet row;
            resultSet[this.findMatchedResultSetIndex((IAggregationResultSet[])resultSet, (IAggregationResultSet)row)] = row = AggrSortHelper.sort(this.rowSort, resultSet);
        }
    }

    private void applyAggrFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, StopSign stopSign) throws IOException, DataException, BirtException {
        if (!this.aggrFilters.isEmpty() || !this.topbottomFilters.isEmpty()) {
            ArrayList oldFilters = new ArrayList(this.filters);
            this.addLevelFilters(this.generateLevelFilters(aggregations, resultSet));
            if (this.isEmptyXTab) {
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].clear();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].close();
                    resultSet[i] = null;
                    ++i;
                }
                IAggregationResultSet[] temp = this.onePassExecute(aggregations, stopSign);
                System.arraycopy(temp, 0, resultSet, 0, resultSet.length);
            }
            this.filters = oldFilters;
        }
    }

    private int findMatchedResultSetIndex(IAggregationResultSet[] rSets, IAggregationResultSet source) throws DataException {
        int i = 0;
        while (i < rSets.length) {
            if (AggrSortHelper.isEdgeResultSet(rSets[i]) && source.getLevel(0).equals(rSets[i].getLevel(0))) {
                return i;
            }
            ++i;
        }
        throw new DataException("Invalid");
    }

    private IAggregationResultSet[] onePassExecute(AggregationDefinition[] aggregations, StopSign stopSign) throws DataException, IOException, BirtException {
        IDiskArray[] dimPosition = this.getFilterResult();
        int count = 0;
        int i = 0;
        while (i < dimPosition.length) {
            if (dimPosition[i] != null) {
                ++count;
            }
            ++i;
        }
        IDimension[] dimensions = this.cube.getDimesions();
        String[] validDimensionName = new String[count];
        IDiskArray[] validDimPosition = new IDiskArray[count];
        int pos = 0;
        int i2 = 0;
        while (i2 < dimPosition.length) {
            if (dimPosition[i2] != null) {
                validDimPosition[pos] = dimPosition[i2];
                validDimensionName[pos] = dimensions[i2].getName();
                ++pos;
            }
            ++i2;
        }
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(this.cube.getFactTable(), validDimensionName, validDimPosition, this.computedMeasureHelper, stopSign);
        IDimensionResultIterator[] dimensionResultIterator = this.populateDimensionResultIterator(dimPosition);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(dimensionResultIterator, facttableRowIterator, aggregations);
        return aggregationCalculatorExecutor.execute(stopSign);
    }

    private List generateLevelFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet) throws IOException, DataException {
        ArrayList levelFilterList = new ArrayList();
        Iterator i = this.aggrFilters.iterator();
        while (i.hasNext()) {
            AggrFilter filter = (AggrFilter)i.next();
            int j = 0;
            while (!this.isEmptyXTab && j < aggregations.length) {
                if (aggregations[j].getAggregationFunctions() != null && this.isEqualLevels(aggregations[j].getLevels(), filter.getAggrLevels())) {
                    this.applyAggrFilter(aggregations, resultSet, j, filter, levelFilterList);
                }
                ++j;
            }
        }
        this.applyTopBottomFilters(aggregations, resultSet, levelFilterList);
        return levelFilterList;
    }

    private IDiskArray populateLevelKeyList(AggregationDefinition aggregation, IAggregationResultSet resultSet, TopBottomFilter filter) throws IOException, DataException {
        IJSTopBottomFilterHelper filterHelper = filter.getFilterHelper();
        int n = -1;
        if (!filterHelper.isPercent()) {
            n = (int)filterHelper.getN();
        }
        OrderedDiskArray aggrValueArray = new OrderedDiskArray(n, filterHelper.isTop());
        AggregationFunctionDefinition[] aggrFuncs = aggregation.getAggregationFunctions();
        DimLevel[] aggrLevels = filter.getAggrLevels();
        String dimensionName = filter.getTargetLevel().getDimensionName();
        String[] fields = this.getAllFieldNames(aggrLevels, resultSet);
        String[] aggrNames = new String[aggrFuncs.length];
        int k = 0;
        while (k < aggrFuncs.length) {
            aggrNames[k] = aggrFuncs[k].getName();
            ++k;
        }
        k = 0;
        while (k < resultSet.length()) {
            int levelIndex;
            resultSet.seek(k);
            int fieldIndex = 0;
            Object[] fieldValues = new Object[fields.length];
            Object[] aggrValues = new Object[aggrFuncs.length];
            int m = 0;
            while (m < aggrLevels.length) {
                levelIndex = resultSet.getLevelIndex(aggrLevels[m]);
                if (levelIndex >= 0 && levelIndex < resultSet.getLevelCount()) {
                    fieldValues[fieldIndex++] = resultSet.getLevelKeyValue(levelIndex)[0];
                }
                ++m;
            }
            m = 0;
            while (m < aggrFuncs.length) {
                int aggrIndex = resultSet.getAggregationIndex(aggrNames[m]);
                aggrValues[m] = resultSet.getAggregationValue(aggrIndex);
                ++m;
            }
            RowForFilter row = new RowForFilter(fields, aggrNames);
            row.setFieldValues(fieldValues);
            row.setAggrValues(aggrValues);
            levelIndex = resultSet.getLevelIndex(filter.getTargetLevel());
            Object[] levelKey = resultSet.getLevelKeyValue(levelIndex);
            if (levelKey != null && filterHelper.isQualifiedRow(row)) {
                Object aggrValue = filterHelper.evaluateFilterExpr(row);
                Member[] members = this.getTargetDimMembers(dimensionName, resultSet);
                aggrValueArray.add(new ValueObject(aggrValue, new MultiKey(levelKey, members)));
            }
            ++k;
        }
        return this.fetchLevelKeys(aggrValueArray, filterHelper);
    }

    private IDiskArray fetchLevelKeys(IDiskArray aggrValueArray, IJSTopBottomFilterHelper filterHelper) throws IOException {
        BufferedPrimitiveDiskArray levelKeyArray = new BufferedPrimitiveDiskArray(4000);
        int start = 0;
        int end = aggrValueArray.size();
        if (filterHelper.isPercent()) {
            int size = aggrValueArray.size();
            int n = this.getTargetN(size, filterHelper.getN());
            if (filterHelper.isTop()) {
                start = size - n;
            } else {
                end = n;
            }
        }
        int i = start;
        while (i < end) {
            ValueObject aggrValue = (ValueObject)aggrValueArray.get(i);
            levelKeyArray.add(aggrValue.index);
            ++i;
        }
        return levelKeyArray;
    }

    private final int getTargetN(long total, double N) {
        return (int)Math.round(N / 100.0 * (double)total);
    }

    private ILevel[] getLevelsOfDimension(String dimensionName) {
        return (ILevel[])this.dimLevelsMap.get(dimensionName);
    }

    private Member[] getTargetDimMembers(String dimensionName, IAggregationResultSet resultSet) {
        ILevel[] levels = this.getLevelsOfDimension(dimensionName);
        Member[] members = new Member[levels.length];
        int i = 0;
        while (i < levels.length) {
            int levelIndex = resultSet.getLevelIndex(new DimLevel(dimensionName, levels[i].getName()));
            if (levelIndex >= 0) {
                Object[] values = resultSet.getLevelKeyValue(levelIndex);
                Object[][] objectArray = new Object[2][];
                objectArray[0] = values;
                Object[] fieldValues = ObjectArrayUtil.convert(objectArray);
                members[i] = (Member)Member.getCreator().createInstance(fieldValues);
            }
            ++i;
        }
        return members;
    }

    private void applyAggrFilter(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, int j, AggrFilter filter, List levelFilters) throws IOException, DataException {
        AggregationFunctionDefinition[] aggrFuncs = aggregations[j].getAggregationFunctions();
        DimLevel[] aggrLevels = filter.getAggrLevels();
        String[] fields = this.getAllFieldNames(aggrLevels, resultSet[j]);
        String[] aggrNames = new String[aggrFuncs.length];
        int k = 0;
        while (k < aggrFuncs.length) {
            aggrNames[k] = aggrFuncs[k].getName();
            ++k;
        }
        DimLevel targetLevel = filter.getTargetLevel();
        ILevel[] levelsOfDimension = this.getLevelsOfDimension(targetLevel.getDimensionName());
        int targetIndex = this.getTargetLevelIndex(levelsOfDimension, targetLevel.getLevelName());
        ArrayList<Object[]> selKeyValueList = new ArrayList<Object[]>();
        Member[] preMembers = null;
        int k2 = 0;
        while (k2 < resultSet[j].length()) {
            resultSet[j].seek(k2);
            int fieldIndex = 0;
            Object[] fieldValues = new Object[fields.length];
            Object[] aggrValues = new Object[aggrFuncs.length];
            int m = 0;
            while (m < aggrLevels.length) {
                int levelIndex = resultSet[j].getLevelIndex(aggrLevels[m]);
                if (levelIndex >= 0 && levelIndex < resultSet[j].getLevelCount()) {
                    fieldValues[fieldIndex++] = resultSet[j].getLevelKeyValue(levelIndex)[0];
                }
                ++m;
            }
            m = 0;
            while (m < aggrFuncs.length) {
                int aggrIndex = resultSet[j].getAggregationIndex(aggrNames[m]);
                aggrValues[m] = resultSet[j].getAggregationValue(aggrIndex);
                ++m;
            }
            RowForFilter row = new RowForFilter(fields, aggrNames);
            row.setFieldValues(fieldValues);
            row.setAggrValues(aggrValues);
            boolean isSelect = filter.getFilterHelper().evaluateFilter(row);
            if (isSelect) {
                int levelIndex;
                Object[] levelKeyValue;
                Member[] members = this.getTargetDimMembers(targetLevel.getDimensionName(), resultSet[j]);
                if (preMembers != null && !this.shareParentLevels(members, preMembers, targetIndex)) {
                    LevelFilter levelFilter = this.toLevelFilter(targetLevel, selKeyValueList, preMembers, filter.getFilterHelper());
                    levelFilters.add(levelFilter);
                    selKeyValueList.clear();
                }
                if ((levelKeyValue = resultSet[j].getLevelKeyValue(levelIndex = resultSet[j].getLevelIndex(targetLevel))) != null && levelKeyValue[0] != null) {
                    selKeyValueList.add(levelKeyValue);
                }
                preMembers = members;
            }
            ++k2;
        }
        if (preMembers == null) {
            this.isEmptyXTab = true;
            return;
        }
        if (!selKeyValueList.isEmpty()) {
            LevelFilter levelFilter = this.toLevelFilter(targetLevel, selKeyValueList, preMembers, filter.getFilterHelper());
            levelFilters.add(levelFilter);
        }
    }

    private LevelFilter toLevelFilter(DimLevel targetLevel, List selKeyValueList, Member[] dimMembers, IJSFilterHelper filterHelper) {
        Object[][] keyValues = new Object[selKeyValueList.size()][];
        int i = 0;
        while (i < selKeyValueList.size()) {
            keyValues[i] = (Object[])selKeyValueList.get(i);
            ++i;
        }
        ISelection selection = SelectionFactory.createMutiKeySelection(keyValues);
        LevelFilter levelFilter = new LevelFilter(targetLevel, new ISelection[]{selection});
        levelFilter.setDimMembers(dimMembers);
        levelFilter.setFilterHelper(filterHelper);
        return levelFilter;
    }

    private String[] getAllFieldNames(DimLevel[] levels, IAggregationResultSet resultSet) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        int i = 0;
        while (i < levels.length) {
            int levelIndex = resultSet.getLevelIndex(levels[i]);
            if (levelIndex >= 0 && levelIndex < resultSet.getLevelCount()) {
                fieldNameList.add(String.valueOf(levels[i].getDimensionName()) + '/' + levels[i].getLevelName());
            }
            ++i;
        }
        String[] fieldNames = new String[fieldNameList.size()];
        fieldNameList.toArray(fieldNames);
        return fieldNames;
    }

    private boolean isEqualLevels(DimLevel[] levels1, DimLevel[] levels2) {
        if (levels1 == null && levels2 == null) {
            return true;
        }
        if (levels1 == null || levels2 == null) {
            return false;
        }
        if (levels1.length != levels2.length) {
            return false;
        }
        int i = 0;
        while (i < levels1.length) {
            if (!levels1[i].equals(levels2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private DimensionResultIterator[] populateDimensionResultIterator(IDiskArray[] position) throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        DimensionResultIterator[] dimResultSet = new DimensionResultIterator[dimensions.length];
        int count = 0;
        int i = 0;
        while (i < dimensions.length) {
            dimResultSet[i] = position[i] == null ? new DimensionResultIterator((Dimension)dimensions[i], dimensions[i].findAll()) : new DimensionResultIterator((Dimension)dimensions[i], position[i]);
            ++count;
            ++i;
        }
        DimensionResultIterator[] result = new DimensionResultIterator[count];
        int pos = 0;
        int i2 = 0;
        while (i2 < dimResultSet.length) {
            if (dimResultSet[i2] != null) {
                result[pos] = dimResultSet[i2];
                ++pos;
            }
            ++i2;
        }
        return result;
    }

    private IDiskArray getJSFilterResult(Dimension dimension, IDiskArray dimPosition) throws DataException, IOException {
        if (dimPosition == null) {
            if (this.getDimensionJSFilterList(dimension.getName()).size() <= 0) {
                return null;
            }
            dimPosition = dimension.findAll();
        }
        List filterList = this.getDimensionJSFilterList(dimension.getName());
        ArrayList dimFilterList = new ArrayList();
        ArrayList topBottomfilterList = new ArrayList();
        int j = 0;
        while (j < filterList.size()) {
            Object filterHelper = filterList.get(j);
            if (filterHelper instanceof IJSDimensionFilterHelper) {
                dimFilterList.add(filterHelper);
            } else if (filterHelper instanceof IJSTopBottomFilterHelper) {
                topBottomfilterList.add(filterHelper);
            }
            ++j;
        }
        IDiskArray result = this.getDimFilterPositions(dimension, dimPosition, dimFilterList);
        if (topBottomfilterList.isEmpty()) {
            return result;
        }
        IDiskArray result2 = this.getTopbottomFilterPositions(dimension, dimPosition, topBottomfilterList);
        return this.getIntersection(result, result2);
    }

    private IDiskArray getDimFilterPositions(Dimension dimension, IDiskArray dimPosition, List dimFilterList) throws IOException, DataException {
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(4000);
        int i = 0;
        while (i < dimPosition.size()) {
            Integer pos = (Integer)dimPosition.get(i);
            if (this.isDimPositionSelected(dimension, pos, dimFilterList)) {
                result.add(pos);
            }
            ++i;
        }
        return result;
    }

    private boolean isDimPositionSelected(Dimension dimension, int pos, List dimFilterList) throws IOException, DataException {
        DimensionRow dimRow = dimension.getRowByPosition(pos);
        RowForFilter rowForFilter = this.getRowForFilter(dimension, dimRow);
        int j = 0;
        while (j < dimFilterList.size()) {
            IJSDimensionFilterHelper filterHelper = (IJSDimensionFilterHelper)dimFilterList.get(j);
            if (!filterHelper.evaluateFilter(rowForFilter)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private List getDimensionJSFilterList(String dimensionName) {
        Object value = this.dimJSFilterMap.get(dimensionName);
        if (value != null) {
            return (List)value;
        }
        ArrayList list = new ArrayList();
        this.dimJSFilterMap.put(dimensionName, list);
        return list;
    }

    private RowForFilter getRowForFilter(Dimension dimension, DimensionRow dimRow) {
        RowForFilter rowForFilter = (RowForFilter)this.dimRowForFilterMap.get(dimension.getName());
        if (rowForFilter == null) {
            String[] fieldNames = CubeQueryExecutorHelper.getAllFieldNames(dimension);
            rowForFilter = new RowForFilter(fieldNames);
            this.dimRowForFilterMap.put(dimension.getName(), rowForFilter);
        }
        ArrayList<Object> fields = new ArrayList<Object>();
        int i = 0;
        while (i < dimRow.getMembers().length) {
            int j;
            if (dimRow.getMembers()[i].getKeyValues() != null) {
                j = 0;
                while (j < dimRow.getMembers()[i].getKeyValues().length) {
                    fields.add(dimRow.getMembers()[i].getKeyValues()[j]);
                    ++j;
                }
            }
            if (dimRow.getMembers()[i].getAttributes() != null) {
                j = 0;
                while (j < dimRow.getMembers()[i].getAttributes().length) {
                    fields.add(dimRow.getMembers()[i].getAttributes()[j]);
                    ++j;
                }
            }
            ++i;
        }
        rowForFilter.setFieldValues(fields.toArray());
        return rowForFilter;
    }

    private static String[] getAllFieldNames(Dimension dimension) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        int i = 0;
        while (i < levels.length) {
            String[] attrNames;
            String[] keyNames = levels[i].getKeyNames();
            if (keyNames != null) {
                int j = 0;
                while (j < keyNames.length) {
                    fieldNameList.add(CubeQueryExecutorHelper.getAttrReference(dimension.getName(), levels[i].getName(), keyNames[j]));
                    ++j;
                }
            }
            if ((attrNames = levels[i].getAttributeNames()) != null) {
                int j = 0;
                while (j < attrNames.length) {
                    fieldNameList.add(CubeQueryExecutorHelper.getAttrReference(dimension.getName(), levels[i].getName(), attrNames[j]));
                    ++j;
                }
            }
            ++i;
        }
        String[] fieldNames = new String[fieldNameList.size()];
        fieldNameList.toArray(fieldNames);
        return fieldNames;
    }

    private IDiskArray[] getFilterResult() throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        IDiskArray[] dimPosition = new IDiskArray[dimensions.length];
        int i = 0;
        while (i < dimPosition.length) {
            dimPosition[i] = this.getJSFilterResult((Dimension)dimensions[i], this.getSimpleFilterResult((Dimension)dimensions[i]));
            ++i;
        }
        return dimPosition;
    }

    private IDiskArray getTopbottomFilterPositions(Dimension dimension, IDiskArray dimPosition, List filterList) throws IOException, DataException {
        IDiskArray result = null;
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int i = 0;
        while (i < filterList.size()) {
            IJSTopBottomFilterHelper filter = (IJSTopBottomFilterHelper)filterList.get(i);
            List dimValueArrayList = this.evaluateFilter(dimension, dimPosition, levels, filter);
            IDiskArray dimPositionArray = this.fetchDimPositions(dimValueArrayList, filter);
            result = result == null ? dimPositionArray : this.getIntersection(result, dimPositionArray);
            ++i;
        }
        return result == null ? dimPosition : result;
    }

    private List evaluateFilter(Dimension dimension, IDiskArray dimPosition, ILevel[] levels, IJSTopBottomFilterHelper filter) throws DataException, IOException {
        ArrayList<IDiskArray> dimValueArrayList = new ArrayList<IDiskArray>();
        int index = this.getTargetLevelIndex(levels, filter.getTargetLevel().getLevelName());
        Member[] preMembers = null;
        Object[] preValue = null;
        IDiskArray dimValueArray = null;
        int n = -1;
        if (!filter.isPercent()) {
            n = (int)filter.getN();
        }
        if (this.isBreakHierarchy) {
            dimValueArray = new OrderedDiskArray(n, filter.isTop());
            dimValueArrayList.add(dimValueArray);
        }
        IntRange range = null;
        int j = 0;
        while (j < dimPosition.size()) {
            boolean shareParentLevels;
            Integer pos = (Integer)dimPosition.get(j);
            DimensionRow dimRow = dimension.getRowByPosition(pos);
            boolean bl = shareParentLevels = preMembers != null && this.shareParentLevels(dimRow.getMembers(), preMembers, index);
            if (!this.isBreakHierarchy) {
                if (shareParentLevels) {
                    dimValueArray = (IDiskArray)dimValueArrayList.get(dimValueArrayList.size() - 1);
                } else {
                    dimValueArray = new OrderedDiskArray(n, filter.isTop());
                    dimValueArrayList.add(dimValueArray);
                }
            }
            preMembers = dimRow.getMembers();
            Object[] levelValue = dimRow.getMembers()[index].getKeyValues();
            if (preValue == null || !shareParentLevels || CompareUtil.compare(preValue, levelValue) != 0) {
                RowForFilter rowForFilter = this.getRowForFilter(dimension, dimRow);
                Object value = filter.evaluateFilterExpr(rowForFilter);
                range = new IntRange(pos, pos);
                dimValueArray.add(new ValueObject(value, range));
            } else {
                range.end = pos;
            }
            preValue = levelValue;
            ++j;
        }
        return dimValueArrayList;
    }

    private IDiskArray fetchDimPositions(List dimValueArrayList, IJSTopBottomFilterHelper filterHelper) throws IOException {
        OrderedDiskArray dimPositionArray = new OrderedDiskArray();
        Iterator itr = dimValueArrayList.iterator();
        while (itr.hasNext()) {
            IDiskArray dimValues = (IDiskArray)itr.next();
            int size = dimValues.size();
            int start = 0;
            int end = size;
            if (filterHelper.isPercent()) {
                int n = this.getTargetN(size, filterHelper.getN());
                if (filterHelper.isTop()) {
                    start = size - n;
                } else {
                    end = n;
                }
            }
            int j = start;
            while (j < end) {
                ValueObject aggrValue = (ValueObject)dimValues.get(j);
                IntRange range = (IntRange)aggrValue.index;
                int k = range.start;
                while (k <= range.end) {
                    dimPositionArray.add(new Integer(k));
                    ++k;
                }
                ++j;
            }
        }
        return dimPositionArray;
    }

    private int getTargetLevelIndex(ILevel[] levels, String targetLevelName) {
        int index = 0;
        index = 0;
        while (index < levels.length) {
            if (levels[index].getName().equals(targetLevelName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean shareParentLevels(Member[] members1, Member[] member2, int targetIndex) {
        if (!($assertionsDisabled || members1 != null && member2 != null)) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < targetIndex) {
            if (members1[i] != null && member2[i] != null && !members1[i].equals(member2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IDiskArray getSimpleFilterResult(Dimension dimension) throws DataException, IOException {
        if (this.filters.isEmpty()) {
            return dimension.findAll();
        }
        Map validFilterMap = this.populateValidFilters(dimension);
        if (validFilterMap.isEmpty()) {
            return dimension.findAll();
        }
        IDiskArray selectedPositions = this.populateValidPositions(dimension, validFilterMap);
        return selectedPositions;
    }

    private IDiskArray populateValidPositions(Dimension dimension, Map validFilterMap) throws IOException {
        BufferedPrimitiveDiskArray selectedPositions = new BufferedPrimitiveDiskArray();
        ILevel[] levels = this.getLevelsOfDimension(dimension.getName());
        int i = 0;
        while (i < dimension.length()) {
            DimensionRow row = dimension.getRowByPosition(i);
            Member[] curMembers = row.getMembers();
            boolean isSelectedByAll = true;
            Iterator levelItr = validFilterMap.keySet().iterator();
            while (levelItr.hasNext()) {
                String levelName = (String)levelItr.next();
                boolean isSelectedByAny = false;
                List filterList = (List)validFilterMap.get(levelName);
                if (!$assertionsDisabled && filterList.size() <= 0) {
                    throw new AssertionError();
                }
                LevelFilter firstFilter = (LevelFilter)filterList.get(0);
                int targetIndex = this.getTargetLevelIndex(levels, firstFilter.getLevelName());
                if (!$assertionsDisabled && targetIndex < 0) {
                    throw new AssertionError();
                }
                Iterator filterItr = filterList.iterator();
                while (filterItr.hasNext()) {
                    LevelFilter filter = (LevelFilter)filterItr.next();
                    Member[] dimMembers = filter.getDimMembers();
                    if (dimMembers == null || this.shareParentLevels(curMembers, dimMembers, targetIndex)) {
                        ISelection[] selectins = filter.getSelections();
                        int k = 0;
                        while (k < selectins.length) {
                            if (selectins[k].isSelected(curMembers[targetIndex].getKeyValues())) {
                                isSelectedByAny = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (isSelectedByAny) break;
                }
                if (isSelectedByAny) continue;
                isSelectedByAll = false;
                break;
            }
            if (isSelectedByAll) {
                selectedPositions.add(new Integer(i));
            }
            ++i;
        }
        return selectedPositions;
    }

    private Map populateValidFilters(Dimension dimension) {
        HashMap validFilterMap = new HashMap();
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            LevelFilter filter = (LevelFilter)i.next();
            if (!filter.getDimensionName().equals(dimension.getName())) continue;
            String keyName = this.createLevelKey(filter, filter.getLevelName());
            this.addFilter(validFilterMap, filter, keyName);
        }
        return validFilterMap;
    }

    private void addFilter(Map validFilterMap, LevelFilter filter, String levelName) {
        List<LevelFilter> filterList = null;
        if (validFilterMap.containsKey(levelName)) {
            filterList = (List)validFilterMap.get(levelName);
        } else {
            filterList = new ArrayList();
            validFilterMap.put(levelName, filterList);
        }
        filterList.add(filter);
    }

    private String createLevelKey(LevelFilter filter, String levelName) {
        IJSFilterHelper filterHelper = filter.getFilterHelper();
        if (filterHelper != null) {
            levelName = String.valueOf(levelName) + '_' + filterHelper.hashCode();
        }
        return levelName;
    }

    public void addJSFilter(IJSFilterHelper filterEvalHelper) {
        if (!filterEvalHelper.isAggregationFilter()) {
            String dimesionName = filterEvalHelper.getDimensionName();
            List filterList = this.getDimensionJSFilterList(dimesionName);
            filterList.add(filterEvalHelper);
        } else if (filterEvalHelper instanceof IJSDimensionFilterHelper) {
            IJSDimensionFilterHelper helper = (IJSDimensionFilterHelper)filterEvalHelper;
            this.aggrFilters.add(new AggrFilter(helper));
        } else if (filterEvalHelper instanceof IJSTopBottomFilterHelper) {
            IJSTopBottomFilterHelper helper = (IJSTopBottomFilterHelper)filterEvalHelper;
            this.topbottomFilters.add(new TopBottomFilter(helper));
        }
    }

    public void addJSFilter(List filterEvalHelperList) {
        int i = 0;
        while (i < filterEvalHelperList.size()) {
            this.addJSFilter((IJSFilterHelper)filterEvalHelperList.get(i));
            ++i;
        }
    }

    public void setBreakHierarchy(boolean isBreakHierarchy) {
        this.isBreakHierarchy = isBreakHierarchy;
    }
}

