/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.logging.Logger;

public class Traversalor {
    private int cursor = -1;
    private int length = 0;
    private int maxLength = 1;
    private boolean valid = true;
    private int[] positionValue;
    private int[] lengthArray;
    private int[] current;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.Traversalor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public Traversalor(int[] lengthArray) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.Traversalor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "Traversalor", (Object)lengthArray);
        this.lengthArray = lengthArray;
        this.length = lengthArray.length;
        this.positionValue = new int[this.length];
        this.current = new int[this.length];
        this.init();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.Traversalor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "Traversalor");
    }

    private void init() {
        this.checkSyntax();
        this.computeMaxLength();
        this.computePositionValue();
    }

    private void checkSyntax() {
        int i = 0;
        while (i < this.length) {
            if (this.lengthArray[i] <= 0) {
                this.valid = false;
                return;
            }
            ++i;
        }
    }

    private void computeMaxLength() {
        int i = 0;
        while (i < this.length) {
            this.maxLength *= this.lengthArray[i];
            ++i;
        }
    }

    private void computePositionValue() {
        int i = this.length - 1;
        while (i >= 0) {
            this.positionValue[i] = 1;
            if (i != this.length - 1) {
                int j = this.length - 1;
                while (j > i) {
                    int n = i;
                    this.positionValue[n] = this.positionValue[n] * this.lengthArray[j];
                    --j;
                }
            }
            --i;
        }
    }

    public boolean next() {
        this.checkValid();
        if (!this.valid) {
            return false;
        }
        ++this.cursor;
        this.computeCurrent();
        return true;
    }

    private void checkValid() {
        if (!this.valid) {
            return;
        }
        if (this.cursor == this.maxLength - 1) {
            this.valid = false;
        }
    }

    private void computeCurrent() {
        int position = this.cursor;
        int i = 0;
        while (i < this.length) {
            this.current[i] = position / this.positionValue[i];
            if (this.current[i] > 0) {
                position %= this.positionValue[i];
            }
            ++i;
        }
    }

    public int[] getIntArray() {
        return this.current;
    }

    public int getInt(int index) {
        return this.current[index];
    }
}

