/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;

class Row4AggregationPopulator {
    private int[] position = null;
    private IDimensionResultIterator[] dimesionResultIterators = null;
    private IFactTableRowIterator facttableRowIterator = null;
    private int[] dimensionIndexs = null;
    private int[][] parameterColIndex = null;

    Row4AggregationPopulator(IDimensionResultIterator[] dimesionResultIterators, IFactTableRowIterator facttableRowIterator, int[][] parameterColIndex) {
        this.dimesionResultIterators = dimesionResultIterators;
        this.facttableRowIterator = facttableRowIterator;
        this.position = new int[dimesionResultIterators.length];
        this.dimensionIndexs = new int[dimesionResultIterators.length];
        int i = 0;
        while (i < dimesionResultIterators.length) {
            this.dimensionIndexs[i] = facttableRowIterator.getDimensionIndex(dimesionResultIterators[i].getDimesion().getName());
            ++i;
        }
        this.parameterColIndex = parameterColIndex;
    }

    Object[] getParameterValues() throws BirtException, IOException {
        if (this.parameterColIndex == null || this.parameterColIndex.length == 0) {
            return null;
        }
        Object[] reValues = new Object[this.parameterColIndex.length];
        int i = 0;
        while (i < reValues.length) {
            Member member = this.getLevelObject(this.parameterColIndex[i][1], this.parameterColIndex[i][2], this.facttableRowIterator.getDimensionPosition(this.dimensionIndexs[this.parameterColIndex[i][1]]));
            reValues[i] = this.parameterColIndex[i][0] == 0 ? member.getKeyValues()[this.parameterColIndex[i][3]] : member.getAttributes()[this.parameterColIndex[i][3]];
            ++i;
        }
        return reValues;
    }

    Member[] getLevelMembers(int[] levelIndex) throws BirtException, IOException {
        Member[] result = new Member[levelIndex.length / 2];
        int i = 0;
        while (i < result.length) {
            int iteratorIndex = levelIndex[i * 2];
            int iteratorLevelIndex = levelIndex[i * 2 + 1];
            int dimensionIndex = this.dimensionIndexs[iteratorIndex];
            result[i] = this.getLevelObject(iteratorIndex, iteratorLevelIndex, this.facttableRowIterator.getDimensionPosition(dimensionIndex));
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    private Member getLevelObject(int iteratorIndex, int levelIndex, int dimensionPosition) throws BirtException, IOException {
        block2: {
            while (true) {
                this.dimesionResultIterators[iteratorIndex].seek(this.position[iteratorIndex]);
                int curDimPosition = this.dimesionResultIterators[iteratorIndex].getDimesionPosition();
                if (curDimPosition > dimensionPosition) {
                    int n = iteratorIndex;
                    this.position[n] = this.position[n] - 1;
                    if (this.position[iteratorIndex] >= 0) continue;
                    this.position[iteratorIndex] = 0;
                    return null;
                }
                if (curDimPosition >= dimensionPosition) break block2;
                int n = iteratorIndex;
                this.position[n] = this.position[n] + 1;
                if (this.position[iteratorIndex] >= this.dimesionResultIterators[iteratorIndex].length()) break;
            }
            int n = iteratorIndex;
            this.position[n] = this.position[n] - 1;
            return null;
        }
        return this.dimesionResultIterators[iteratorIndex].getLevelMember(levelIndex);
    }
}

