/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.math.BigInteger;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IntRange;

class CombinedPositionContructor {
    private DimensionDivision[] subDimensions;
    private int[] dimensionBitLength;
    private int totalBitLength;

    CombinedPositionContructor(DimensionDivision[] subDimensions) {
        this.subDimensions = subDimensions;
        this.calculateBitLength(subDimensions);
    }

    private void calculateBitLength(DimensionDivision[] dimensionDivision) {
        this.dimensionBitLength = new int[dimensionDivision.length];
        int i = 0;
        while (i < dimensionDivision.length) {
            IntRange[] ranges = dimensionDivision[i].getRanges();
            int maxRange = 0;
            int j = 0;
            while (j < ranges.length) {
                if (ranges[j].end - ranges[j].start > maxRange) {
                    maxRange = ranges[j].end - ranges[j].start + 1;
                }
                ++j;
            }
            this.dimensionBitLength[i] = this.getBitLength(maxRange);
            this.totalBitLength += this.dimensionBitLength[i];
            ++i;
        }
    }

    private int getBitLength(int maxInt) {
        int bitLength = 1;
        int powerValue = 2;
        while (powerValue < maxInt) {
            ++bitLength;
            powerValue *= 2;
        }
        return bitLength;
    }

    public BigInteger calculateCombinedPosition(int[] subdimensionIndex, int[] dimensionPosition) {
        long l = dimensionPosition[0] - this.subDimensions[0].getRanges()[subdimensionIndex[0]].start;
        int bitLength = this.dimensionBitLength[0];
        int i = 1;
        while (i < dimensionPosition.length) {
            if (bitLength + this.dimensionBitLength[i] >= 63) break;
            l <<= this.dimensionBitLength[i];
            l |= (long)(dimensionPosition[i] - this.subDimensions[i].getRanges()[subdimensionIndex[i]].start);
            bitLength += this.dimensionBitLength[i];
            ++i;
        }
        BigInteger bigInteger = BigInteger.valueOf(l);
        while (i < dimensionPosition.length) {
            bigInteger = bigInteger.shiftLeft(this.dimensionBitLength[i]);
            bigInteger = bigInteger.or(BigInteger.valueOf(dimensionPosition[i] - this.subDimensions[i].getRanges()[subdimensionIndex[i]].start));
            ++i;
        }
        return bigInteger;
    }

    public int[] calculateDimensionPosition(int[] subdimensionIndex, byte[] combinedPosition) {
        BigInteger bigInteger = new BigInteger(combinedPosition);
        int[] dimensionPosition = new int[this.dimensionBitLength.length];
        if (this.totalBitLength <= 63) {
            long l = bigInteger.longValue();
            int i = this.dimensionBitLength.length - 1;
            while (i >= 0) {
                dimensionPosition[i] = this.subDimensions[i].getRanges()[subdimensionIndex[i]].start + (int)(l & (long)(Integer.MAX_VALUE >> 31 - this.dimensionBitLength[i]));
                l >>= this.dimensionBitLength[i];
                --i;
            }
            return dimensionPosition;
        }
        int i = this.dimensionBitLength.length - 1;
        while (i >= 0) {
            dimensionPosition[i] = this.subDimensions[i].getRanges()[subdimensionIndex[i]].start + (int)bigInteger.and(BigInteger.valueOf(Integer.MAX_VALUE >> 31 - this.dimensionBitLength[i])).longValue();
            bigInteger = bigInteger.shiftRight(this.dimensionBitLength[i]);
            --i;
        }
        return dimensionPosition;
    }
}

