/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;

public class BirtEdgeView {
    private EdgeCursor edgeCursor;
    private BirtCubeView cubeView;
    private List dimensionViewList;
    private String name;
    private IEdgeDefinition edgeDefn;
    private static final String CALCULATED_MEMBER = "CALCULATED_MEMBER";

    public BirtEdgeView(BirtCubeView cubeView, IEdgeDefinition edgeDefn) {
        this.cubeView = cubeView;
        this.dimensionViewList = new ArrayList();
        this.edgeDefn = edgeDefn;
        this.populateDimensionView(edgeDefn);
        if (edgeDefn != null) {
            this.name = edgeDefn.getName();
        }
    }

    public BirtEdgeView(CalculatedMember calculatedMember) {
        this.name = CALCULATED_MEMBER + calculatedMember.getRsID();
    }

    private void populateDimensionView(IEdgeDefinition edgeDefn) {
        if (edgeDefn == null) {
            return;
        }
        Iterator dims = edgeDefn.getDimensions().iterator();
        while (dims.hasNext()) {
            IDimensionDefinition defn = (IDimensionDefinition)dims.next();
            BirtDimensionView view = new BirtDimensionView(defn);
            this.dimensionViewList.add(view);
        }
    }

    public EdgeCursor getEdgeCursor() {
        return this.edgeCursor;
    }

    public void setEdgeCursor(EdgeCursor edgeCursor) {
        this.edgeCursor = edgeCursor;
    }

    public BirtCubeView getOrdinateOwner() {
        return this.cubeView;
    }

    public List getDimensionViews() {
        return this.dimensionViewList;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasMirrored() {
        return this.edgeDefn != null && this.edgeDefn.getMirrorStartingLevel() != null;
    }

    public int getMirrorStartingLevel() {
        int index = 0;
        if (this.hasMirrored()) {
            ILevelDefinition[] levelArray = CubeQueryDefinitionUtil.getLevelsOnEdge(this.edgeDefn);
            int i = 0;
            while (i < levelArray.length) {
                if (levelArray[i].equals(this.edgeDefn.getMirrorStartingLevel())) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
        return index;
    }
}

