/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;

public class MeasureNameManager {
    private CalculatedMember[] members;

    MeasureNameManager(CalculatedMember[] members) {
        this.members = members;
    }

    public String getAggrName(int index) throws DataException {
        if (index >= this.members.length || index < 0) {
            throw new DataException("data.olap.measureNameNotFound");
        }
        return this.members[index].getName();
    }

    public int getAggregationResultID(String name) throws DataException {
        int rsID = -1;
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].getName().equals(name)) {
                rsID = this.members[i].getRsID();
                break;
            }
            ++i;
        }
        if (rsID == -1) {
            throw new DataException("data.olap.CannotGetMeasureValue", new Object[]{name});
        }
        return rsID;
    }

    public int getAggregationIndex(String name) throws DataException {
        int rsID = this.getAggregationResultID(name);
        int index = 0;
        if (rsID >= 0) {
            int i = 0;
            while (i < this.members.length) {
                if (this.members[i].getName().equals(name)) break;
                if (this.members[i].getRsID() == rsID && !this.members[i].getName().equals(name)) {
                    ++index;
                }
                ++i;
            }
        }
        return index;
    }

    public CalculatedMember getCalculatedMember(String name) throws DataException {
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].getName().equals(name)) {
                return this.members[i];
            }
            ++i;
        }
        throw new DataException("data.olap.CannotGetMeasureValue", new Object[]{name});
    }

    public CalculatedMember[] getCalculatedMembers() {
        return this.members;
    }
}

