/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class TopBottomDimensionFilterEvalHelper
extends BaseDimensionFilterEvalHelper
implements IJSTopBottomFilterHelper {
    private double N;
    private int filterType;
    private boolean isTop;
    private boolean isPercent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.util.filter.TopBottomDimensionFilterEvalHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopBottomDimensionFilterEvalHelper(Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter) throws DataException {
        if (!$assertionsDisabled && cubeFilter == null) {
            throw new AssertionError();
        }
        Context cx = Context.enter();
        try {
            this.initialize(parentScope, queryDefn, cubeFilter, cx);
            this.populateN(cx);
            this.popualteFilterType();
            this.argumentCheck();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        Context.exit();
    }

    private void argumentCheck() throws DataException {
        if (this.isPercent) {
            if (this.N < 0.0 || this.N > 100.0) {
                throw new DataException("data.engine.InvalidTopBottomPercentArgument");
            }
        } else if (this.N < 0.0) {
            throw new DataException("data.engine.InvalidTopBottomNArgument");
        }
    }

    private void populateN(Context cx) throws DataException {
        Object o = ScriptEvalUtil.evalExpr(((IConditionalExpression)this.expr).getOperand1(), cx, this.scope, null, 0);
        this.N = Double.valueOf(o.toString());
    }

    private void popualteFilterType() {
        int type = ((IConditionalExpression)this.expr).getOperator();
        switch (type) {
            case 14: {
                this.filterType = 1;
                this.isTop = true;
                this.isPercent = false;
                break;
            }
            case 16: {
                this.filterType = 3;
                this.isTop = true;
                this.isPercent = true;
                break;
            }
            case 15: {
                this.filterType = 2;
                this.isTop = false;
                this.isPercent = false;
                break;
            }
            case 17: {
                this.filterType = 4;
                this.isTop = false;
                this.isPercent = true;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object evaluateFilterExpr(IResultRow resultRow) throws DataException {
        Object object;
        this.dimObj.setResultRow(resultRow);
        this.dataObj.setResultRow(resultRow);
        Context cx = Context.enter();
        try {
            try {
                Object result;
                object = result = ScriptEvalUtil.evalExpr(((IConditionalExpression)this.expr).getExpression(), cx, this.scope, null, 0);
                Object var4_7 = null;
            }
            catch (BaseDimensionFilterEvalHelper.InMatchDimensionIndicator e) {
                throw new DataException(e.getMessage());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public DimLevel getTargetLevel() throws DataException {
        Set set = OlapExpressionCompiler.getReferencedDimLevel(this.expr, this.queryDefn.getBindings());
        if (set.size() != 1) {
            throw new DataException("Referenced dimension level set should contain only one level!");
        }
        DimLevel result = (DimLevel)set.iterator().next();
        return result;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public double getN() {
        return this.N;
    }

    public boolean isQualifiedRow(IResultRow resultRow) throws DataException {
        if (this.isAxisFilter) {
            int i = 0;
            while (i < this.axisLevels.length) {
                DimLevel level = new DimLevel(this.axisLevels[i]);
                if (CompareUtil.compare(resultRow.getFieldValue(level.toString()), this.axisValues[i]) != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isPercent() {
        return this.isPercent;
    }

    public boolean isTop() {
        return this.isTop;
    }
}

