/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ppt.device.PPTPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PPTRender
extends PageDeviceRender {
    private OutputStream pptOutput = null;
    public static final String REPORT_FILE = "Report.ppt";

    public PPTRender(IEmitterServices services) {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, IReportContext context, IReportContent report) throws Exception {
        try {
            return new PPTPageDevice(this.pptOutput);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getOutputFormat() {
        return "ppt";
    }

    public void initialize(IEmitterServices services) {
        this.services = services;
        IReportRunnable reportRunnable = services.getReportRunnable();
        if (reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.pptOutput = new FileOutputStream(file);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.logger.log(Level.WARNING, fnfe.getMessage(), fnfe);
        }
        if (this.pptOutput == null) {
            Object value = services.getOption("outputStream");
            if (value instanceof OutputStream) {
                this.pptOutput = (OutputStream)value;
            } else {
                try {
                    file = new File(REPORT_FILE);
                    this.pptOutput = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }
}

