/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1EncodableVector;
import com.lowagie.bc.asn1.ASN1Sequence;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DEREncodable;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERSet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1Set
extends DERObject {
    protected Vector set = new Vector();

    public static ASN1Set getInstance(Object object) {
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            DERSet dERSet = new DERSet(aSN1TaggedObject.getObject());
            return dERSet;
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Set) {
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((DEREncodable)enumeration.nextElement());
            }
            return new DERSet(aSN1EncodableVector);
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.set.elementAt(n);
    }

    public int size() {
        return this.set.size();
    }

    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)object;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.set.addElement(dEREncodable);
    }

    abstract void encode(DEROutputStream var1) throws IOException;
}

