/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.ILinkedResult;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataAdapterUtil {
    private static Map aggrAdapterMap = new HashMap();
    private static Map filterOptMap = new HashMap();

    static {
        DataAdapterUtil.registerAggregationFunction();
        DataAdapterUtil.registerFilterOperator();
    }

    private static void registerAggregationFunction() {
        aggrAdapterMap.put("sum", "SUM");
        aggrAdapterMap.put("count", "COUNT");
        aggrAdapterMap.put("min", "MIN");
        aggrAdapterMap.put("max", "MAX");
        aggrAdapterMap.put("average", "AVE");
        aggrAdapterMap.put("weighted-avg", "WEIGHTEDAVE");
        aggrAdapterMap.put("stddev", "STDDEV");
        aggrAdapterMap.put("first", "FIRST");
        aggrAdapterMap.put("last", "LAST");
        aggrAdapterMap.put("mode", "MODE");
        aggrAdapterMap.put("moving-ave", "MOVINGAVE");
        aggrAdapterMap.put("median", "MEDIAN");
        aggrAdapterMap.put("variance", "VARIANCE");
        aggrAdapterMap.put("running-sum", "RUNNINGSUM");
        aggrAdapterMap.put("irr", "IRR");
        aggrAdapterMap.put("mirr", "MIRR");
        aggrAdapterMap.put("npv", "NPV");
        aggrAdapterMap.put("running-npv", "RUNNINGNPV");
        aggrAdapterMap.put("count-distinct", "COUNTDISTINCT");
        aggrAdapterMap.put("running-count", "RUNNINGCOUNT");
        aggrAdapterMap.put("is-top-n", "ISTOPN");
        aggrAdapterMap.put("is-bottom-n", "ISBOTTOMN");
        aggrAdapterMap.put("is-top-n-percent", "ISTOPNPERCENT");
        aggrAdapterMap.put("is-bottom-n-percent", "ISBOTTOMNPERCENT");
        aggrAdapterMap.put("percent-rank", "PERCENTRANK");
        aggrAdapterMap.put("percentile", "PERCENTILE");
        aggrAdapterMap.put("quartile", "QUARTILE");
        aggrAdapterMap.put("percent-sum", "PERCENTSUM");
        aggrAdapterMap.put("rank", "RANK");
    }

    private static void registerFilterOperator() {
        filterOptMap.put("eq", new Integer(1));
        filterOptMap.put("ne", new Integer(2));
        filterOptMap.put("lt", new Integer(3));
        filterOptMap.put("le", new Integer(4));
        filterOptMap.put("ge", new Integer(5));
        filterOptMap.put("gt", new Integer(6));
        filterOptMap.put("between", new Integer(7));
        filterOptMap.put("not-between", new Integer(8));
        filterOptMap.put("is-null", new Integer(9));
        filterOptMap.put("is-not-null", new Integer(10));
        filterOptMap.put("is-true", new Integer(11));
        filterOptMap.put("is-false", new Integer(12));
        filterOptMap.put("like", new Integer(13));
        filterOptMap.put("top-n", new Integer(14));
        filterOptMap.put("bottom-n", new Integer(15));
        filterOptMap.put("top-percent", new Integer(16));
        filterOptMap.put("bottom-percent", new Integer(17));
        filterOptMap.put("match", new Integer(19));
        filterOptMap.put("not-like", new Integer(20));
        filterOptMap.put("not-match", new Integer(21));
        filterOptMap.put("in", new Integer(22));
    }

    public static void registerJSObject(Scriptable targetScope, ILinkedResult source) {
        int type = source.getCurrentResultType();
        if (type == 2) {
            targetScope.put("row", targetScope, (Object)new JSResultIteratorObject(source));
        } else if (type == 1) {
            Scriptable scope = ((ICubeCursor)source.getCurrentResult()).getScope();
            targetScope.put("data", targetScope, scope.get("data", scope));
            targetScope.put("dimension", targetScope, scope.get("dimension", scope));
            targetScope.put("measure", targetScope, scope.get("measure", scope));
        }
    }

    public static int adaptModelDataType(String modelDataType) {
        if (modelDataType == null) {
            return -1;
        }
        if (modelDataType.equals("any")) {
            return 0;
        }
        if (modelDataType.equals("integer")) {
            return 2;
        }
        if (modelDataType.equals("string")) {
            return 5;
        }
        if (modelDataType.equals("date-time")) {
            return 6;
        }
        if (modelDataType.equals("decimal")) {
            return 4;
        }
        if (modelDataType.equals("float")) {
            return 3;
        }
        if (modelDataType.equals("time")) {
            return 10;
        }
        if (modelDataType.equals("date")) {
            return 9;
        }
        if (modelDataType.equals("boolean")) {
            return 1;
        }
        if (modelDataType.equals("blob")) {
            return 7;
        }
        return -1;
    }

    public static String adapterToModelDataType(int apiDataType) {
        if (apiDataType == 2) {
            return "integer";
        }
        if (apiDataType == 5) {
            return "string";
        }
        if (apiDataType == 6) {
            return "date-time";
        }
        if (apiDataType == 4) {
            return "decimal";
        }
        if (apiDataType == 3) {
            return "float";
        }
        if (apiDataType == 9) {
            return "date";
        }
        if (apiDataType == 10) {
            return "time";
        }
        if (apiDataType == 1) {
            return "boolean";
        }
        if (apiDataType == 7) {
            return "blob";
        }
        return "any";
    }

    public static String adaptModelAggregationType(String modelAggrType) throws AdapterException {
        Object o = aggrAdapterMap.get(modelAggrType);
        return o == null ? modelAggrType : o.toString();
    }

    public static int adaptModelFilterOperator(String modelOpr) {
        Integer operator = (Integer)filterOptMap.get(modelOpr);
        if (operator != null) {
            return operator;
        }
        return 0;
    }

    public static int adaptModelSortDirection(String modelSortDir) {
        return "desc".equals(modelSortDir) ? 1 : 0;
    }

    public static String getRollUpAggregationName(String functionName) {
        if (functionName == null || functionName.trim().length() == 0) {
            return functionName;
        }
        String func = functionName;
        try {
            func = DataAdapterUtil.adaptModelAggregationType(functionName);
        }
        catch (AdapterException adapterException) {}
        if (func.equals("AVE") || func.equals("COUNT") || func.equals("COUNTDISTINCT")) {
            return "SUM";
        }
        return func;
    }

    private static class JSResultIteratorObject
    extends ScriptableObject {
        private static final long serialVersionUID = 684728008759347940L;
        private ILinkedResult it;
        private IResultIterator currentIterator;

        JSResultIteratorObject(ILinkedResult it) {
            this.it = it;
            if (it.getCurrentResultType() == 2) {
                this.currentIterator = (IResultIterator)it.getCurrentResult();
            }
        }

        public String getClassName() {
            return "JSResultIteratorObject";
        }

        public Object get(String arg0, Scriptable scope) {
            block5: {
                try {
                    if (this.currentIterator != null) break block5;
                    return null;
                }
                catch (BirtException birtException) {
                    return null;
                }
            }
            if ("__rownum".equalsIgnoreCase(arg0) || "0".equalsIgnoreCase(arg0)) {
                return new Integer(this.currentIterator.getRowIndex());
            }
            if ("_outer".equalsIgnoreCase(arg0)) {
                return new JSResultIteratorObject(this.it.getParent());
            }
            return this.currentIterator.getValue(arg0);
        }

        public Object get(int index, Scriptable start) {
            return this.get(String.valueOf(index), start);
        }
    }
}

