/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class DataSetNameRequiredValidator
extends AbstractElementValidator {
    private static final DataSetNameRequiredValidator instance = new DataSetNameRequiredValidator();

    public static DataSetNameRequiredValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof ScalarParameter)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (ScalarParameter)element);
    }

    private List doValidate(Module module, ScalarParameter toValidate) {
        String dataSetName;
        ArrayList<PropertyValueException> list = new ArrayList<PropertyValueException>();
        String labelExpr = toValidate.getStringProperty(module, "labelExpr");
        String valueExpr = toValidate.getStringProperty(module, "valueExpr");
        if (toValidate.getContainer() instanceof CascadingParameterGroup) {
            return list;
        }
        if (!(StringUtil.isBlank(labelExpr) && StringUtil.isBlank(valueExpr) || !StringUtil.isBlank(dataSetName = toValidate.getStringProperty(module, "dataSetName")))) {
            list.add(new PropertyValueException((DesignElement)toValidate, "dataSetName", null, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }
}

