/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class SimpleModuleNameContext
extends AbstractModuleNameContext {
    public SimpleModuleNameContext(Module module, int nameSpaceID) {
        super(module, nameSpaceID);
    }

    public List getElements(int level) {
        ArrayList elements = new ArrayList();
        elements.addAll(this.getNativeElements());
        NameSpace ns = null;
        List libraries = this.module.getLibraries(level);
        int i = 0;
        while (i < libraries.size()) {
            Library library = (Library)libraries.get(i);
            if (library.isValid()) {
                ns = library.getNameHelper().getNameSpace(this.nameSpaceID);
                elements.addAll(ns.getElements());
            }
            ++i;
        }
        return elements;
    }

    private ElementRefValue resolve(String elementName, int level) {
        NameSpace ns;
        DesignElement target;
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        Module moduleToSearch = this.module;
        if (namespace != null) {
            moduleToSearch = this.module.getLibraryWithNamespace(namespace, level);
        } else if (moduleToSearch instanceof Library) {
            namespace = ((Library)moduleToSearch).getNamespace();
        }
        if (moduleToSearch != null && (target = (ns = moduleToSearch.getNameHelper().getNameSpace(this.nameSpaceID)).getElement(name)) != null) {
            return new ElementRefValue(namespace, target);
        }
        return new ElementRefValue(namespace, name);
    }

    private ElementRefValue resolve(DesignElement element, int level) {
        if (element == null) {
            return null;
        }
        return this.doResolveElement(this.getElements(level), element);
    }

    private List getNativeElements() {
        ArrayList elements = new ArrayList();
        NameSpace ns = this.namespace;
        elements.addAll(ns.getElements());
        return Collections.unmodifiableList(elements);
    }

    private ElementRefValue doResolveElement(List elements, DesignElement element) {
        boolean isFound = false;
        int i = 0;
        while (i < elements.size()) {
            DesignElement tmpElement = (DesignElement)elements.get(i);
            if (tmpElement == element) {
                isFound = true;
                break;
            }
            ++i;
        }
        Module root = element.getRoot();
        String namespace = null;
        if (root instanceof Library) {
            namespace = ((Library)root).getNamespace();
        }
        if (!isFound) {
            return new ElementRefValue(namespace, element.getFullName());
        }
        return new ElementRefValue(namespace, element);
    }

    public ElementRefValue resolve(DesignElement element, PropertyDefn propDefn) {
        if (propDefn != null && ("theme".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()))) {
            return this.resolve(element, 1);
        }
        return this.resolve(element, Integer.MAX_VALUE);
    }

    public ElementRefValue resolve(String elementName, PropertyDefn propDefn) {
        if (propDefn != null && ("theme".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()))) {
            return this.resolve(elementName, 1);
        }
        return this.resolve(elementName, Integer.MAX_VALUE);
    }

    public DesignElement findElement(String elementName, IElementDefn elementDefn) {
        DesignElement element = this.resolve(elementName, Integer.MAX_VALUE).getElement();
        if (element == null) {
            return null;
        }
        if (elementDefn == null) {
            return element;
        }
        return element.getDefn().isKindOf(elementDefn) ? element : null;
    }
}

