/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageState
extends ReportItemState {
    protected ImageItem image;

    public ImageState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public ImageState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    public DesignElement getElement() {
        return this.image;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.image = new ImageItem();
        this.initElement(attrs);
    }

    private void checkImageType() {
        StructRefValue imageName;
        int type = 0;
        Module module = this.handler.getModule();
        String uri = (String)this.image.getLocalProperty(module, "uri");
        if (!StringUtil.isEmpty(uri)) {
            uri = StringUtil.trimQuotes(uri);
            try {
                new URL(uri);
                this.setProperty("source", "url");
            }
            catch (MalformedURLException malformedURLException) {
                this.setProperty("source", "file");
            }
            ++type;
        }
        if ((imageName = (StructRefValue)this.image.getLocalProperty(module, "imageName")) != null) {
            this.setProperty("source", "embed");
            ++type;
        }
        String typeExpr = (String)this.image.getLocalProperty(module, "typeExpr");
        String valueExpr = (String)this.image.getLocalProperty(module, "valueExpr");
        if (!StringUtil.isEmpty(typeExpr) || !StringUtil.isEmpty(valueExpr)) {
            this.setProperty("source", "expr");
            ++type;
        }
        if (type > 1) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.IMAGE_REF_CONFLICT")));
        }
    }

    public void end() throws SAXException {
        String name;
        String refType;
        Module module = this.handler.getModule();
        if (this.image.getLocalProperty(module, "source") == null && this.handler.versionNumber <= 3020300) {
            this.checkImageType();
        }
        if ("expr".equalsIgnoreCase(refType = this.image.getStringProperty(module, "source"))) {
            String valueExpr = this.image.getStringProperty(module, "valueExpr");
            if (StringUtil.isEmpty(valueExpr)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.INVALID_IMAGEREF_EXPR_VALUE")));
            }
        } else if ("url".equalsIgnoreCase(refType) || "file".equalsIgnoreCase(refType)) {
            String uri = this.image.getStringProperty(module, "uri");
            if (StringUtil.isEmpty(uri)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.INVALID_IMAGE_URL_VALUE")));
            }
        } else if ("embed".equalsIgnoreCase(refType) && StringUtil.isEmpty(name = this.image.getStringProperty(module, "imageName"))) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.INVALID_IMAGE_NAME_VALUE")));
        }
        super.end();
    }
}

