/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class LevelContentIterator
implements Iterator {
    protected static final int MAX_LEVEL = Integer.MAX_VALUE;
    List elementContents = null;
    protected int posn = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.LevelContentIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public LevelContentIterator(Module module, DesignElement element, int level) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        this.elementContents = new ArrayList();
        this.buildContentsList(module, element, level);
    }

    public LevelContentIterator(Module module, ContainerContext containerInfor, int level) {
        if (!$assertionsDisabled && containerInfor == null) {
            throw new AssertionError();
        }
        this.elementContents = new ArrayList();
        this.buildContentsList(module, containerInfor, level);
    }

    private void buildContentsList(Module module, DesignElement element, int level) {
        if (level < 0 || !element.getDefn().isContainer()) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        int i = 0;
        while (i < defn.getSlotCount()) {
            this.buildContentsList(module, new ContainerContext(element, i), level);
            ++i;
        }
        List properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            this.buildContentsList(module, new ContainerContext(element, ((PropertyDefn)properties.get(i2)).getName()), level);
            ++i2;
        }
    }

    private void buildContentsList(Module module, ContainerContext containerInfor, int level) {
        if (level <= 0) {
            return;
        }
        List contents = containerInfor.getContents(module);
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            DesignElement e = (DesignElement)iter.next();
            this.elementContents.add(e);
            this.buildContentsList(module, e, level - 1);
        }
    }

    public void remove() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean hasNext() {
        return this.posn < this.elementContents.size();
    }

    public Object next() {
        return this.elementContents.get(this.posn++);
    }
}

