/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;

public class CategoryProvider {
    public static final CategoryProvider UNKNOWN_CATEGORY = new CategoryProvider();
    public static final String ID_CATEGORY_UNKNOWN = "org.eclipse.datatools.connectivity.category.unknown";
    public static final String ATTR_ID = "id";
    public static final String ATTR_PARENTCATEGORY = "parentCategory";
    public static final String ATTR_NAME = "name";
    private String mName;
    private String mId;
    private String mParentCategory;

    public CategoryProvider(IConfigurationElement element) {
        this.init(element);
    }

    private CategoryProvider() {
        this.mName = ConnectivityPlugin.getDefault().getResourceString("Category.Name.Unknown");
        this.mId = ID_CATEGORY_UNKNOWN;
        this.mParentCategory = null;
    }

    private void init(IConfigurationElement element) {
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mParentCategory = element.getAttribute(ATTR_PARENTCATEGORY);
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public CategoryProvider getParent() {
        return ConnectionProfileManager.getInstance().getCategory(this.mParentCategory);
    }

    public List getChildCategories() {
        Map map = ConnectionProfileManager.getInstance().getCategories();
        Set set = map.keySet();
        ArrayList<CategoryProvider> list = new ArrayList<CategoryProvider>();
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            CategoryProvider cat = (CategoryProvider)map.get(id);
            if (cat.getParent() == null || !cat.getParent().getId().equalsIgnoreCase(this.mId)) continue;
            list.add(cat);
        }
        return list;
    }

    public ICategory createCategory(IConnectionProfileRepository repository) {
        return new Category(this, repository);
    }
}

