/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConfigurationType;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileMigrator;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ProfileRule;
import org.eclipse.datatools.connectivity.internal.CloseManagedConnectionJob;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.CreateConnectionJob;
import org.eclipse.datatools.connectivity.internal.CreateOfflineConnectionJob;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.ManagedConnection;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.datatools.connectivity.internal.PropertySetChangeEvent;
import org.eclipse.datatools.connectivity.internal.UUID;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;

public class ConnectionProfile
extends PlatformObject
implements IConnectionProfile {
    static final String PROPERTY_PREFIX = "org.eclipse.ui.workbench.progress";
    public static final QualifiedName NO_IMMEDIATE_ERROR_PROMPT_PROPERTY = new QualifiedName("org.eclipse.ui.workbench.progress", "delayErrorPrompt");
    private Map mPropertiesMap = new HashMap();
    private String mName;
    private String mDescription;
    private String mParentProfile = "";
    private boolean mAutoConnect = false;
    private String mProfileId;
    private ConnectionProfileProvider mProvider = null;
    private int mConnectionState = 0;
    private ListenerList mConnectListeners = new ListenerList();
    private ListenerList mPropertySetListeners = new ListenerList();
    private boolean mIsCreating;
    private String mInstanceID;
    private Map mFactoryIDToManagedConnection;
    private IConnectionProfileRepository mRepository;

    public ConnectionProfile(String name, String desc, String providerID) {
        this(name, desc, providerID, "", false);
    }

    public ConnectionProfile(String name, String desc, String providerID, String parentProfile) {
        this(name, desc, providerID, parentProfile, false);
    }

    public ConnectionProfile(String name, String desc, String providerID, String parentProfile, boolean autoConnect) {
        this(name, desc, providerID, parentProfile, autoConnect, null);
    }

    public ConnectionProfile(String name, String desc, String providerID, String parentProfile, boolean autoConnect, String instanceID) {
        this.mName = name;
        this.mDescription = desc;
        this.mProfileId = providerID;
        this.mProvider = (ConnectionProfileProvider)ConnectionProfileManager.getInstance().getProvider(this.mProfileId);
        this.mParentProfile = parentProfile;
        this.mAutoConnect = autoConnect;
        this.mIsCreating = true;
        this.mInstanceID = instanceID;
        this.initManagedConnections();
    }

    public String getName() {
        return this.mName;
    }

    public String getProfilePath() {
        if (this.mParentProfile == null) {
            return this.getName();
        }
        return ((ConnectionProfile)this.getParentProfile()).getProfilePath() + InternalProfileManager.PROFILE_PATH_SEPARATOR + this.getName();
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isAutoConnect() {
        return this.mAutoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.mAutoConnect = autoConnect;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public String getInstanceID() {
        if (this.mInstanceID == null) {
            this.mInstanceID = UUID.createUUID().toString();
        }
        return this.mInstanceID;
    }

    public IConnectionProfile getParentProfile() {
        if (this.mParentProfile == null || this.mParentProfile.length() == 0) {
            return null;
        }
        return ProfileManager.getInstance().getProfileByInstanceID(this.mParentProfile);
    }

    public IConnectionProfileRepository getRepository() {
        return this.mRepository;
    }

    public void setRepository(IConnectionProfileRepository repository) {
        this.mRepository = repository;
        this.mParentProfile = this.mRepository == null ? null : this.mRepository.getRepositoryProfile().getInstanceID();
    }

    public Properties getBaseProperties() {
        return this.getProperties(this.mProfileId);
    }

    public void setBaseProperties(Properties props) {
        this.setProperties(this.mProfileId, props);
    }

    public Properties getProperties(String type) {
        Properties retVal = new Properties();
        Properties props = (Properties)this.mPropertiesMap.get(type);
        if (props != null) {
            retVal.putAll((Map<?, ?>)props);
        }
        return retVal;
    }

    public void setProperties(String type, Properties props) {
        Properties oldProps = (Properties)this.mPropertiesMap.get(type);
        this.internalSetProperties(type, props);
        this.notifyManager();
        this.firePropertySetChangeEvent(type, oldProps, props);
    }

    public void internalSetProperties(String type, Properties props) {
        if (props == null) {
            this.mPropertiesMap.remove(type);
        } else {
            Properties newProps = new Properties();
            newProps.putAll((Map<?, ?>)props);
            this.mPropertiesMap.put(type, newProps);
        }
        InternalProfileManager.getInstance().setDirty(true);
    }

    public boolean arePropertiesComplete() {
        boolean retVal = this.mProvider.getPropertiesPersistenceHook().arePropertiesComplete((Properties)this.mPropertiesMap.get(this.mProfileId));
        Iterator it = this.getProfileExtensions().entrySet().iterator();
        while (retVal && it.hasNext()) {
            Map.Entry entry = it.next();
            ProfileExtensionProvider pep = (ProfileExtensionProvider)entry.getValue();
            retVal = pep.getPropertiesPersistenceHook().arePropertiesComplete((Properties)this.mPropertiesMap.get(entry.getKey()));
        }
        return retVal;
    }

    public boolean arePropertiesComplete(String type) {
        if (this.mProvider.getId().equals(type)) {
            return this.mProvider.getPropertiesPersistenceHook().arePropertiesComplete(this.getBaseProperties());
        }
        ProfileExtensionProvider pep = (ProfileExtensionProvider)this.mProvider.getProfileExtensions().get(type);
        if (pep != null) {
            return pep.getPropertiesPersistenceHook().arePropertiesComplete((Properties)this.mPropertiesMap.get(type));
        }
        return true;
    }

    public String getProviderName() {
        return this.mProvider.getName();
    }

    public String getProviderId() {
        return this.mProfileId;
    }

    public ICategory getCategory() {
        ICategory cat = this.mProvider.getCategory();
        IConnectionProfile parent = this.getParentProfile();
        if (parent == null || parent.getConnectionState() == 0) {
            return cat;
        }
        IManagedConnection imc = parent.getManagedConnection(IConnectionProfileRepository.class.getName());
        if (imc == null || !imc.isConnected()) {
            return cat;
        }
        IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
        return repo.getCategory(cat.getId());
    }

    public IConfigurationType getConfigurationType() {
        return this.mProvider.getConfigurationType();
    }

    public Map getProfileExtensions() {
        return this.mProvider.getProfileExtensions();
    }

    public IConnection createConnection(String factoryId) {
        return this.mProvider.getConnectionFactory(factoryId).createConnection(this);
    }

    public IConnection createConnection(String factoryId, String uid, String pwd) {
        return this.mProvider.getConnectionFactory(factoryId).createConnection(this, uid, pwd);
    }

    public IManagedConnection getManagedConnection(String type) {
        return (IManagedConnection)this.mFactoryIDToManagedConnection.get(type);
    }

    public IConnectionProfileProvider getProvider() {
        return this.mProvider;
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.connect();
        } else {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() {
        IConnectionProfileMigrator migrator = this.mProvider.getMigrator();
        if (migrator == null) {
            return;
        }
        boolean oldIsCreating = this.mIsCreating;
        this.mIsCreating = true;
        try {
            String newID = migrator.getNewProviderID();
            if (newID != null && !newID.equals(this.mProfileId)) {
                Properties baseProps = this.getBaseProperties();
                this.setBaseProperties(null);
                this.mProfileId = newID;
                this.mProvider = (ConnectionProfileProvider)ConnectionProfileManager.getInstance().getProvider(newID);
                this.setBaseProperties(baseProps);
                this.initManagedConnections();
            }
            migrator.performMigration(this);
        }
        finally {
            this.mIsCreating = oldIsCreating;
        }
    }

    public boolean isConnected() {
        return this.mConnectionState == 1;
    }

    public int getConnectionState() {
        return this.mConnectionState;
    }

    public IStatus connect() {
        Platform.getJobManager().cancel((Object)this);
        ConnectJob connectJob = new ConnectJob();
        connectJob.schedule();
        try {
            connectJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return connectJob.getResult();
    }

    public void connect(IJobChangeListener listener) {
        ConnectJob connectJob = new ConnectJob();
        if (listener != null) {
            connectJob.addJobChangeListener(listener);
        }
        connectJob.schedule();
    }

    public IStatus disconnect() {
        Platform.getJobManager().cancel((Object)this);
        DisconnectJob disconnectJob = new DisconnectJob();
        disconnectJob.schedule();
        try {
            disconnectJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return disconnectJob.getResult();
    }

    public void disconnect(IJobChangeListener listener) {
        DisconnectJob disconnectJob = new DisconnectJob();
        if (listener != null) {
            disconnectJob.addJobChangeListener(listener);
        }
        disconnectJob.schedule();
    }

    public boolean canWorkOffline() {
        boolean retVal = false;
        Iterator it = this.mFactoryIDToManagedConnection.values().iterator();
        while (!retVal && it.hasNext()) {
            retVal = ((ManagedConnection)it.next()).canWorkOffline();
        }
        return retVal;
    }

    public boolean supportsWorkOfflineMode() {
        boolean retVal = false;
        Iterator it = this.mFactoryIDToManagedConnection.values().iterator();
        while (!retVal && it.hasNext()) {
            retVal = ((ManagedConnection)it.next()).supportsWorkOfflineMode();
        }
        return retVal;
    }

    public IStatus workOffline() {
        Platform.getJobManager().cancel((Object)this);
        WorkOfflineJob workOfflineJob = new WorkOfflineJob();
        workOfflineJob.schedule();
        try {
            workOfflineJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return workOfflineJob.getResult();
    }

    public void workOffline(IJobChangeListener listener) {
        WorkOfflineJob workOfflineJob = new WorkOfflineJob();
        if (listener != null) {
            workOfflineJob.addJobChangeListener(listener);
        }
        workOfflineJob.schedule();
    }

    public IStatus saveWorkOfflineData() {
        SaveWorkOfflineDataJob saveWorkOfflineDataJob = new SaveWorkOfflineDataJob();
        saveWorkOfflineDataJob.schedule();
        try {
            saveWorkOfflineDataJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return saveWorkOfflineDataJob.getResult();
    }

    public void saveWorkOfflineData(IJobChangeListener listener) {
        SaveWorkOfflineDataJob saveWorkOfflineDataJob = new SaveWorkOfflineDataJob();
        if (listener != null) {
            saveWorkOfflineDataJob.addJobChangeListener(listener);
        }
        saveWorkOfflineDataJob.schedule();
    }

    public void addConnectListener(IConnectListener listener) {
        this.mConnectListeners.add((Object)listener);
    }

    public void removeConnectListener(IConnectListener listener) {
        this.mConnectListeners.remove((Object)listener);
    }

    public void addPropertySetListener(IPropertySetListener listener) {
        this.mPropertySetListeners.add((Object)listener);
    }

    public void removePropertySetListener(IPropertySetListener listener) {
        this.mPropertySetListeners.remove((Object)listener);
    }

    protected void firePropertySetChangeEvent(String type, Properties oldProps, Properties newProps) {
        if (oldProps == null) {
            oldProps = new Properties();
        }
        if (newProps == null) {
            newProps = new Properties();
        }
        PropertySetChangeEvent event = new PropertySetChangeEvent(this, type, oldProps, newProps);
        this.firePropertySetChangeEvent(event);
    }

    protected void firePropertySetChangeEvent(IPropertySetChangeEvent event) {
        if (event.getChangedProperties().size() == 0) {
            return;
        }
        Object[] listeners = this.mPropertySetListeners.getListeners();
        int count = listeners.length;
        for (int index = 0; index < count; ++index) {
            try {
                ((IPropertySetListener)listeners[index]).propertySetChanged(event);
                continue;
            }
            catch (Throwable e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    Map getPropertiesMap() {
        return Collections.unmodifiableMap(this.mPropertiesMap);
    }

    private void notifyManager() {
        if (!this.mIsCreating) {
            try {
                InternalProfileManager.getInstance().modifyProfile(this);
            }
            catch (ConnectionProfileException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    public void setCreated() {
        this.mIsCreating = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionProfile) {
            return obj == this || ((ConnectionProfile)obj).getInstanceID().equals(this.getInstanceID()) && ((ConnectionProfile)obj).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getInstanceID().hashCode();
    }

    public void dispose() {
        DisconnectJob disconnectJob = new DisconnectJob(true);
        disconnectJob.schedule();
        try {
            disconnectJob.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.mPropertySetListeners.clear();
        this.mConnectListeners.clear();
        Iterator it = this.mFactoryIDToManagedConnection.values().iterator();
        while (it.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)it.next();
            managedConnection.dispose();
        }
        this.mFactoryIDToManagedConnection.clear();
    }

    private void initManagedConnections() {
        Map connectionFactories = this.mProvider.getConnectionFactories();
        connectionFactories.remove("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        this.mFactoryIDToManagedConnection = new HashMap(connectionFactories.size());
        Iterator it = connectionFactories.keySet().iterator();
        while (it.hasNext()) {
            String factoryID = (String)it.next();
            this.mFactoryIDToManagedConnection.put(factoryID, new ManagedConnection(this, factoryID));
        }
    }

    private void addFailureMarker(IStatus result) {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("message", ConnectivityPlugin.getDefault().getResourceString("marker.error", new String[]{this.getName(), result.getMessage()}));
        map.put("severity", new Integer(2));
        map.put("location", this.getName());
        map.put("transient", Boolean.TRUE.toString());
        try {
            IMarker marker = resource.createMarker("org.eclipse.datatools.connectivity.ui.profileFailure");
            marker.setAttributes(map);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    private void removeOldFailureMarkers() {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] markers = resource.findMarkers("org.eclipse.datatools.connectivity.ui.profileFailure", true, 2);
            for (int i = 0; i < markers.length; ++i) {
                if (!markers[i].getAttribute("location", new String()).equals(this.getName())) continue;
                markers[i].delete();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public class SaveWorkOfflineDataJob
    extends Job {
        public SaveWorkOfflineDataJob() {
            super(ConnectivityPlugin.getDefault().getResourceString("SaveWorkOfflineDataJob.name", new Object[]{ConnectionProfile.this.getName()}));
            this.setUser(true);
            this.setSystem(false);
            this.setRule(new ProfileRule(ConnectionProfile.this));
        }

        protected IStatus run(IProgressMonitor monitor) {
            MultiStatus status = new MultiStatus(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), 0, ConnectivityPlugin.getDefault().getResourceString("SaveWorkOfflineDataJob.status"), null);
            monitor.beginTask(this.getName(), ConnectionProfile.this.mFactoryIDToManagedConnection.size() * 100);
            Iterator it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
            while (it.hasNext()) {
                ManagedConnection connection = (ManagedConnection)it.next();
                if (connection.supportsWorkOfflineMode()) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 4);
                    try {
                        connection.save((IProgressMonitor)subMonitor);
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                    }
                    subMonitor.done();
                    continue;
                }
                monitor.worked(100);
            }
            monitor.done();
            return status;
        }

        public boolean belongsTo(Object family) {
            return ConnectionProfile.this.equals(family);
        }
    }

    public class WorkOfflineJob
    extends Job {
        public WorkOfflineJob() {
            super(ConnectivityPlugin.getDefault().getResourceString("WorkOfflineJob.name", new Object[]{ConnectionProfile.this.getName()}));
            this.setUser(true);
            this.setSystem(false);
            this.setRule(new ProfileRule(ConnectionProfile.this));
        }

        protected IStatus run(IProgressMonitor monitor) {
            Iterator it;
            if (ConnectionProfile.this.getConnectionState() == 2) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(this.getName(), ConnectionProfile.this.mConnectListeners.size() + ConnectionProfile.this.mFactoryIDToManagedConnection.size() + 1);
            if (ConnectionProfile.this.getConnectionState() == 1) {
                Object[] listeners = ConnectionProfile.this.mConnectListeners.getListeners();
                ConnectEvent event = new ConnectEvent(ConnectionProfile.this);
                it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
                while (it.hasNext()) {
                    if (((ManagedConnection)it.next()).okToClose()) continue;
                    monitor.setCanceled(true);
                    return Status.CANCEL_STATUS;
                }
            }
            IProgressMonitor group = Platform.getJobManager().createProgressGroup();
            group.beginTask(this.getName(), -1);
            ArrayList<CreateOfflineConnectionJob> connectionJobs = new ArrayList<CreateOfflineConnectionJob>(ConnectionProfile.this.mFactoryIDToManagedConnection.size());
            it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
            while (it.hasNext()) {
                CreateOfflineConnectionJob connectionJob = new CreateOfflineConnectionJob((ManagedConnection)it.next(), (Object)this);
                connectionJob.setProgressGroup(group, -1);
                connectionJob.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                connectionJob.schedule();
                connectionJobs.add(connectionJob);
            }
            try {
                Platform.getJobManager().join((Object)this, null);
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ArrayList<IStatus> statuses = new ArrayList<IStatus>(connectionJobs.size());
            boolean someOK = false;
            int severity = 0;
            Iterator it2 = connectionJobs.iterator();
            while (it2.hasNext()) {
                CreateOfflineConnectionJob connectionJob = (CreateOfflineConnectionJob)((Object)it2.next());
                IStatus status = connectionJob.getResult();
                if (status.getSeverity() == 4) {
                    ConnectionProfile.this.addFailureMarker(status);
                } else {
                    someOK = someOK || status.getSeverity() == 0 || status.getSeverity() == 1;
                }
                severity |= status.getSeverity();
                statuses.add(status);
            }
            if (someOK) {
                int oldConnectionState = ConnectionProfile.this.mConnectionState;
                ConnectionProfile.this.mConnectionState = 2;
                Properties oldProperties = new Properties();
                Properties newProperties = new Properties();
                if (oldConnectionState == 1) {
                    oldProperties.setProperty("connected", Boolean.TRUE.toString());
                    newProperties.setProperty("connected", Boolean.FALSE.toString());
                }
                oldProperties.setProperty("connectionState", Integer.toString(oldConnectionState));
                newProperties.setProperty("connectionState", Integer.toString(2));
                ConnectionProfile.this.firePropertySetChangeEvent(new PropertySetChangeEvent(ConnectionProfile.this, IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET, oldProperties, newProperties));
            }
            monitor.worked(1);
            Object retVal = severity == 0 ? Status.OK_STATUS : new ConnectMultiStatus(4, statuses.toArray(new IStatus[statuses.size()]), ConnectivityPlugin.getDefault().getResourceString("WorkOfflineJob.status.error", new Object[]{ConnectionProfile.this.getName()}));
            monitor.done();
            return retVal;
        }

        public boolean belongsTo(Object family) {
            return ConnectionProfile.this.equals(family);
        }
    }

    private static class ConnectMultiStatus
    extends MultiStatus {
        public ConnectMultiStatus(int severity, IStatus[] newChildren, String message) {
            super(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, newChildren, message, null);
            this.setSeverity(severity);
        }
    }

    public class CloseConnectionEventJob
    extends Job {
        private IConnectListener mListener;
        private ConnectEvent mEvent;
        private Object mFamily;

        public CloseConnectionEventJob(IConnectListener listener, ConnectEvent event, Object family) {
            super(ConnectivityPlugin.getDefault().getResourceString("OpenConnectionEventJob.name", new Object[]{event.getConnectionProfile().getName()}));
            this.setSystem(true);
            this.mListener = listener;
            this.mEvent = event;
            this.mFamily = family;
        }

        public boolean belongsTo(Object family) {
            return this.mFamily != null && family == this.mFamily;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            monitor.beginTask(this.getName(), -1);
            try {
                this.mListener.closeConnection(this.mEvent);
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            monitor.done();
            return status;
        }
    }

    public class DisconnectJob
    extends Job {
        private boolean mForce;

        public DisconnectJob() {
            this(false);
        }

        public DisconnectJob(boolean force) {
            super(ConnectivityPlugin.getDefault().getResourceString("DisconnectJob.name", new Object[]{ConnectionProfile.this.getName()}));
            this.mForce = force;
            this.setUser(true);
            this.setSystem(false);
            this.setRule(new ProfileRule(ConnectionProfile.this));
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (ConnectionProfile.this.getConnectionState() == 0) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(this.getName(), ConnectionProfile.this.mConnectListeners.size() + ConnectionProfile.this.mFactoryIDToManagedConnection.size() + 1);
            Object[] listeners = ConnectionProfile.this.mConnectListeners.getListeners();
            ConnectEvent event = new ConnectEvent(ConnectionProfile.this);
            if (!this.mForce) {
                Iterator it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
                while (it.hasNext()) {
                    if (((ManagedConnection)it.next()).okToClose()) continue;
                    monitor.setCanceled(true);
                    return Status.CANCEL_STATUS;
                }
                int count = listeners.length;
                for (int index = 0; index < count; ++index) {
                    try {
                        if (!((IConnectListener)listeners[index]).okToClose(event)) {
                            monitor.setCanceled(true);
                            return Status.CANCEL_STATUS;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        ConnectivityPlugin.getDefault().log(e);
                    }
                }
            }
            IProgressMonitor group = Platform.getJobManager().createProgressGroup();
            group.beginTask(this.getName(), -1);
            ArrayList<CloseManagedConnectionJob> connectionJobs = new ArrayList<CloseManagedConnectionJob>(ConnectionProfile.this.mFactoryIDToManagedConnection.size());
            Iterator it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
            while (it.hasNext()) {
                ManagedConnection mc = (ManagedConnection)it.next();
                if (!mc.isConnected()) continue;
                CloseManagedConnectionJob connectionJob = new CloseManagedConnectionJob(mc, (Object)this);
                connectionJob.setProgressGroup(group, -1);
                connectionJob.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                connectionJob.schedule();
                connectionJobs.add(connectionJob);
            }
            ArrayList<CloseConnectionEventJob> connectionEventJobs = new ArrayList<CloseConnectionEventJob>(ConnectionProfile.this.mConnectListeners.size());
            int count = listeners.length;
            for (int index = 0; index < count; ++index) {
                CloseConnectionEventJob connectionEventJob = new CloseConnectionEventJob((IConnectListener)listeners[index], event, (Object)this);
                connectionEventJob.setProgressGroup(group, -1);
                connectionEventJob.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                connectionEventJob.schedule();
                connectionEventJobs.add(connectionEventJob);
            }
            try {
                Platform.getJobManager().join((Object)this, null);
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ArrayList<IStatus> statuses = new ArrayList<IStatus>(connectionJobs.size());
            int severity = 0;
            Iterator it2 = connectionJobs.iterator();
            while (it2.hasNext()) {
                CloseManagedConnectionJob connectionJob = (CloseManagedConnectionJob)((Object)it2.next());
                IStatus status = connectionJob.getResult();
                severity |= status.getSeverity();
                statuses.add(status);
            }
            int oldConnectionState = ConnectionProfile.this.mConnectionState;
            ConnectionProfile.this.mConnectionState = 0;
            Properties oldProperties = new Properties();
            Properties newProperties = new Properties();
            oldProperties.setProperty("connected", Boolean.TRUE.toString());
            newProperties.setProperty("connected", Boolean.FALSE.toString());
            oldProperties.setProperty("connectionState", Integer.toString(oldConnectionState));
            newProperties.setProperty("connectionState", Integer.toString(0));
            ConnectionProfile.this.firePropertySetChangeEvent(new PropertySetChangeEvent(ConnectionProfile.this, IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET, oldProperties, newProperties));
            monitor.worked(1);
            Object retVal = severity == 0 ? Status.OK_STATUS : new ConnectMultiStatus(4, statuses.toArray(new IStatus[statuses.size()]), ConnectivityPlugin.getDefault().getResourceString("DisconnectJob.status.info", new Object[]{ConnectionProfile.this.getName()}));
            monitor.done();
            return retVal;
        }

        public boolean belongsTo(Object family) {
            return ConnectionProfile.this.equals(family);
        }
    }

    public class OpenConnectionEventJob
    extends Job {
        private IConnectListener mListener;
        private ConnectEvent mEvent;
        private Object mFamily;

        public OpenConnectionEventJob(IConnectListener listener, ConnectEvent event, Object family) {
            super(ConnectivityPlugin.getDefault().getResourceString("OpenConnectionEventJob.name", new Object[]{event.getConnectionProfile().getName()}));
            this.setSystem(true);
            this.mListener = listener;
            this.mEvent = event;
            this.mFamily = family;
        }

        public boolean belongsTo(Object family) {
            return this.mFamily != null && family == this.mFamily;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            monitor.beginTask(this.getName(), -1);
            try {
                this.mListener.openConnection(this.mEvent);
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            monitor.done();
            return status;
        }
    }

    public class ConnectJob
    extends Job {
        public ConnectJob() {
            super(ConnectivityPlugin.getDefault().getResourceString("ConnectJob.name", new Object[]{ConnectionProfile.this.getName()}));
            this.setUser(true);
            this.setSystem(false);
            this.setRule(new ProfileRule(ConnectionProfile.this));
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (ConnectionProfile.this.getConnectionState() == 1) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(this.getName(), ConnectionProfile.this.mConnectListeners.size() + ConnectionProfile.this.mFactoryIDToManagedConnection.size() + 1);
            IProgressMonitor group = Platform.getJobManager().createProgressGroup();
            group.beginTask(this.getName(), -1);
            ArrayList<CreateConnectionJob> connectionJobs = new ArrayList<CreateConnectionJob>(ConnectionProfile.this.mFactoryIDToManagedConnection.size());
            Iterator it = ConnectionProfile.this.mFactoryIDToManagedConnection.values().iterator();
            while (it.hasNext()) {
                CreateConnectionJob connectionJob = new CreateConnectionJob((ManagedConnection)it.next(), (Object)this);
                connectionJob.setProgressGroup(group, -1);
                connectionJob.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                connectionJob.schedule();
                connectionJobs.add(connectionJob);
            }
            ArrayList<OpenConnectionEventJob> connectionEventJobs = new ArrayList<OpenConnectionEventJob>(ConnectionProfile.this.mConnectListeners.size());
            ConnectEvent event = new ConnectEvent(ConnectionProfile.this);
            Object[] listeners = ConnectionProfile.this.mConnectListeners.getListeners();
            int count = listeners.length;
            for (int index = 0; index < count; ++index) {
                OpenConnectionEventJob connectionEventJob = new OpenConnectionEventJob((IConnectListener)listeners[index], event, (Object)this);
                connectionEventJob.setProgressGroup(group, -1);
                connectionEventJob.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                connectionEventJob.schedule();
                connectionEventJobs.add(connectionEventJob);
            }
            try {
                Platform.getJobManager().join((Object)this, null);
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ConnectionProfile.this.removeOldFailureMarkers();
            ArrayList<IStatus> statuses = new ArrayList<IStatus>(connectionJobs.size());
            boolean someOK = false;
            int severity = 0;
            Iterator it2 = connectionJobs.iterator();
            while (it2.hasNext()) {
                CreateConnectionJob connectionJob = (CreateConnectionJob)((Object)it2.next());
                IStatus status = connectionJob.getResult();
                if (status.getSeverity() == 4) {
                    ConnectionProfile.this.addFailureMarker(status);
                } else {
                    someOK = someOK || status.getSeverity() == 0 || status.getSeverity() == 1;
                }
                severity |= status.getSeverity();
                statuses.add(status);
            }
            if (someOK) {
                int oldConnectionState = ConnectionProfile.this.mConnectionState;
                ConnectionProfile.this.mConnectionState = 1;
                Properties oldProperties = new Properties();
                Properties newProperties = new Properties();
                oldProperties.setProperty("connected", Boolean.FALSE.toString());
                newProperties.setProperty("connected", Boolean.TRUE.toString());
                oldProperties.setProperty("connectionState", Integer.toString(oldConnectionState));
                newProperties.setProperty("connectionState", Integer.toString(1));
                ConnectionProfile.this.firePropertySetChangeEvent(new PropertySetChangeEvent(ConnectionProfile.this, IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET, oldProperties, newProperties));
            }
            monitor.worked(1);
            Object retVal = severity == 0 ? Status.OK_STATUS : new ConnectMultiStatus(4, statuses.toArray(new IStatus[statuses.size()]), ConnectivityPlugin.getDefault().getResourceString("ConnectJob.status.error", new Object[]{ConnectionProfile.this.getName()}));
            monitor.done();
            return retVal;
        }

        public boolean belongsTo(Object family) {
            return ConnectionProfile.this.equals(family);
        }
    }
}

